/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Copyright (c) 2003, Snax
*/

#ifndef __WLANCAP_H
#define __WLANCAP_H

// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the WLANCAP_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// WLANCAP_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef WLANCAP_EXPORTS
#define WLANCAP_API __declspec(dllexport)
#else
#define WLANCAP_API __declspec(dllimport)
#endif

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

#include <windows.h>

#define RUNNING 1
#define STOPPING 2
#define PAUSED 3

#define SCAN 0x20

typedef struct WlanPacket_t {
   unsigned char byte1;
   unsigned char channel;
   unsigned short pLen;
   unsigned char data[]; //last four bytes are zeroed out crc
} WlanPacket;

typedef struct RingBuffer_t {
   int size;
   int a;
   int b;
   int currentIndex;
   HANDLE hEvent;
   HANDLE hVxD;
   int dummy1;
   int dummy2;
   int stats[12];
   unsigned char data[];
} RingBuffer;

typedef void* (*WincapCallback)(WlanPacket *ptr, unsigned int len, int val2, 
               __int64 timeStamp, int val3, void *userPtr); //return NULL to pause the thread

typedef struct Context_t {
   HANDLE hFileAdapter;
   WincapCallback cBack;
   int state;         //  2 = stopping, 0 = stopped, 3 = paused, 1 = running
   int ringSize;
   HANDLE hThread;
   HANDLE hEvent1;
   HANDLE hResumeEvent;
   RingBuffer *pRingBuffer;
   int wincapRequestResult1; 
   int wincapRequestResult2; 
   int channelMask;
   void *userData;
} Context;

typedef struct WincapReqBuffer_t {
   int result;
   unsigned char field_4[16];
   int field_14;
   int command;
   void *pDest;
   int destLength;
   int count;
   int field_28;
   unsigned char dataBuf[512];
} WincapReqBuffer;

typedef struct StatBuff_t {
   //48 bytes
   __int64 time;
   int stats[10];
} StatBuff;

WLANCAP_API BOOL WincapCleanupLibrary();
WLANCAP_API LONG WincapClose(HANDLE hFileAdapter);
WLANCAP_API Context *WincapCreateContext(HANDLE hFileAdapter, WincapCallback arg1, 
                                              int ringSize, int channelMask, void *userPtr);
WLANCAP_API LONG WincapDestroyContext(Context *pContext);
WLANCAP_API LONG WincapGetState(Context *pContext);
WLANCAP_API LONG WincapGetLastError();
WLANCAP_API RingBuffer *WincapGetPacketBuffer(Context *pContext);
WLANCAP_API LONG WincapSetPacketBuffer(Context *pContext, RingBuffer *pRingBuffer);
WLANCAP_API BOOL WincapGetPacketBufferStats(Context *pContext, StatBuff *pStatBuff);
WLANCAP_API unsigned __int64 WincapGetTimeStamp();  //64bit return in eax/edx
WLANCAP_API BOOL WincapInitializeLibrary();
WLANCAP_API BOOL WincapIsWindows2000();
WLANCAP_API BOOL WincapIsWindows9X();
WLANCAP_API BOOL WincapIsWindowsNT();
WLANCAP_API HANDLE WincapOpenAdapter(char *adapterName); //returns -1 on fail
WLANCAP_API BOOL WincapLoadDriver(char *displayName, char *binPathName, char *alternateName);
WLANCAP_API LONG WincapPause(Context *pContext);
WLANCAP_API LONG WincapPrivateRequest(HANDLE hFile, WincapReqBuffer *prb, LPOVERLAPPED overlapped);
WLANCAP_API LONG WincapRequest(HANDLE hFile, WincapReqBuffer *prb, LPOVERLAPPED overlapped);
WLANCAP_API LONG WincapResume(Context *pContext);
WLANCAP_API LONG WincapSetCaptureThreadPriority(Context *pContext, int priority);
WLANCAP_API LONG WincapStart(Context *pContext);
WLANCAP_API LONG WincapStop(Context *pContext);
WLANCAP_API void WincapSynchronizeTimeStamps();
WLANCAP_API BOOL WincapUnloadDriver();

#endif