node_num = 0


class Node:

    def __init__(self, name, children = None):
        self.name = name
        if children is not None:
            self.children = children
        self.selected = 0
        global node_num
        self.node_num = node_num
        node_num = node_num + 1

    def albatross_alias(self):
        return 'node%d' % self.node_num


def page_display(ctx):
    ctx.run_template('tree.html')


def page_process(ctx):
    if ctx.req_equals('paginate'):
        ctx.redirect('paginate')
    if not hasattr(ctx.locals, 'tree'):
        ctx.locals.tree \
            = Node('a', [Node('a', [Node('a'),
                                    Node('b')]),
                         Node('b', [Node('a', [Node('a', [Node('a'),
                                                          Node('b')])]),
                                    Node('b'),
                                    Node('c', [Node('a'),
                                               Node('b')])])])
        ctx.add_session_vars('tree')
