#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
#
# SessionServer functionality tests
#
# $Id: ses_server.py,v 1.7 2003/01/27 10:23:27 djc Exp $
#

import os, sys

try:
    base_dir = os.path.dirname(sys.modules[__name__].__file__)
except AttributeError:
    base_dir = ''
sys.path.insert(0, os.path.join(base_dir, '../../session-server'))

import unittest
import albatross

import request

class Vars:
    pass

class SessionServerApp(albatross.SessionServerAppMixin):
    def module_path(self):
        pass

class SessionServer(albatross.ResponseMixin, albatross.SessionServerContextMixin):
    """ 
    This corresponds to the object albatross users know as the ctx,
    although since we aren't using the normal set of mixins, we have to
    supply our own locals and request members.
    """
    def __init__(self, request):
        self.app = SessionServerApp('test')
        self.request = request
        self.locals = Vars()
        albatross.ResponseMixin.__init__(self)
        albatross.SessionServerContextMixin.__init__(self)

    def test_save(self):
        self.write_headers()
        self.save_session()

class Session:
    """
    This represents a virtual "user" - essentially just a place to store
    their session id while the ctx objects come and go.
    """
    def __init__(self):
        self.request = request.DummyCookieRequest()

    def new_context(self):
        return SessionServer(self.request)

class ServerCase(unittest.TestCase):
    def setUp(self):
        # We assume the user has started the session server - we don't
        # have a portable way to do this ourselves.
        pass

    def tearDown(self):
        pass

    def new_session(self):
        return Session()
