//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qdir.h>
#include <qpainter.h>
#include <qapplication.h>
#include <qkeysequence.h>

//Projectwide includes
#include "recentAlbumMenuItem.h"
#include "../backend/tools/imageTools.h"

//==============================================
RecentAlbumMenuItem::RecentAlbumMenuItem( Key acceleratorKey ) : QCustomMenuItem()
{
  this->acceleratorKey = acceleratorKey;
  changeItem( "unitialized", "unitialized", "unitialized" );
}
//==============================================
void RecentAlbumMenuItem::changeItem( QString albumName, 
                                      QString albumLocation,
                                      QString numPhotos )
{
  //set name, and number of photos
  this->albumName = albumName;
  this->numPhotos = numPhotos;
  
  //compute height
  QFontMetrics fm( qApp->font() );
  size.setHeight( 2 + fm.leading() + 2*fm.height() + 2);
  
  //attempt to set album image   
  QString albumImageLocation = QDir::convertSeparators( albumLocation + "/img/album.jpg" );
  QDir tempDir;
  if( tempDir.exists( albumImageLocation ) )
  {       
    //ideal image width assuming 4:3 aspect ratio
    idealImageWidth = (4 * (size.height()-4) ) / 3;
    
    //scale image
    scaleImage( albumImageLocation, albumImage, idealImageWidth, size.height() );
  }
  else
  {
    idealImageWidth = 0;
  }
  
  //compute menu entry width
  size.setWidth( idealImageWidth + 2 + fm.width(albumName) );
}
//==============================================
void RecentAlbumMenuItem::paint(  QPainter* p, 
                                  const QColorGroup&, 
                                  bool, bool, 
                                  int x, int y, int, int )
{
  //move down and right by two for spacing purposes
  y+=2;
  x+=2;
  int xOffset = 0;
  int yOffset = 0;

  //paint album image first if not null
  if(!albumImage.isNull())
  {
    p->drawImage( x + (idealImageWidth - albumImage.width()) / 2, 
                  y + (size.height() - albumImage.height() - 4)/2, 
                  albumImage );
    xOffset+=(idealImageWidth + 2);
  }
  
  //paint album name + photo count
  QFontMetrics fm( qApp->font() );
  yOffset+=fm.ascent();
  p->drawText( x+xOffset, y+yOffset, albumName ); 

  //if photo count available print it as well
  if(numPhotos.compare("-1") != 0)
  {
    yOffset+=fm.descent() + 1 + fm.leading() + fm.ascent();
    p->drawText( x+xOffset, y+yOffset, 
               qApp->translate("RecentAlbumMenuItem", "%1 Photos").arg(numPhotos) );
  }

  //paint accelerator key
  if( acceleratorKey != Key_unknown )
  {
    xOffset = maxWidth + 24;
    yOffset = fm.ascent() + fm.height()/2;
    QKeySequence seq( CTRL+acceleratorKey );
    QString str = (QString)seq;
    p->drawText( x+xOffset, y+yOffset,
                 str);
  }
}
//==============================================
QSize RecentAlbumMenuItem::sizeHint ()
{ return size; }
//==============================================
bool RecentAlbumMenuItem::fullSpan() const
{ return true; }
//==============================================
void RecentAlbumMenuItem::setMaxWidth( int val )
{ maxWidth = val; }
//==============================================