
option add *Radiobutton.overrelief raised
option add *Config.info*background white
option add *Config.info*foreground brown
option add *Config.view*Message.justify right
option add *Config.view*Message.anchor e
option add *Config.view*Message.aspect 500
option add *Config.view*Menubutton.relief sunken
option add *Config.view*Menubutton.background gray90
option add *Config.view*anchor w
option add *Config.Tablist.relief sunken

image create photo default -height 16 -width 16

variable basic_info [list description author]
proc Grep {lst} {
	grep x $lst {
		[array exists $x] && 
		(![info exists ${x}(type)] || 
		  [lsearch {action cache} [set ${x}(type)]]==-1)
	}
}

proc Description {meta} {
	if {[info exists ${meta}(description)]} {
		set text [set ${meta}(description)]
	} else { set text [string totitle [namespace tail $meta]] }
}

proc ConfigDialog {args} {
	variable basic_info
	variable changed
	set top .conf2
	if {![winfo exists $top]} { toplevel $top -class Config }
	raise $top
	wm title $top "Alicq configuration"
	grid [frame $top.list -class Tablist]\
		-row 0 -rowspan 3 -column 0  -sticky news -padx 2
	grid [frame $top.info] -row 0 -column 1 -sticky new
	grid [frame $top.view] -row 1 -column 1 -sticky news -padx 10 -pady 10
	grid [frame $top.btn] -row 2 -column 1 -sticky se -pady 10

	button $top.btn.apply -text [mc Apply] -command [nc Apply $top]
	button $top.btn.close -text [mc Close] -command [list destroy $top]
	grid $top.btn.apply $top.btn.close -padx 10

	trace variable changed w [nc ConfigureApply $top.btn.apply]
	set changed [list]

	grid columnconfigure $top 1 -weight 1
	grid rowconfigure $top 1 -weight 1
	grid rowconfigure $top.list 1000 -weight 1
	grid columnconfigure $top.info 1 -weight 1
	grid columnconfigure $top.view 1 -weight 1
	grid rowconfigure $top.view 1000 -weight 1

	# Create basic info widgets
	foreach x $basic_info {
		set txt [mc [string totitle $x]]:
		grid [label $top.info.k$x -text $txt -anchor e]\
		     [message $top.info.v$x -aspect 1000 -anchor nw] -sticky nwe 
	}
	
	set var [namespace current]::module
	foreach x [lsort [namespace children ::modules]] {
		# If no configurable parameters found, skip the module
		set lst [Grep [metainfo module $x]]
		if {![llength $lst] && 
		    ![info exists ${x}::meta::configuration-objects]} continue
		
		# Get readable module name
		set widget $top.list.mod[namespace tail $x]
		if {[info exists ${x}::meta::name]} {
			 set item [set ${x}::meta::name]
		} else { set item [string totitle [namespace tail $x]] }
		
		radiobutton $widget -text [mc $item] -indicatoron 0\
			-variable $var -value $x -anchor w

		# Display module icon, if it specified and can be displayed	
		if {[package vsatisfies [package present Tk] 8.4]} {
			if {[info exists ${x}::meta::icon]} {
				set img [set ${x}::meta::icon]
			} else { set img default }
		      	$widget configure -image $img
		}
		grid $widget -sticky new -ipadx 4 -ipady 4 
		set obj $x
	}
	bind $top.list <Destroy> [nc Close $top]
	if {[set $var]==""} {
		trace variable $var w [nc BasicInfo $top.info]
		trace variable $var w [nc MakePage $top.view]
		set $var $obj
	} else { set $var [set $var] }
}

# Apply changes
proc Apply {top args} {
	variable changed
	foreach x $changed { 
		if {[llength $x]==1} {
			set x [lindex $x 0]
			set $x [set $x.temporary]
		} elseif {[llength $x]==3} { eval ModifyObject $x }
	}
	set changed [list]
}

proc ModifyObject {action obj field} {
	set local ::tmpobj::$obj
	switch -exact $action {
		add { 
			new $obj [array get $local]
			trace variable $local w [nc ObjectChanged $obj]
		}
		delete { unset [ref $obj] }
		update { set [ref $obj]($field) [set ${local}($field)] }
	}
}

proc Close {top} {
	variable changed

	# Destroy existsing temporary variables
	foreach x $changed {
		if {[llength $x]==1} { unset [lindex $x 0].temporary }
	}
	# And temporary objects
	foreach x [info vars ::tmpobj::*] { unset $x }
	unset changed
}

proc ConfigureApply {apply args} {
	variable changed
	$apply configure -state [expr [llength $changed]?"normal":"disabled"]
}

proc BasicInfo {info name args} {
	upvar 1 $name ns
	variable basic_info
	foreach x $basic_info {
		if {[info exists ${ns}::meta::$x]} {
			set meta [set ${ns}::meta::$x]
		} else { set meta "" }
		$info.v$x configure -text [mc $meta]
	}
}

proc Parameters {view ns lst} {
	set prev ""
	foreach x [lsort -command comparator $lst] {
		upvar #0 $x meta
		set name [namespace tail $x]
		set group [lrange [string map {:: " "} $x] 2 end-2]
		if {$group!=$prev} {
			grid [frame $view.fake$group -height 20] -columnspan 2 -sticky ns
			grid [label $view.g$group -text [mc [string totitle $group]] -bg gray] -columnspan 2 -sticky news
			set prev $group
		}
		grid [message $view.k$name -text [mc [Description $x]]]\
		     [[seekType $x type] $view.w$name $x]\
			-sticky new -padx 2 -pady 2
		# Make temporary copy of configurable parameter and assign it
		# to the widget
		set var [meta2var $x]
		if {[info exists $var]} { set $var.temporary [set $var] }
		[seekType $x assign] $view.w$name $var.temporary
		trace variable $var.temporary w [nc TemporaryChanged $var]
	}
	return 1
}

proc TemporaryChanged {var args} {
	set changes [changes? $var [var2meta $var] [set $var.temporary]]
	UpdateChanged $changes [list $var]
}

proc ObjectChanged {obj local field op} {
	upvar 1 ${local}($field) tmp
	set changes [changes? [ref $obj]($field)\
		[metainfo object $obj $field] $tmp]
	UpdateChanged $changes [list update $obj $field]
}


proc UpdateChanged {changes value} {
	variable changed
	set pos [lsearch $changed $value]
	if {$changes && $pos==-1} {
		lappend changed $value 
	} elseif {!$changes && $pos!=-1} {
		set changed [lreplace $changed $pos $pos]
	}
}

namespace eval ::tmpobj {}

proc SeeScrollBar {name row col sticky first last} {
	$name set $first $last
	if {$last-$first==1 && [winfo viewable $name]} {
		grid remove $name
	} elseif {$last-$first<1 && ![winfo viewable $name]} {
		grid $name -row $row -column $col -sticky $sticky
	}
}

proc Objects {info id lst} {
	set prefix ::tmpobj::$id:
	set info [frame $info.info -relief flat]
	grid $info -sticky news -row 1 -column 1
	set list [ListBox $info.list -deltay 20\
		-yscrollcommand [nc SeeScrollBar $info.vsb 1 1 ns]\
		-xscrollcommand [nc SeeScrollBar $info.hsb 2 0 we]\
		-relief raised -bd 1]
	grid [label $info.list-title -text $id -bg gray -relief raised]\
		-row 0 -column 0 -sticky we
	grid [label $info.view-title -bg gray -relief raised] -row 0 -column 2 -sticky we
	scrollbar $info.vsb -orient vertical -command [list $list yview]
	scrollbar $info.hsb -orient horizontal -command [list $list xview]
	set view [frame $info.view -relief raised]
	set btn [frame $info.btn]
	set selscript [nc SelectObject $prefix $view.v $info.view-title $lst $list]
	button $btn.add -text [mc Add] -command\
		[nc AddObject $selscript $btn.delete $info.name $prefix $list $view]
	button $btn.delete -text [mc Delete] -state disabled -command\
		[nc DeleteObject $selscript $btn.delete $prefix $list $view]
	entry $info.name -vcmd [nc ValidName $btn.add $prefix %P]\
		-validate key
	$info.name validate

	grid $btn.add $btn.delete -padx 10 -pady 2
	grid $list -sticky news -row 1 -column 0
	grid $btn -row 3 -column 2 -sticky w
	grid $info.name -row 3 -column 0 -sticky we 
	grid rowconfigure $info 1 -weight 1
	grid columnconfigure $info 2 -weight 1
	grid columnconfigure $view 1 -weight 1
	grid rowconfigure $view 1000 -weight 1 
	foreach x [lsort -command comparator $lst] {
		upvar #0 $x meta
		set name [namespace tail $x]
		message $view.k$name -text [mc [Description $x]]
		[seekType $x type] $view.v$name $x
		grid $view.k$name $view.v$name -sticky new -padx 2 -pady 2
	}
	foreach obj [select $id] {
		set tmp ::tmpobj::$obj
		if {![info exists $tmp]} {
			array set $tmp [array get [ref $obj]]
			trace variable $tmp w [nc ObjectChanged $obj]
		}
		ShowObject $list $view $tmp
	}
	$list bindText <1> $selscript
	if {[info exists tmp]} { 
		$btn.delete configure -state normal
		grid $view -sticky news -row 1 -column 2
		eval $selscript [$list items 0] 
	}
}

proc comparator {var1 var2} {
	cmp [ifval ${var1}(weight) .5] [ifval ${var2}(weight) 0.5]
}

proc ifval {var def} { expr {[info exists $var]?[set $var]:[set def]} }
proc cmp {n1 n2} { expr { ($n1<$n2)?-1:(($n1>$n2)?1:0) } }

proc ValidName {btn prefix val} {
	set s normal
	if {$val==""||[info vars ${prefix}$val]!=""} { set s disabled }
	$btn configure -state $s
	expr { [string first " " $val]==-1 }
}

proc SelectObject {varprefix wprefix label meta list item} {
	$list selection set $item
	$list see $item
	$label configure -text $item
	foreach x $meta { 
		set name [namespace tail $x]
		[seekType $x assign] $wprefix$name $varprefix${item}($name) 
	}
}

proc ShowObject {list view x} {
	set name [lindex [split $x :] end]
	$list insert end $name -text $name -data $x
	return $name
}

proc AddObject {selscript btn entry prefix list view} {
	variable changed
	if {[set name [$entry get]]==""} return
	$entry delete 0 end
	array set $prefix$name [list]
	eval $selscript [list [ShowObject $list $view $prefix$name]]
	$btn configure -state normal
	if {![winfo viewable $view]} {
		grid $view -sticky news -row 1 -column 2
	}
	lappend changed [list add [namespace tail $prefix$name] {}]
}

proc DeleteObject {selscript btn prefix list view} {
	set item [$list selection get]
	if {$item==""} return
	set idx [$list index $item]
	$list delete $item
	
	variable changed
	set obj [namespace tail $prefix$item]
	
	# For newly created objects, delete proper record from 'changed' list
	set pos [lsearch $changed [list add $obj {}]]
	if {$pos!=-1} { set changed [lreplace $changed $pos $pos] }
	
	# For existing objects, remove all changes and put 'delete' record
	if {[array exists [ref $obj]]} {
		while {[set pos [lsearch $changed [list update $obj *]]]!=-1} {
			set changed [lreplace $changed $pos $pos]
		}
		lappend changed [list delete $obj {}]
	}

	# Select next item in the list
	set next [$list items $idx]
	if {$next==""} { set next [$list items end]}
	# If no items available, disable 'Delete' button
	if {$next==""} { 
		$btn configure -state disabled
		grid remove $view
	} else { eval $selscript $next }

	unset $prefix$item
}

proc MakePage {view name args} {
	upvar $name ns
	foreach x [winfo children $view] { destroy $x }
	# Check if module has configurable parameters
	set meta [Grep [metainfo module $ns]]
	if {[llength $meta]} { Parameters $view $ns $meta }
	# Check if module has configuration objects
	if {[info exists ${ns}::meta::configuration-objects]} {
		upvar #0 ${ns}::meta::configuration-objects id 
		set meta [Grep [metainfo object $id]]
		if {[llength $meta]} { Objects $view $id $meta }
	}
}

proc seekType {name prefix} {
	upvar #0 $name meta
	if {[info exists meta(type)]} { set types $meta(type) }
	lappend types {}
	foreach x $types {
		if {[info commands $prefix:$x]!=""} { return $prefix:$x }
	}
}

proc type: {name meta} { entry $name -vcmd [nc Valid $meta %P] -validate key }

proc assign: {name var} {
	$name configure -textvariable {}
	$name delete 0 end
	$name configure -textvariable $var
}

proc type:password {name meta} { entry $name -show * }

proc type:boolean {name meta} { checkbutton $name }
proc assign:boolean {name var} { $name configure -variable $var }

proc type:text {name meta} { text $name -wrap word -width 50 -height 6 }

proc assign:text {name var} {
	bind $name <<Modified>> {}
	$name delete 1.0 end
	if {[info exists $var]} { $name insert end [set $var] }
	$name edit modified 0
	bind $name <<Modified>> [nc syncvar $name $var]
}

proc type:variant {name meta} {
	if {[info exists ${meta}(values)]} {
		upvar #0 ${meta}(values) values
	} elseif {[info exists ${meta}(valuescript)]} {
		set values [eval [set ${meta}(valuescript)]]
	}
	if {[winfo exists $name.menu]} { destroy $name.menu }
	set res [menubutton $name -menu $name.menu -anchor w]
	menu $name.menu -tearoff no
	if {![info exists values]} { return $res }
	foreach val $values {
		$name.menu add radiobutton -label [mc $val] -value $val
	}
	set res
}

proc assign:variant {name var} {
	$name configure -textvariable {} -text {}
	$name configure -textvariable $var 
	set max [$name.menu index last]
	if {$max=="none"} return
	for {set i 0} {$i<=$max} {incr i} {
		$name.menu entryconfigure $i -variable $var
	}
}
proc type:hidden {args} { return -code continue }
set n [namespace current]
foreach x {action cache} { interp alias {} ${n}::type:$x {} ${n}::type:hidden }

proc Valid {meta val} { expr { ($val=="")?1:[valid $meta $val] } }

proc syncvar {widget var} {
	if {![$widget edit modified]} return
	set $var [string map [list "\n" " "] [$widget get 1.0 "end -1c"]]
	$widget edit modified 0
}

namespace eval meta {
	array set config {type action weight .70 menu Settings
		script ConfigDialog}
}

