# This module is part of Alicq instant messenger. 
# It is used to encrypt outgoing and decrypt incoming messages from contacts.
# 
# Author: Ihar Viraheichyk

# PGP encryption. Strong, but wery slow and works only with
# external gpg program.
namespace eval PGP {

namespace eval meta {
	array set passphrase { save change property Global:Crypt:PGP|Passphrase
		description "Passphrase to unlock secret PGP key"}
}

if {![info exists ::env(TMPDIR)]} { set ::env(TMPDIR) /tmp }

proc Encode {uid message} {
	set tmp [file join $::env(TMPDIR) alicq.[pid]]
	if {[catch {
		set f [open "|gpg --batch --yes -r [get $uid crypt:key] --armour -o $tmp -e" w]
		puts $f $message; close $f
		set f [open $tmp r]; set message [read -nonewline $f]; close $f
		#catch {file delete $tmp}
	} v]} {Event Error 0:80 "Encryption failed: $v"}
	return $message
}

proc Decode {uid message} {
	variable passphrase
	set tmp [file join $::env(TMPDIR) alicq1.[pid]]
	set tmp2 [file join $::env(TMPDIR) alicq2.[pid]]
	set f [open $tmp w]; puts $f $message; close $f
	if [file exists $tmp2] {file delete $tmp2}
	set output "Error decoding message"
	catch {
		set f [open "|gpg --batch --no-tty --yes --passphrase-fd 0 -r [get $uid crypt:key] --armour -o $tmp2 -d $tmp" w]
		puts $f $passphrase; close $f
		set f2 [open $tmp2 r]; set output [read -nonewline $f2]; close $f2
		puts "OUT: $output"
	}
	#catch {file delete $tmp $tmp2}
	return $output
}

proc Detect {message} {
	regexp -- {-----BEGIN PGP MESSAGE-----.*-----END PGP MESSAGE-----} $message
}

}
# Bitwise XOR encryption. Very simple, fast and weak, but sufficient 
# for most cases
namespace eval XOR {


# XOR two strings 
proc Xor {key start message} {
	if {![string length $key]} {return $message}
	set result {}
	for {set pos 0} {[binary scan $message @${pos}c c1]} {incr pos} {
		if {![binary scan $key @${start}c c2]} {
			set start 0; binary scan $key @${start}c c2
		} else {incr start}
		append result [binary format c [expr $c1^$c2]]
	}
	set result
}

proc Decode {uid message} {
	regexp "^---XOR begin:(\[0-9\]*)---\n(.*)\n---XOR end---$" $message s offset message
	encoding convertfrom utf-8 [Xor [get $uid crypt:key] $offset\
					[binary format H* $message]]
}
proc Encode {uid message} {
	set offset 0
	set result [Xor [get $uid crypt:key] $offset\
			[encoding convertto utf-8 $message]]
	binary scan $result H* result 
	return 	"---XOR begin:$offset---\n$result\n---XOR end---"
}
proc Detect {message} {regexp -- {^---XOR begin:[0-9]*---.*---XOR end---$} $message}

}

# Detect encryption method and decode message
filter Incoming Decrypt {type uid time message args} {
	if {$type!={text}} {
		return [concat [list $type $uid $time $message] $args]
	}
	foreach method [namespace children] {
		if {[llength [info procs ${method}::Detect]] &&\
		    [${method}::Detect $message]} {
			return [concat [list $type $uid $time\
			        [${method}::Decode $uid $message]] $args]
		}
	}
	concat [list $type $uid $time $message] $args
} 0.1

# Encrypt message if encryption method is set
filter Send Encrypt {type uid message} {
	if {[get $uid crypt:method none]!="none"&&$type=={text}} {
		set message [[get $uid crypt:method]::Encode $uid $message]
	}
	list $type $uid $message
} 0.9

namespace eval [ref Contact:ICQ]::meta {
	array set crypt:key { save change default no }
	array set crypt:method {type variant menu "Cryptography Method"
		save change default none }
}

set [ref Contact:ICQ]::meta::crypt:method(values)\
	[concat none [map x [namespace children] {namespace tail $x}]]

