
namespace eval groups {}

proc MenuItem {menu var object} {
	upvar #0 $var meta
	foreach x $meta(type) {
		if {[llength [info commands item:$x]]} {set cmd item:$x; break}
	}
	if {![info exists cmd]} return
	set menu [subcascade $menu [lrange $meta(menu) 0 end-1]]
	$cmd $menu $var $object
	$menu entryconfigure last -label [mc [lindex $meta(menu) end]]
}

proc subcascade {top items} {
        if {![llength $items]} {return $top}
        set ntop $top.mn[lindex $items 0]
        if {![winfo exists $ntop]} {
		menu $ntop -type normal -tearoff no
		$top add cascade -label [mc [lindex $items 0]] -menu $ntop
	}	
        subcascade $ntop [lrange $items 1 end]
}

proc item:action {menu var object} {
	upvar #0 $var meta
	
	set action [namespace tail $var]
	set root [namespace qualifiers [namespace qualifiers $var]]
	if {[info exists meta(script)]} {
		set cmd [list namespace inscope $root $meta(script)]
	} else {
		if {$object!=""} { 
			set cmd [list Event $object|$action]
		} else { set cmd [list Event $action] }
	}
	if {$object!=""} { set cmd [concat $cmd $object] }
	$menu add command -command $cmd
}

proc getvar {var object} {
	set name [namespace tail $var]
	set v [expr {$object==""?[meta2var $var]:"[namespace current]::${object}($name)"}]
	if {![info exists $v] && [info exists ${var}(default)]} {
		set $v [set ${var}(default)]
	}
	set v
}

proc item:boolean {menu var object} {
	$menu add checkbutton -variable [getvar $var $object]
}

proc item:variant {menu meta object} {
	if {[info exists ${meta}(values)]} {
		upvar #0 ${meta}(values) values
	} elseif {[info exists ${meta}(valuescript)]} {
		set values [eval [set ${meta}(valuescript)]]
	}
	if {![info exists values]} {set values ""}
	$menu add cascade -menu [ui::menu::variant\
		$menu.mn[namespace tail $meta] [getvar $meta $object] $values]
}

proc item:groups {menu var object} {
	upvar #0 ${var} meta
	set name [namespace tail $var]
	menu $menu.mn${name} -type normal
	foreach x [get $object Groups] { set groups::Group:common:$x 1 }
	foreach x [select Group:common] {
		$menu.mn${name} add checkbutton -label [get $x Alias]\
			-variable [namespace current]::groups::$x\
			-command [nc group $object [lindex [split $x :] end]]
	}
	$menu add cascade -menu $menu.mn${name}
}

proc group {uid group} {
	upvar #0 [ref $uid](Groups) groups
	if {[set groups::Group:common:$group]} {
		lappend $groups $group
	} else {
		set pos [lsearch $groups $groups]
		if {$pos!=-1}
	}
}

proc item:cache {args} { return -code break }

proc setif {var default} {
	upvar 1 $var n
	if {[info exists n]} { set n } else { set default }
}

proc weight {n1 n2} {
	foreach x {1 2} {
		set w$x [setif [set n${x}](weight) .5]
		set group$x [setif [set n${x}](menu) ""]
	}
	set r [expr {($w1<$w2)?-1:(($w1>$w2)?1:0)}]
	if {!$r} { set r [string compare $group1 $group2] }
	set r
}

proc onClose {menu object} {
	variable $object
	destroy $menu
	unset $object
}

# Sync changes with real object variable, if needed
proc onChange {object name key args} {
	upvar 1 ${name}($key) val
	set ref [ref $object]
	if {![info exists $ref]} return
	set var [metainfo object $object $key]
	if {[info exists ${var}(default)]} {
		upvar #0 ${var}(default) default
	} else { set default "" }
	if {[info exists ${ref}($key)] && [set ${ref}($key)]!=$val ||
	    ![info exists ${ref}($key)] && $val!=$default } {
			set ${ref}($key) $val
	}
}

handler Menu MakeMenu {menu {object ""} {context ""}} {
	set items [expr {($object=="")?[metainfo module]:[metainfo object $object]}]
	set items [grep x $items {
		[info exists ${x}(type)]&&[info exists ${x}(menu)] }]
	if {[winfo exists $menu]} { destroy $menu }
	menu $menu -type normal -tearoff no
	foreach x [lsort -command weight $items] { MenuItem $menu $x $object }
	# Prevent object variables locking by menu
	if {$object!=""} {
		variable $object
		array set $object [array get [ref $object]]
		trace variable $object w [nc onChange $object]
		bind $menu <Unmap> [list after idle [nc onClose %W $object]]
	}
}

