# (c) Aleksey Filutich, 2002        cactus@narod.ru   ICQ#61043410
#
# Tray module (for MS Windows platform only)

if {$::tcl_platform(platform) != "windows"} {
	error "This module can be used in Windows only"
}

package require Winico

proc LoadIcons {icon_path} {
	variable icons
	variable icon
	foreach name {online ffc away na occ dnd invisible offline} {
		set icons($name) [winico createfrom [file join $icon_path $name.ico]]
	}
	set icon [winico createfrom $icon_path/icq.ico]
}

proc SetIcons {} {
	variable icons
	variable icon
	variable tray_status
	winico setwindow . $icon big
	winico setwindow . $icons($tray_status) small
	winico taskbar add $icons($tray_status) -text "Alicq" -callback [nc tray_handler %m %X %Y]
}

proc tray_handler {msg x y} {
  switch -exact -- $msg {
	"WM_LBUTTONDBLCLK" {
     		wm state . [expr ([string equal [wm state .] normal])?"withdrawn":"normal"]
	}	
    	"WM_RBUTTONDOWN" {
		tree::PopupStatusMenu $x $y
    	} 
  }
}

handler MyStatus status {status} {
  variable icons
  variable tray_status
  winico taskbar delete $icons($tray_status)
  winico taskbar add $icons($status) -pos 0 -text "Alicq" -callback [nc tray_handler %m %X %Y]
  winico setwindow . $icons($status) small 0
  set tray_status $status
}

wm withdraw .
wm deiconify .
raise .

set tray_status offline 

# load icons
LoadIcons  data/ico
SetIcons
# Hide window instead of deletion
wm protocol . WM_DELETE_WINDOW {wm withdraw .}
