# Conver licq contact files to alicq format
#
# Copyright Ihar Viarheichyk (iverg@mail.ru) 2001,2002

package provide convert 0.8

namespace eval LicqConvert {

variable Contacts [list]
variable User [list]
# Retrieve user list 
proc GetLicqUsers {path} {
	variable Contacts
	foreach file [glob -directory $path "*.uin"] {	
		set uid [file root [file tail $file]]
		set alias $uid
		set fd [open $file]
		while {![eof $fd]} {
			gets $fd ln
			if {[regexp {Groups.User *= *(.*)$} $ln s groupid]} {
				set gid $groupid 
			}
			if {[regexp {Alias *= *(.*)$} $ln s icqalias]} {
				set alias $icqalias 
			}
		}
		close $fd
		if {![info exists gid]} { set gid 0 }
		set gr {}
		for {set i 1} {$gid!=0} {set gid [expr $gid>>1]; incr i} {
			if {[expr $gid&1]} {
				lappend gr $i
			}
		}
		if {$gr=={}} {set gr other}
		lappend Contacts "Contact $uid \{$alias\} \{$gr\}"
	}
}

# Get owner's UIN and password
proc GetLicqOwner {filename} {
	variable User
	set fd [open $filename r]
	set attributes {Uin Password Alias}
	while {![eof $fd]} {
		gets $fd ln
		foreach attr $attributes {
			if {[regexp "$attr *= *(.*)$" $ln s value]} {
				lappend User Global:ICQ:Info|$attr $value
			}
		}
	}
	close $fd
}

proc GetLicqGroups {filename} {
	variable Contacts
	set fd [open $filename r]
	while {![eof $fd]} {
		gets $fd ln
		if {[regexp {^Group([0-9])+\.name *= *(.*)$} $ln s id name]} {
			lappend Contacts "Group $id \{$name\}"
		}
	}
	close $fd

}

set licqbase [file join ~ .licq]
if {[file exists $licqbase]} {
	GetLicqGroups [file join $licqbase licq.conf]
	GetLicqUsers [file join $licqbase users]
	GetLicqOwner [file join $licqbase owner.uin]
	if {![info exists ::version]} {
		set NewUser []
		foreach {key val} $User {lappend NewUser "$key $val"}
		foreach str [concat $NewUser $Contacts] { puts $str}
	}	
}
}
