package provide AlicqWidgets 0.1

proc ScrolledTxt {name args} {
	set win [ScrolledWindow $name]
	$win setwidget [eval text $win.txt $args]
	set win
}
proc ButtonBar {wid buttons} {
	set top .[lindex [split $wid .] 1]
	frame $wid
	foreach item $buttons {
		foreach {Name Action HotKey state} $item {
			set b [button $wid.b$Name -text $Name -command $Action]
			if {$state=={disabled}} {
				$b configure -state disabled
			} else {
				if {$HotKey!={}} {bind $top $HotKey $Action}
			}
			pack $b -side left
		}
	}
	set wid
}

namespace eval ui {
proc subcascade {top items} {
        if {![llength $items]} {return $top}
        set ntop $top.mn[lindex $items 0]
        if {![winfo exists $ntop]} {
		menu $ntop -type normal -tearoff no
		$top add cascade -label [lindex $items 0] -menu $ntop
	}	
        subcascade $ntop [lrange $items 1 end]
}


namespace eval menu {
proc string {key label} {
	set top [toplevel .string-$key]
	wm title $top $label
	#wm geometry $top +[winfo pointerx $top]+[winfo pointery $top]
	set cmd "pset $key \[$top.en get\]; destroy $top"
	entry $top.en 
	$top.en insert end [pget $key]
	button $top.ok -text "Apply" -command $cmd
	bind $top <Return> $cmd
	bind $top <Escape> "destroy $top"
	pack $top.en $top.ok -side left -fill x -expand yes
	focus $top.en
}
proc variant {name var values} {
	menu $name -tearoff no
	foreach val $values {
		set lst [split $val :]
		[::ui::subcascade $name [lrange $lst 0 end-1]] add radiobutton\
			-label [lindex $lst end] -variable $var
	}
	set name
}
}

namespace eval frame { 
proc variant {name var values} {
	menubutton $name -textvariable $var
	$name configure -menu [::ui::menu::variant $name.mn $var $values]
	set name
}
proc password {name {var1 {}} {var2 {}}} {
	frame $name
	entry $name.e1 -show *
	entry $name.e2 -show *
	if {$var1!={}} {$name.e1 configure -textvariable $var1}
	if {$var2!={}} {$name.e2 configure -textvariable $var2}
	pack $name.e1 $name.e2 -expand yes -fill both
	set name
}
proc boolean {parent property} {
	checkbutton $parent.$property -variable [property::Variable $property]
}

}
}
