﻿
/*
	fügt dem Menü Ansicht > Symbolleisten und dem Kontextmenü der Symbolleisten eine Option hinzu
		=> Aufruf durch onpopupshowing-Handler der Menüs in aios.xul
*/
function aios_addToolbarMitem(aWhich) {
	aios_getObjects();

	var popup = document.getElementById('viewToolbarsMenu').firstChild;
	if(aWhich.id == "toolbar-context-menu") popup = document.getElementById('toolbar-context-menu');

	// Menuitem erzeugen
	var menuItem = document.createElement("menuitem");
	// toolbarid = TotalToolbar-Fix => ohne wird der Eintrag mehrmals angezeigt, weil das Menü nicht korrekt entleert wird
	menuItem.setAttribute("toolbarid", 'aios-toolbar');
	menuItem.setAttribute("observes", "aios-viewToolbar");
	menuItem.setAttribute("label", aios_toolbar.getAttribute('toolbarname'));

	// TotalToolbar => unnötige/unerwünschte Menuitems entfernen
	var mitems = popup.childNodes;
	for(var i = 0; i < mitems.length; i++) {
		if(mitems[i].tagName == "menuitem") {
			if(mitems[i].getAttribute('toolbarid') == "aios-toolbar") mitems[i].parentNode.removeChild(mitems[i]);
			if(mitems[i].getAttribute('toolbarid') == "aios-sbhtoolbar") mitems[i].parentNode.removeChild(mitems[i]);
		}
	}

	// AiOS-Toolbar einfügen
	popup.insertBefore(menuItem.cloneNode(true), popup.firstChild);
}


/*
	Breite der vertikalen Toolboxen freigeben bzw. festsetzen
		=> Aufruf durch aios_toggleToolbar(), aios_setToolbarView(), aios_setToolbarPos(), aios_customizeToolbar() und aios_BrowserFullScreen()
		=> Aufruf indirekt auch durch aios_initSidebar() => aios_setSidebarOrient() löst aios_setToolbarPos() aus
		=> per JS statt CSS, weil es wegen Themes dynamisch sein muß
*/
function aios_adjustToolboxWidth(aMode) {
	aios_getObjects();

	var tboxen = new Array('aios-toolbox-left', 'aios-toolbox-right');

	// erstmal alle Festlegungen löschen
	for(var tbox in tboxen) {
		aios_gElem(tboxen[tbox]).style.minWidth = "";
		aios_gElem(tboxen[tbox]).style.width = "";
		aios_gElem(tboxen[tbox]).style.maxWidth = "";
		aios_gElem(tboxen[tbox]).removeAttribute('width');
	}

	// wenn noch keine Festlegungen getroffen werden sollten, diese durch rekursiven Aufruf kurze Zeit später initiieren
	// verzögerter Aufruf sichert die einwandfreie Funktion
	if(!aMode) {
		window.setTimeout('aios_adjustToolboxWidth(true)', 100);
		return false;
	}

	// Breiten festlegen...
	var usedToolbox;
	var aiosOrient = fx_mainWindow.getAttribute('aiosOrient');
	var posMode = aios_toolbar.getAttribute('posMode');

	// Toolbox je nach Sidebar-Ausrichtung wählen
	if((aiosOrient == "left" && posMode == "1") || (aiosOrient == "right" && posMode == "2")) {
		usedToolbox = 'aios-toolbox-left';
	}
	else if((aiosOrient == "left" && posMode == "2") || (aiosOrient == "right" && posMode == "1")) {
		usedToolbox = 'aios-toolbox-right';
	}

	// usedToolbox ist false wenn die Toolbar innerhalb der Sidebar positioniert ist...
	if(usedToolbox) {
		var cStyle = document.defaultView.getComputedStyle(aios_gElem(usedToolbox), null);
		var myWidth = parseInt(cStyle.width) + parseInt(cStyle.paddingLeft) + parseInt(cStyle.paddingRight);
	}

	for(var tbox in tboxen) {
		// Breite für verwendete Toolbox feststzen
		if(tboxen[tbox] == usedToolbox) {
			aios_gElem(tboxen[tbox]).style.minWidth = myWidth + "px";
			aios_gElem(tboxen[tbox]).style.maxWidth = myWidth + "px";
		}
		// Breite für nicht verwendete Toolbox auf 0px festsetzen => ansonsten skaliert die Toolbox mit der Sidebar-Skalierung
		else {
			aios_gElem(tboxen[tbox]).style.minWidth = "0px";
			aios_gElem(tboxen[tbox]).style.maxWidth = "0px";
		}
	}

	return true;
}


/*
	Aktiviert/Deaktiviert die AiOS-Toolbar
		=> Aufruf durch Menüoption (Ansicht > Symbolleisten) und div. Tastenkombinationen initiiert durch aios_modKeys()
		=> Aufruf durch aios_observeSidebar(), aios_toggleOperaMode(), aios_toggleSidebar(), aios_controlSwitch(), aios_BrowserFullScreen
*/
function aios_toggleToolbar(aWhich) {
	aios_getObjects();

	var mode = (typeof aWhich == "boolean") ? aWhich : !aios_getBoolean(aWhich, 'checked');

	aios_toolbar.hidden = mode;

	// setting (collapsed) aus älteren Versionen (<= 0.7.8) rückgängig machen (war auf persist gesetzt)
	// mit collapsed ist die Sidebargröße nicht veränderbar, wenn die Toolbar deaktiviert ist (warum???)
	if(aios_toolbar.getAttribute('collapsed')) {
		aios_toolbar.removeAttribute('collapsed');
		document.persist(aios_toolbar.id, 'collapsed');
		aios_adjustToolboxWidth(false);
	}
}


/*
	Ansichtoptionen der Toolbars (AiOS-Toolbar, Sidebarheader-Toolbar) initialisieren
		=> Aufruf durch onpopupshowing-Handler der Kontextmenüs in aios.xul
*/
function aios_onToolbarPopupShowing(aWhich) {
	aios_getObjects();

	var mode;

	/*
		AiOS-Toolbar
	*/
	if(aWhich.id == "aios-toolbar-contextmenu") {

		// Schaltflächen-Modus
		mode = aios_toolbar.getAttribute('mode');

		switch(mode) {
			case "full": 	document.getElementById('aios-view-mitem1').setAttribute('checked', true); break;
			case "icons": 	document.getElementById('aios-view-mitem2').setAttribute('checked', true); break;
			case "full": 	document.getElementById('aios-view-mitem3').setAttribute('checked', true);
							document.getElementById('aios-view-mitem4').setAttribute('disabled', true); break;
		}

		// Icongröße
		document.getElementById('aios-view-mitem4').setAttribute('checked', aios_toolbar.getAttribute('iconsize') == "small");

		// Flexible Schaltflächen
		document.getElementById('aios-view-mitem5').setAttribute('checked', aios_toolbar.getAttribute('flexbuttons') == "true");

		// keine Konfigurationsmöglichkeiten in Mac OS X
		if(aios_appOS == "Darwin") {
			if(document.getElementById('aios-customize-separator'))
				document.getElementById('aios-toolbar-contextmenu').removeChild(document.getElementById('aios-customize-separator'));

			if(document.getElementById('aios-customize-mitem'))
				document.getElementById('aios-toolbar-contextmenu').removeChild(document.getElementById('aios-customize-mitem'));
		}
	}
	/*
		Sidebarheader-Toolbar
	*/
	else if(aWhich.id == "aios-sbhtoolbar-contextmenu") {

		// Schaltflächen-Modus => wird für CSS-Definitionen benötigt
		fx_sidebarHeader.setAttribute('mode', aios_gElem("aios-sbhtoolbar").getAttribute('mode'));

		// Icongröße
		document.getElementById('aios-sbhview-mitem4').setAttribute('checked', aios_gElem("aios-sbhtoolbar").getAttribute('iconsize') == "small");
		fx_sidebarHeader.setAttribute('iconsize', aios_gElem("aios-sbhtoolbar").getAttribute('iconsize'));

		// keine Konfigurationsmöglichkeiten in Mac OS X
		if(aios_appOS == "Darwin") {
			if(document.getElementById('aios-sbhcustomize-separator'))
				document.getElementById('aios-sbhtoolbar-contextmenu').removeChild(document.getElementById('aios-sbhcustomize-separator'));

			if(document.getElementById('aios-sbhcustomize-mitem'))
				document.getElementById('aios-sbhtoolbar-contextmenu').removeChild(document.getElementById('aios-sbhcustomize-mitem'));
		}
	}
}


/*
	stellt die Ansichtsoptionen der Symbolleisten ein
		=> Aufruf durch die Menüoptionen der Symbolleisten-Kontextmenüs
			=> viewMode 1 = Symbole und Text
			=> viewMode 2 = Symbole
			=> viewMode 3 = Text
			=> viewMode 4 = kleine Symbole an/aus
			=> viewMode 5 = flexible Buttons an/aus
*/
function aios_setToolbarView(aViewMode, aWhich) {
	aios_getObjects();

	var viewMode = aViewMode;


	// feststellen, welche Toolbar konfiguriert werden soll
	var elem = aWhich;
	while(elem.tagName != "popup") {
		elem = elem.parentNode;
	}

	var tbar, menuid;

	if(elem.id == "aios-toolbar-contextmenu") {
		tbar = aios_gElem("aios-toolbar");
		menuid = "view";
	}
	else {
		tbar = aios_gElem("aios-sbhtoolbar");
		menuid = "sbhview";
	}


	// Einstellungen vornehmen
	var set_property = "mode";
	var set_value = "full";

	// Modus: Symbole & Text, Symbole, Text
	if(viewMode <= 2) {
		if(viewMode == 2) set_value = "icons";
		document.getElementById('aios-'+menuid+'-mitem4').setAttribute('disabled', false);
	}
	else if(viewMode == 3) {
		set_value = "text";
		document.getElementById('aios-'+menuid+'-mitem4').setAttribute('disabled', true);
	}

	// Icongroesse
	if(viewMode == 4) {
		set_property = "iconsize";
		set_value = (aios_getBoolean('aios-'+menuid+'-mitem4', 'checked')) ? "small" : "large";
	}

	// Flexible Buttons
	if(viewMode == 5) {
		set_property = "flexbuttons";
		set_value = (aios_getBoolean('aios-'+menuid+'-mitem5', 'checked')) ? "true" : "false";
	}

	tbar.setAttribute(set_property, set_value);


	if(tbar == aios_gElem("aios-toolbar")) aios_adjustToolboxWidth(false);
	else fx_sidebarHeader.setAttribute(set_property, set_value);
}


/*
	Schaltflächen in der Sidebarheader-Symbolleiste aktivieren/deaktivieren
		=> Aufruf durch die Menüoptionen des Symbolleisten-Kontextmenüs
*/
function aios_enableSBHButton(aWhich) {
	document.getElementById('sbh-'+aWhich+'-button').hidden = !aios_getBoolean('aios-sbhview-'+aWhich, 'checked');
}


/*
	positioniert die AiOS- und die Sidebarheader-Toolbar
		=> Aufruf durch die Menüoptionen des Kontextmenüs und aios_setSidebarOrient()
		=> Aufruf indirekt auch durch aios_initSidebar() => aios_setSidebarOrient() löst aios_setToolbarPos() aus
			=> posMode 1 = links neben der Sidebar (vertikal)
			=> posMode 2 = rechts neben der Sidebar (vertikal)
			=> posMode 3 = über dem Sidebarheader (horizontal)
			=> posMode 4 = unter dem Sidebarheader (horizontal)
			=> posMode 5 = unter der Sidebar (horizontal)
*/
function aios_setToolbarPos(posMode) {
	aios_getObjects();

	var tbox, orient, button_flex, separator;

	if(!posMode) posMode = parseInt(aios_toolbar.getAttribute('posMode'));

	try {
		var sidebarOrient = aios_gPrefBranch.getIntPref('gen.orient');
	}
	catch(e) { }

	switch(posMode) {
		case 1: tbox = (sidebarOrient == 1) ? "aios-toolbox-left" : "aios-toolbox-right";
				orient = "vertical";
				break;

		case 2: tbox = (sidebarOrient == 1) ? "aios-toolbox-right" : "aios-toolbox-left";
				orient = "vertical";
				break;

		case 3: tbox = "aios-toolbox-sidebartop";
				orient = "horizontal";
				break;

		case 4: tbox = "aios-toolbox-sidebartop2";
				orient = "horizontal";
				break;

		case 5: tbox = "aios-toolbox-sidebarbottom";
				orient = "horizontal";
				break;
	}

	aios_toolbar.setAttribute('posMode', posMode);
	aios_toolbar.setAttribute('orient', orient);

	document.getElementById(tbox).appendChild(aios_toolbar);

	aios_adjustToolboxWidth(false);

	document.getElementById('aios-pos-mitem' + posMode).setAttribute('checked', true);

	// unteren Divider nur anzeigen, wenn auch die Toolbar unten platziert wird
	if(posMode != 5) document.getElementById('aios-sidebardivider-4').setAttribute('hidden', true);
	else document.getElementById('aios-sidebardivider-4').setAttribute('hidden', false);
}


/*
	Öffnet den Konfigurationsdialog
		=> Aufruf durch die Menüoptionen der Kontextmenüs
*/
var aiosInterval;
function aios_customizeToolbar(aWhich) {

	// feststellen, welche Toolbar konfiguriert werden soll
	var elem = aWhich;
	while(elem.tagName != "popup") {
		elem = elem.parentNode;
	}

	var tbar = (elem.id == "aios-toolbar-contextmenu") ? aios_gElem("aios-toolbar") : aios_gElem("aios-sbhtoolbar");
	var toolbox = document.getElementById(tbar.parentNode.id);

	toolbox.customizeDone = aios_customizeToolbarDone;
	document.getElementById('aios-customize-mitem').setAttribute("disabled", "true");

	// löst Reaktion auf Änderungen der Icongröße/Symbolanzeige im Anpassen-Dialog aus
	aiosInterval = window.setInterval("aios_adjustToolboxWidth(true)", 100);

	openDialog("chrome://global/content/customizeToolbar.xul", "CustomizeToolbar", "chrome,all,dependent", toolbox);
}


/*
	Schließt die Symbolleisten-Konfiguration ab
		=> Aufruf durch aios_customizeToolbar()
*/
function aios_customizeToolbarDone(aToolboxChanged) {
	if(document.getElementById('aios-customize-mitem'))
		document.getElementById('aios-customize-mitem').removeAttribute("disabled");

	window.clearInterval(aiosInterval);
	window.focus();
}