/*
 * Decompiled with CFR 0.152.
 */
package amap;

import java.util.List;
import java.util.Map;

public class Alignment {
    Map<String, String> seqs;
    Map<String, String> colors;
    List<String> keys;
    double nWeight;

    public Alignment(List<String> keys, Map<String, String> seqs, Map<String, String> colors, double nWeight) {
        this.keys = keys;
        this.seqs = seqs;
        this.colors = colors;
        this.nWeight = nWeight;
    }

    public List<String> getOrderedKeys() {
        return this.keys;
    }

    public Map<String, String> getSequences() {
        return this.seqs;
    }

    public Map<String, String> getColors() {
        return this.colors;
    }

    public double getWeight() {
        return this.nWeight;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Weight      = ");
        sb.append(new Double(this.nWeight).toString());
        sb.append("\n");
        for (String key : this.seqs.keySet()) {
            sb.append(key);
            sb.append("\t");
            sb.append(this.seqs.get(key));
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    public String toMultiFasta() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.keys) {
            sb.append(">");
            sb.append(key);
            sb.append("\n");
            sb.append(this.seqs.get(key));
            sb.append("\n");
        }
        return sb.toString();
    }
}

