# $Id: CLAMD.pm,v 1.1 2002/11/12 13:39:45 bengen Exp $

#
# Module for CLAMD daemon
#

package AMAVIS::AV::CLAMD;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;
use IO::Socket;

use vars qw(
	    $cfg_clamd_unix_socket
	    $cfg_clamd_inet_socket
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'CLAMD';

  my $cfg_clamd_socket=$AMAVIS::cfg->val('CLAMD', 'socket');
  if (! defined $cfg_clamd_socket) {
    writelog($args,LOG_CRIT, __PACKAGE__.": CLAMD socket not specified");
    return 0;
  }

  if (-S $cfg_clamd_socket) {
    $cfg_clamd_unix_socket = $cfg_clamd_socket;
  } else {
    $cfg_clamd_inet_socket = $cfg_clamd_socket;
  }

  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.\n");
  # Return successfully
  return 1;
}

# Called from AMAVIS.pm. Scanning takes place here.
sub scan {
  my $self = shift;
  my $args = shift;

  my $socket;

  if ($cfg_clamd_unix_socket) {
    $socket=IO::Socket::UNIX->new(Peer=>$cfg_clamd_unix_socket);
    if (!defined $socket) {
      writelog($args,LOG_CRIT, __PACKAGE__.
  	     ": Cannot connect to $cfg_clamd_unix_socket.");
      return 0;
    }
  } else {
    $socket=IO::Socket::INET->new($cfg_clamd_inet_socket);
    if (!defined $socket) {
      writelog($args,LOG_CRIT, __PACKAGE__.
  	     ": Cannot connect to $cfg_clamd_inet_socket.");
      return 0;
    }
  }

  my $scancmd="RAWSCAN $$args{directory}\n";
  $socket->syswrite($scancmd, length($scancmd)) or do {
    writelog($args,LOG_ERR, __PACKAGE__.": Write to socket failed.");
    return 0;
  };

  my $output;
  my $result=$socket->sysread($output, 10240);
  unless ($result) {
    writelog($args,LOG_ERR, __PACKAGE__.": Read from socket failed.");
    return 0;
  }
  $socket->close() or do {
    writelog($args,LOG_ERR, __PACKAGE__.": Closing socket failed");
    return 0;
  };

  my @outlines = split(/\r*\n/, $output);
  
  my %viruses;
  foreach my $outline (@outlines) {
    if ($outline !~ m,^$$args{directory}.*: OK$,) {
      if ($outline =~ m,^$$args{directory}.*: (.*) FOUND$,) {
	my $virus = $1;
	writelog($args,LOG_DEBUG, __PACKAGE__.": Virus found: $virus");
	unless($viruses{$virus}++) {
	  push @{$$args{'found_viruses'}{'CLAMD'}}, $virus;
	}
      } else {
	writelog($args,LOG_ERR,__PACKAGE__.": Unknown virus scanner output: $output");
	return 0;
      }
    }
  }

  if (scalar(keys(%viruses)) == 0) {
    writelog($args,LOG_DEBUG, __PACKAGE__.": No virusses found");
  }

  # Return successfully...
  return 1;
}

1;
