# $Id: drWeb.pm,v 1.2 2003/01/22 17:58:43 bengen Exp $

#
# Support for drWeb
#

package AMAVIS::AV::drWeb;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;
use IO::Socket;

use vars qw(
	    $cfg_oav_socket
	    $socket
	   );
#############################################################
# DrWeb Constants
use vars qw(
             $DRWEBD_DEMO_USAGE
             $DRWEBD_IN_FILE
             $DRWEBD_NO_MEMORY
             $DRWEBD_SOCKET_ERR
             $DRWEBD_SWRITE_ERR
             $DRWEBD_SREAD_ERR
             $DRWEBD_TIMEOUT
             $DERR_READ_ERR
             $DERR_WRITE_ERR
             $DERR_NOMEMORY
             $DERR_CRC_ERROR
             $DERR_READSOCKET
             $DERR_KNOWN_VIRUS
             $DERR_UNKNOWN_VIRUS
             $DERR_VIRUS_MODIFICATION
             $DERR_TIMEOUT
             $DERR_SYMLINK
             $DERR_NO_REGFILE
             $DERR_SKIPPED
             $DERR_TOO_BIG
             $DERR_TOO_COMPRESSED
             $DERR_BAD_CALL
             $DERR_EVAL_VERSION
             $DERR_SPAM_MESSAGE
             $DRWEBD_SCAN_CMD
             $DRWEBD_VERSION_CMD
             $DRWEBD_BASEINFO_CMD
             $DRWEBD_IDSTRING_CMD
             $DRWEBD_RETURN_VIRUSES
             $DRWEBD_RETURN_REPORT
             $DRWEBD_RETURN_CODES
             $DRWEBD_HEURISTIC_ON
             $DRWEBD_SPAM_FILTER
             $DRWEBD_DEFAULT_PORT
             $DRWEBD_DEFAULT_IP
             $DRWEBD_DEFAULT_TIMEOUT
             $DRWEBD_DEFAULT_OPTIONS
	);
#--------------------------------------------------------------------------
# error codes:
$DRWEBD_DEMO_USAGE  =  -1;
$DRWEBD_IN_FILE     =  -2;
$DRWEBD_NO_MEMORY   =  -3;
$DRWEBD_SOCKET_ERR  =  -4;
$DRWEBD_SWRITE_ERR  =  -5;
$DRWEBD_SREAD_ERR   =  -6;
$DRWEBD_TIMEOUT     =  -7;

#--------------------------------------------------------------------------
# Dr. Web daemon exit codes:
$DERR_READ_ERR         =  0x00001;
$DERR_WRITE_ERR        =  0x00002;
$DERR_NOMEMORY         =  0x00004;
$DERR_CRC_ERROR        =  0x00008;
$DERR_READSOCKET       =  0x00010;
$DERR_KNOWN_VIRUS      =  0x00020;
$DERR_UNKNOWN_VIRUS    =  0x00040;
$DERR_VIRUS_MODIFICATION= 0x00080;
$DERR_TIMEOUT          =  0x00200;
$DERR_SYMLINK          =  0x00400;
$DERR_NO_REGFILE       =  0x00800;
$DERR_SKIPPED          =  0x01000;
$DERR_TOO_BIG          =  0x02000;
$DERR_TOO_COMPRESSED   =  0x04000;
$DERR_BAD_CALL         =  0x08000;
$DERR_EVAL_VERSION     =  0x10000;
$DERR_SPAM_MESSAGE     =  0x20000;

#--------------------------------------------------------------------------
# Dr. Web daemon commands:
$DRWEBD_SCAN_CMD       =0x0001;
$DRWEBD_VERSION_CMD    =0x0002;
$DRWEBD_BASEINFO_CMD   =0x0003;
$DRWEBD_IDSTRING_CMD   =0x0004;

# DRWEBD_SCAN_FILE command flags:
$DRWEBD_RETURN_VIRUSES =0x0001;
$DRWEBD_RETURN_REPORT  =0x0002;
$DRWEBD_RETURN_CODES   =0x0004;
$DRWEBD_HEURISTIC_ON   =0x0008;
$DRWEBD_SPAM_FILTER    =0x0020;

#--------------------------------------------------------------------------
# defaults values:
$DRWEBD_DEFAULT_PORT    =  3000;
$DRWEBD_DEFAULT_IP      =  "127.0.0.1";
$DRWEBD_DEFAULT_TIMEOUT =  40;
$DRWEBD_DEFAULT_OPTIONS =  0x0000;

#############################################################

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'drWeb ScannerDaemon';
  $cfg_oav_socket = $AMAVIS::cfg->val('drWeb', 'socket');
  if ($cfg_oav_socket eq '') {
    writelog($args,LOG_CRIT, "Socket for drWeb not defined");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

# Called from AMAVIS.pm. Scanning takes place here.
sub scan {
  my $self = shift;
  my $args = shift;

  my $output ;
  my $dwstatus ;
  my $numviruces ;
  my $file;
  my $buff;

  writelog($args,LOG_DEBUG,"Scanning with drWeb");

  foreach my $filename (keys %{$$args{'contents'}})
    {
    $file="$$args{'directory'}/parts/$filename";
    $socket = IO::Socket::INET->new($cfg_oav_socket);
         unless (defined $socket) {
         writelog($args,LOG_ERR, __PACKAGE__.
	     ": Could not connect to ScannerDaemon: $!");
    return 0;
    }

   writelog($args,LOG_DEBUG,"Scanning file $file");
   $socket->write(pack("N N N/A* xxxx",$DRWEBD_SCAN_CMD,
                $DRWEBD_RETURN_VIRUSES|$DRWEBD_HEURISTIC_ON,
                $file) );
   $socket->read($buff,8);
   ($dwstatus,$numviruces) = unpack("N N",$buff);
     writelog($args,LOG_DEBUG,__PACKAGE__.
	     ": ScannerDaemon find [$numviruces] viruces");
   if ($numviruces > 0 ) 
     {
	$socket->read($output,4096);
        my @virusname  = unpack("N/A*",$output);
     writelog($args,LOG_DEBUG,__PACKAGE__.
	     ": ScannerDaemon find  viruces [".@virusname."]");
        @virusname = (undef) if !@virusname;  # just in case: make list nonnil
        push @{$$args{'found_viruses'}{'drWeb ScannerDaemon'}}, @virusname;
     }
   elsif ( ($dwstatus & ~$DERR_EVAL_VERSION)==0 )
     { # no errors, no viruses
       writelog($args,LOG_DEBUG,__PACKAGE__.
	     ": ScannerDaemon return code: OK");
     }
   elsif ( $dwstatus & ~($DERR_KNOWN_VIRUS | $DERR_UNKNOWN_VIRUS |
                 $DERR_VIRUS_MODIFICATION | $DERR_EVAL_VERSION) ) 
    {
    writelog($args,LOG_ERR,__PACKAGE__.
	     ": Virus scanner failure: ScannerDaemon - UNKNOWN STATUS (error code: $dwstatus)");
    $socket->close;
    return 0;
    }
    $socket->close;
  }
    # Return successfully...
  return 1;
}

1;
