# $Id: hbEDV.pm,v 1.8 2003/03/11 13:19:06 bengen Exp $

#
# H+BEDV AntiVir
#

package AMAVIS::AV::hbEDV;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_antivir_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;

  $cfg_antivir_binary = $AMAVIS::cfg->val('hbEDV', 'antivir');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_antivir_binary eq '') {
    writelog($args,LOG_CRIT, "Path to AntiVir not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_antivir_binary) {
    writelog($args,LOG_CRIT, "AntiVir ($cfg_antivir_binary) not executable");
    return 0;
  }
  push @{$$args{'virus_scanners'}}, 'H+BEDV AntiVir';
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.\n");
  # Return successfully
  return 1;
}

sub scan {
  my $self = shift;
  my $args = shift;

  my @output;
  my @found_viruses;
  my @command=($cfg_antivir_binary,
	       '-allfiles', '-noboot', '-s', '-z',
	       "$$args{directory}/parts");

  writelog($args,LOG_DEBUG,"Scanning with H+BEDV AntiVir");

  my $output_handle = cmd_pipe($args, @command);
  writelog($args,LOG_DEBUG, 'Ooutput from '.join(' ',@command));
  while(<$output_handle>) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG,$_);
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_antivir_binary\n");
  wait;
  my $errval = ($? >> 8);
  if ($errval != 0) {
        # Virus found
    if (($errval == 1) ||
	# No license key
	($errval == 214)) {
      my %uniq;
      foreach my $output (@output) {
	if ( $output =~ / ALERT: \[(.+) virus\]/g ) {
#	if ( $output =~ /virus \'(.+)\'/g ) {
	  unless($uniq{$1}++) {
	    push @found_viruses, $1;
	  }
	}
      }
      if ($#found_viruses >= 0) {
	@{$$args{'found_viruses'}{'H+BEDV AntiVir'}} = @found_viruses;
      }
    } else {
      writelog($args,LOG_ERR,"Virus scanner failure: $cfg_antivir_binary (error code: $errval)");
      # return ERROR
      return 0;
    }
  }
  # Return successfully
  return 1;
}

1;
