# $Id: Mail.pm,v 1.15 2003/03/05 20:21:10 bengen Exp $

#
# Module for extracting the plain body or MIME attachments from a mail file
#

package AMAVIS::Extract::Mail;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;
use MIME::Parser;
use IO::File;

use vars qw(
	    $cfg_mime_ignore_errors
	   );

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $$types{'message/rfc822'}=$self;
  $$types{'message/news'}=$self;
  $cfg_mime_ignore_errors=($AMAVIS::cfg->val('MIME','ignore errors') or 'yes');
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  return 1;
}


sub extract {
  my $self=shift;
  my $args=shift;
  my $filename=shift;
  writelog($args,LOG_DEBUG, "Attempting to unpack $filename as MIME compliant message");

  my $buffer;
  my $len;
  my $unpacked_size = 0;

  my $parser = new MIME::Parser;

  $parser->output_dir($$args{'directory'});
  # $parser->output_to_core(0);
  # $parser->tmp_recycling(1);
  # $parser->tmp_to_core(0);
  # $parser->output_prefix("msg");
  # $parser->use_inner_files(1);

  $parser->filer->ignore_filename(1);

  my $handle = IO::File->new("<$$args{'directory'}/parts/$filename");

  $parser->extract_nested_messages("REST");
  $parser->extract_uuencode(1);
  $parser->ignore_errors(1);

  my $entity = eval { $parser->parse($handle) };
  my $error = ($@ || $parser->last_error);
  if ($error) {
    my %errors = ();
    writelog($args,LOG_ERR,"MIME::Parser error string begin");
    foreach my $errorstring (split /\n/, $error) {
      if ($errorstring !~ /^ *$/) {
	writelog($args,LOG_ERR,"\"$errorstring\"");
	$errors{$errorstring}++;
      };
    }
    writelog($args,LOG_ERR,"MIME::Parser error string end");

    foreach (keys %errors) {
      # These messages often come from bounces from MTAs that don't
      # grok MIME and just cut off the message after n bytes or lines.
      unless ( /unexpected end of header$/ 
	       || /unexpected end of parts before epilogue$/ ) {
	# Return unsuccessfully
	if ($cfg_mime_ignore_errors ne 'yes') {
	  writelog($args,LOG_ERR,
		   "MIME::Parser error is fatal.");
	  $parser->filer->purge;
	  return 0;
	}
      }
    }
    writelog($args,LOG_ERR,
	     "MIME::Parser error is not fatal, proceeding further");
  }

  # Have a look at all parts of $entity, starting with $entity itself
  foreach my $part ($entity->parts_DFS()) {
    my $in_handle=$part->open('r') or next;
    if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
      writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
      $parser->filer->purge;
      return 0;
    }
    # Write entity to file unless empty
    my $securename=get_secure_filename($args);
    my $out_handle=IO::File->new(">$$args{'directory'}/parts/"
				 .$securename);
    while ($len=$in_handle->read($buffer, 4096)) {
      $out_handle->write($buffer, $len);
      $unpacked_size += $len;
      if ($$args{'unpacked_size'} + $unpacked_size >= $cfg_maxspace) {
	$in_handle->close();
	$out_handle->close();
	writelog($args,LOG_ERR, __PACKAGE__.": Unpacking takes too much space");
	$parser->filer->purge;
	return 0;
      }
    }
    $in_handle->close();
    $out_handle->close();
    $ {$$args{'contents'}}{$securename} = {};

    if (defined $part->mime_type) {
      $ {$ {$$args{'contents'}}{$securename}}{insecure_type}=$part->mime_type;
    }
    else {
      $ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
    }
  }
  $parser->filer->purge;
  $$args{'unpacked_size'} += $unpacked_size;
  return 1;
}

1;
