# $Id: DebugMTA.pm,v 1.11 2003/03/17 23:04:14 bengen Exp $

#
# Dummy MTA module for testing purposes
#
# This module is intended for use by administrators who are having
# troubles setting up AMaViS-ng and for developers who are trying to
# debug parts other than the MTA interfaces.
#

package AMAVIS::MTA::DebugMTA;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;
use IO::File;
use File::Path;

use vars qw(
	    $cfg_input_file
	    $cfg_output_file
	   );

sub init {
  my $self = shift;
  my $args = shift;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  $cfg_input_file=$AMAVIS::cfg->val("DebugMTA", "input file");
  $cfg_output_file=$AMAVIS::cfg->val("DebugMTA", "output file");
  # Return successfully
  return 1;
}

sub cleanup {
  my $self = shift;
  my $args = shift;
  return 1;
}
# Create directory for unpacking and inspecting message
sub create_unpack_dir() {
  my $directory = create_tmp_dir("$AMAVIS::cfg_unpack_dir/amavis-unpack-");
  return $directory;
}

# Create temp directory. Try creating $prefix[date]-[pid] 
# Return created dir or undef if unsuccessful after 10 tries
sub create_tmp_dir( $ ) {
  my $prefix = shift;
  my $i = 0;
  while (1) {
    my $tmpdir = sprintf("$prefix%.8x-%.4x",time,$$);
    unless (mkpath ($tmpdir, 0, 0770)) {
      if (++$i > 10) {
	return undef;
      }
      else {
	next;
      }
    }
    else {
      return $tmpdir;
    }
  }
}

# Create temp dir and write mail
sub get_directory($) {
  my $self = shift;
  my $args = shift;

  # Create temp directory
  my $directory = create_unpack_dir();
  mkdir "$directory/parts", 0777;
  
  # Open mailfile
  my $mail = IO::File->new($cfg_input_file)
    or return 0;

  # Open message file that is later going to be disected and scanned
  my $output = IO::File->new("+>$directory/email.txt");

  # Read message
  my $headers=1;
  $$args{'headers'}='';
  while (<$mail>) {
    if (/^ *$/) {
      $headers=0;
    }
    if ($headers==1) {
      $$args{'headers'}.=$_;
    }
    if (/^From: *(.*)$/) {
      $$args{'sender'}=$1;
      writelog($args,LOG_DEBUG, "Sender: $1");
    }
    if (/^To: *(.*)$/) {
      @$args{'recipients'}=split /\s*,\s*/,$1;
      writelog($args,LOG_DEBUG, "Recipients: $1");
    }
    print $output $_;
  }
  $mail->close();

  # Message file has been written, reset file pointer and put it into
  # the record.
  $output->seek(0,0);
  $$args{'filehandle'} = $output;
  $$args{'directory'} = $directory;
  # Success
  return 1;
}

sub accept_message($) {
  my $self = shift;
  my $args = shift;
  writelog($args,LOG_INFO, "Accepting message");

  (my $mail = IO::File->new(">>$cfg_output_file")) or return 0;

  while (my $line=$$args{'filehandle'}->getline()) {
    $mail->print($line);
  }
  $mail->close;

  return 1;
}

sub drop_message($) {
  my $self = shift;
  my $args = shift;
  writelog($args,LOG_WARNING, "Dropping message");
  return 1;
}

sub freeze_message( $ ) {
  my $self = shift;
  my $args = shift;
  writelog($args,LOG_WARNING, "Freezing message ");
  return 1;
}

sub send_message($) {
  my $self = shift;
  my $args = shift;
  my $messge = shift;
  my $sender = shift;
  my @recipients = @_;
  writelog($args,LOG_INFO, __PACKAGE__.
	   ": Mail sent from $sender to ".join(', ', @recipients));
  return 1;
}

1;
