# $Id: FPROTD.pm,v 1.4 2003/10/06 13:42:42 bengen Exp $

#
# Module for Fprotd daemon
#

package AMAVIS::AV::FPROTD;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;
use IO::Socket::INET;
use URI::Escape;

use vars qw(
	    $cfg_fprotd_socket
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'Fprotd';

  $cfg_fprotd_socket=$AMAVIS::cfg->val('Fprotd', 'socket');
  if (! defined $cfg_fprotd_socket) {
    writelog($args,LOG_CRIT, __PACKAGE__.": Fprotd socket not specified");
    return 0;
  }

  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.\n");
  # Return successfully
  return 1;
}

# Called from AMAVIS.pm. Scanning takes place here.
sub scan {
  my $self = shift;
  my $args = shift;

  my @options=('-dumb');
  my $output;

  my %uniq;
  my @virusname;
  foreach my $filename (keys %{$$args{'contents'}}) {
    writelog($args,LOG_DEBUG,__PACKAGE__.
	     ": Scanning $filename");
    my $socket=IO::Socket::INET->new($cfg_fprotd_socket);
    if (!defined $socket) {
      writelog($args,LOG_CRIT, __PACKAGE__.
	       ": Cannot connect to $cfg_fprotd_socket.");
      return 0;
    }
    my $line="GET ".uri_escape("$$args{'directory'}/parts/$filename").' '.
			       join(' ',@options)." HTTP/1.0\r\n\r\n";
    writelog($args,LOG_DEBUG,__PACKAGE__.": $line");
    $socket->print($line) or do {
      writelog($args,LOG_ERR, __PACKAGE__.": Write to socket failed.");
      return 0;
    };
    chomp($output = join('', $socket->getlines));

    if ($output=~/<summary.*>infected<\/summary>/i) {
      if ($output=~/<name>(.*)<\/name>/i) {
	writelog($args,LOG_INFO,__PACKAGE__.
		 ": $filename is infected with $1");
	push @virusname, $1;
      }
    }
  }

  foreach my $virus (@virusname) {
    unless($uniq{$virus}++) {
      push @{$$args{'found_viruses'}{'Fprotd'}}, $virus;
    }
  }

  # Return successfully...
  return 1;
}

1;
