# $Id: FSP.pm,v 1.7 2002/06/28 09:24:16 bengen Exp $

#
# Simple scanning routine using the File::Scan Perl module
#

package AMAVIS::AV::FSP;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;
use File::Scan 0.20;

use vars qw($fs);

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'File::Scan (Perl module)';
  $fs = File::Scan->new() or return 0;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

# Called from AMAVIS.pm. Scanning takes place here.
sub scan {
  my $self = shift;
  my $args = shift;
  my @found_viruses;

  writelog($args,LOG_DEBUG,"Scanning with File::Scan (Perl module)");

  foreach my $filename (keys %{$$args{'contents'}}) {
    my $virus = $fs->scan("$$args{'directory'}/parts/$filename");
    if ($virus) {
      push @found_viruses, $virus;
      writelog($args,LOG_INFO, __PACKAGE__.' found '.$virus);
    }
  }

  if ($#found_viruses >= 0) {
    my %uniq;
    foreach my $virus (@found_viruses) {
      unless($uniq{$virus}++) {
	push @{$$args{'found_viruses'}{'File::Scan (Perl module)'}}, $virus;
      }
    }
  }
  my $error;

  if ($error = $fs->error()) {
    writelog($args,LOG_ERR, __PACKAGE__.": $error");
    return 0;
  }

  # otherwise return successfully
  return 1;
}

1;
