# $Id: FSAV.pm,v 1.12 2003/12/11 14:00:04 bengen Exp $

#
# Module for F-Secure Antivirus/Linux
#

package AMAVIS::AV::FSAV;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_fsav_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'F-Secure Anti Virus';
  $cfg_fsav_binary = $AMAVIS::cfg->val('FSAV', 'fsav');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_fsav_binary eq '') {
    writelog($args,LOG_CRIT, "Path to FSAV not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_fsav_binary) {
    writelog($args,LOG_CRIT, "FSAV not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

sub scan {
  my $self = shift;
  my $args = shift;

  my @output;

#  push @{$$args{'virus_scanners'}}, 'F-Secure Anti Virus';

  writelog($args,LOG_DEBUG,"Scanning with FSAV");
  writelog($args,LOG_DEBUG,
	   "Output from $cfg_fsav_binary --dumb $$args{directory}/parts");
  my $output_handle = cmd_pipe($args, $cfg_fsav_binary, 
			       '--dumb', 
			       "$$args{directory}/parts");
  while(<$output_handle>) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG,$_);
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_fsav_binary\n");
  wait;
  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  if ($errval != 0) {
    if ($errval == 3 || $errval == 8) {
      my %uniq;
      foreach my $output (@output) {
	if ($output =~ /infection: (.+)/g || $output =~ /(?:Infected|Infection):\s*(\S+)/) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'F-Secure Anti Virus'}}, $1;
	  }
	}
      }
      # The errval indicates that a virus was found, so ensure that found_viruses is not empty.
      if (! defined $$args{'found_viruses'}{'F-Secure Anti Virus'} ) {
        writelog($args,LOG_ERR,"The output of $cfg_fsav_binary was unrecognized.");
        push @{$$args{'found_viruses'}{'F-Secure Anti Virus'}}, "[unrecognized output]";
      }
    } else {
      writelog($args,LOG_ERR,"Virus scanner failure: $cfg_fsav_binary (error code: $errval)");
      # return ERROR
      return 0;
    }
  }
  # Return successfully
  return 1;
}

1;
