/*
 *
 *  (c) COPYRIGHT INRIA 1999-2005
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/* Unicode Routines
 * Authors: I. Vatton (W3C/INRIA)
 *          R. Guetari (W3C/INRIA): previous version
 */

#include <stdlib.h>
#include <ctype.h>
#include "thot_gui.h"
#include "thot_sys.h"
#include "constmedia.h"
#include "typemedia.h"
#include "application.h"
#include "uconvert.h"

#include "JISX0201.h"
#include "JISX0208.h"
#include "JISX0212.h"
#include "GB2312.h"
#include "KSC5601.h"

extern unsigned long offset[6];

wchar_t ISO_SYMBOL_Map [] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
    0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
    0x0020, 0x0021, 0x2200, 0x0023, 0x2203, 0x0025, 0x0026, 0x220D,
    0x0028, 0x0029, 0x2217, 0x002B, 0x002C, 0x2212, 0x002E, 0x2044,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x2236, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
    0x2245, 0x0391, 0x0392, 0x03A7, 0x0394, 0x0395, 0x03A6, 0x0393,
    0x0397, 0x0399, 0x03D1, 0x039A, 0x039B, 0x039C, 0x039D, 0x039F,
    0x03A0, 0x0398, 0x03A1, 0x03A3, 0x03A4, 0x03A5, 0x03C2, 0x03A9,
    0x039E, 0x03A8, 0x0396, 0x005B, 0x2234, 0x005D, 0x22A5, 0x005F,
    0x0060, 0x03B1, 0x03B2, 0x03C7, 0x03B4, 0x03B5, 0x03D5, 0x03B3,
    0x03B7, 0x03B9, 0x03C6, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BF,
    0x03C0, 0x03B8, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03D6, 0x03C9,
    0x03BE, 0x03C8, 0x03B6, 0x007B, 0x007C, 0x007D, 0x223C, 0x007F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x03D2, 0x2032, 0x2264, 0x2215, 0x221E, 0x0192, 0x2663,
    0x2666, 0x2665, 0x2660, 0x2194, 0x2190, 0x2191, 0x2192, 0x2193,
    0x00B0, 0x00B1, 0x2033, 0x2265, 0x00D7, 0x221D, 0x2202, 0x2022,
    0x00F7, 0x2260, 0x2261, 0x2248, 0x2026, 0x2223, 0x2014, 0x21B5,
    0x2135, 0x2111, 0x211C, 0x2118, 0x2297, 0x2295, 0x2205, 0x2229,
    0x222A, 0x2283, 0x2287, 0x2284, 0x2282, 0x2286, 0x2208, 0x2209,
    0x2220, 0x2207, 0x00AE, 0x00A9, 0x2122, 0x220F, 0x221A, 0x22C5,
    0x00AC, 0x2227, 0x2228, 0x21D4, 0x21D0, 0x21D1, 0x21D2, 0x21D3,
    0x25CA, 0x27E8, 0x00AE, 0x00A9, 0x2122, 0x2211, 0x0000, 0x0000,
    0x0000, 0x2308, 0x0000, 0x230A, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x27E9, 0x222B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x2309, 0x0000, 0x230B, 0x0000, 0x0000, 0x0000, 0x0000,
};
#define ISO_SYMBOL_length sizeof(ISO_SYMBOL_Map) / sizeof(wchar_t)

/* Central Europe */
wchar_t ISO_8859_2_Map [] = {
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F,
    0x00A0, 0x0104, 0x02D8, 0x0141, 0x00A4, 0x013D, 0x015A, 0x00A7,
    0x00A8, 0x0160, 0x015E, 0x0164, 0x0179, 0x00AD, 0x017D, 0x017B,
    0x00B0, 0x0105, 0x02DB, 0x0142, 0x00B4, 0x013E, 0x015B, 0x02C7,
    0x00B8, 0x0161, 0x015F, 0x0165, 0x017A, 0x02DD, 0x017E, 0x017C,
    0x0154, 0x00C1, 0x00C2, 0x0102, 0x00C4, 0x0139, 0x0106, 0x00C7,
    0x010C, 0x00C9, 0x0118, 0x00CB, 0x011A, 0x00CD, 0x00CE, 0x010E,
    0x0110, 0x0143, 0x0147, 0x00D3, 0x00D4, 0x0150, 0x00D6, 0x00D7,
    0x0158, 0x016E, 0x00DA, 0x0170, 0x00DC, 0x00DD, 0x0162, 0x00DF,
    0x0155, 0x00E1, 0x00E2, 0x0103, 0x00E4, 0x013A, 0x0107, 0x00E7,
    0x010D, 0x00E9, 0x0119, 0x00EB, 0x011B, 0x00ED, 0x00EE, 0x010F,
    0x0111, 0x0144, 0x0148, 0x00F3, 0x00F4, 0x0151, 0x00F6, 0x00F7,
    0x0159, 0x016F, 0x00FA, 0x0171, 0x00FC, 0x00FD, 0x0163, 0x02D9
};
#define ISO_8859_2_length sizeof(ISO_8859_2_Map) / sizeof(wchar_t);

wchar_t ISO_8859_3_Map [] = {
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F,
    0x00A0, 0x0126, 0x02D8, 0x00A3, 0x00A4, 0x00A5, 0x0124, 0x00A7,
    0x00A8, 0x0130, 0x015E, 0x011E, 0x0134, 0x00AD, 0xFFFE, 0x017B,
    0x00B0, 0x0127, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x0125, 0x00B7,
    0x00B8, 0x0131, 0x015F, 0x011F, 0x0135, 0x00BD, 0xFFFE, 0x017C,
    0x00C0, 0x00C1, 0x00C2, 0xFFFE, 0x00C4, 0x010A, 0x0108, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0xFFFE, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x0120, 0x00D6, 0x00D7,
    0x011C, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x016C, 0x015C, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0xFFFE, 0x00E4, 0x010B, 0x0109, 0x00E7, 
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0xFFFE, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x0121, 0x00F6, 0x00F7,
    0x011D, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x016D, 0x015D, 0x02D9
};
#define ISO_8859_3_length sizeof(ISO_8859_3_Map) / sizeof(wchar_t);

/* Baltic RIM */
wchar_t ISO_8859_4_Map [] = {
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F,
    0x00A0, 0x0104, 0x0138, 0x0156, 0x00A4, 0x0128, 0x013B, 0x00A7,
    0x00A8, 0x0160, 0x0112, 0x0122, 0x0166, 0x00AD, 0x017D, 0x00AF,
    0x00B0, 0x0105, 0x02DB, 0x0157, 0x00B4, 0x0129, 0x013C, 0x02C7,
    0x00B8, 0x0161, 0x0113, 0x0123, 0x0167, 0x014A, 0x017E, 0x014B,
    0x0100, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x012E,
    0x010C, 0x00C9, 0x0118, 0x00CB, 0x0116, 0x00CD, 0x00CE, 0x012A,
    0x0110, 0x0145, 0x014C, 0x0136, 0x00D4, 0x00D5, 0x00D6, 0x00D7, 
    0x00D8, 0x0172, 0x00DA, 0x00DB, 0x00DC, 0x0168, 0x016A, 0x00DF,
    0x0101, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x012F,
    0x010D, 0x00E9, 0x0119, 0x00EB, 0x0117, 0x00ED, 0x00EE, 0x012B,
    0x0111, 0x0146, 0x014D, 0x0137, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x0173, 0x00FA, 0x00FB, 0x00FC, 0x0169, 0x016B, 0x02D9
};
#define ISO_8859_4_length sizeof(ISO_8859_4_Map) / sizeof(wchar_t);

/* Cyrillic */
wchar_t ISO_8859_5_Map [] = {
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F,
    0x00A0, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407,
    0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x00AD, 0x040E, 0x040F,
    0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
    0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,
    0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
    0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
    0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
    0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F,
    0x2116, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457,
    0x0458, 0x0459, 0x045A, 0x045B, 0x045C, 0x00A7, 0x045E, 0x045F
};
#define ISO_8859_5_length sizeof(ISO_8859_5_Map) / sizeof(wchar_t);

/* Arabic ISO Latin encoding */
wchar_t ISO_8859_6_Map [] = {
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F,
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x060C, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00BA, 0x061B, 0x00BC, 0x00BD, 0x00BE, 0x061F,
    0x00C0, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627,
    0x0628, 0x0629, 0x062A, 0x062B, 0x062C, 0x062D, 0x062E, 0x062F,
    0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637,
    0x0638, 0x0639, 0x063A, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
    0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647,
    0x0648, 0x0649, 0x064A, 0x064B, 0x064C, 0x064D, 0x064E, 0x064F,
    0x0650, 0x0651, 0x0652, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF
};
#define ISO_8859_6_length sizeof(ISO_8859_6_Map) / sizeof(wchar_t);

/* Greek */
wchar_t ISO_8859_7_Map [] = {
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F, 
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F, 
    0x00A0, 0x2018, 0x2019, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x2015, 
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x0384, 0x0385, 0x0386, 0x00B7, 
    0x0388, 0x0389, 0x038A, 0x00BB, 0x038C, 0x00BD, 0x038E, 0x038F, 
    0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 
    0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F, 
    0x03A0, 0x03A1, 0x00D2, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 
    0x03A8, 0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF, 
    0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 
    0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF, 
    0x03C0, 0x03C1, 0x03C2, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 
    0x03C8, 0x03C9, 0x03CA, 0x03CB, 0x03CC, 0x03CD, 0x03CE, 0x00FF
};
#define ISO_8859_7_length sizeof(ISO_8859_7_Map) / sizeof(wchar_t);

/* Hebrew */
wchar_t ISO_8859_8_Map [] = {
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F, 
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F, 
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00D7, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x203E,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00F7, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x2017, 
    0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4, 0x05D5, 0x05D6, 0x05D7,
    0x05D8, 0x05D9, 0x05DA, 0x05DB, 0x05DC, 0x05DD, 0x05DE, 0x05DF,
    0x05E0, 0x05E1, 0x05E2, 0x05E3, 0x05E4, 0x05E5, 0x05E6, 0x05E7,
    0x05E8, 0x05E9, 0x05EA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF
};
#define ISO_8859_8_length sizeof(ISO_8859_8_Map) / sizeof(wchar_t);

/* Turkish */
wchar_t ISO_8859_9_Map [] = {
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F,
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x011E, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x0130, 0x015E, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0x011F, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x0131, 0x015F, 0x00FF
};
#define ISO_8859_9_length sizeof(ISO_8859_9_Map) / sizeof(wchar_t);

wchar_t ISO_8859_13_Map [] = {
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F,
    0x00A0, 0x201D, 0x00A2, 0x00A3, 0x00A4, 0x201E, 0x00A6, 0x00A7,
    0x00D8, 0x00A9, 0x0156, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00C6,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x201C, 0x00B5, 0x00B6, 0x00B7,
    0x00F8, 0x00B9, 0x0157, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00E6,
    0x0104, 0x012E, 0x0100, 0x0106, 0x00C4, 0x00C5, 0x0118, 0x0112,
    0x010C, 0x00C9, 0x0179, 0x0116, 0x0122, 0x0136, 0x012A, 0x013B,
    0x0160, 0x0143, 0x0145, 0x00D3, 0x014C, 0x00D5, 0x00D6, 0x00D7,
    0x0172, 0x0141, 0x015A, 0x016A, 0x00DC, 0x017B, 0x017D, 0x00DF,
    0x0105, 0x012F, 0x0101, 0x0107, 0x00E4, 0x00E5, 0x0119, 0x0113,
    0x010D, 0x00E9, 0x017A, 0x0117, 0x0123, 0x0137, 0x012B, 0x013C,
    0x0161, 0x0144, 0x0146, 0x00F3, 0x014D, 0x00F5, 0x00F6, 0x00F7,
    0x0173, 0x0142, 0x015B, 0x016B, 0x00FC, 0x017C, 0x017E, 0x2019
};
#define ISO_8859_13_length sizeof(ISO_8859_13_Map) / sizeof(wchar_t);

wchar_t ISO_8859_15_Map [] = {
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097,
    0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F,
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x20AC, 0x00A5, 0x0160, 0x00A7,
    0x0161, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x017D, 0x00B5, 0x00B6, 0x00B7,
    0x017E, 0x00B9, 0x00BA, 0x00BB, 0x0152, 0x0153, 0x0178, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF
};
#define ISO_8859_15_length sizeof(ISO_8859_15_Map) / sizeof(wchar_t);

/* Windows Latin 2 (Central Europe) Code Page */
wchar_t WIN1250CP [] = {
    0x20AC, 0xFFFE, 0x201A, 0xFFFE, 0x201E, 0x2026, 0x2020, 0x2021,
    0xFFFE, 0x2030, 0x0160, 0x2039, 0x015A, 0x0164, 0x017D, 0x0179,
    0xFFFE, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
    0xFFFE, 0x2122, 0x0161, 0x203A, 0x015B, 0x0165, 0x017E, 0x017A,
    0x00A0, 0x02C7, 0x02D8, 0x0141, 0x00A4, 0x0104, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x015E, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x017B,
    0x00B0, 0x00B1, 0x02DB, 0x0142, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x0105, 0x015F, 0x00BB, 0x013D, 0x02DD, 0x013E, 0x017C,
    0x0154, 0x00C1, 0x00C2, 0x0102, 0x00C4, 0x0139, 0x0106, 0x00C7,
    0x010C, 0x00C9, 0x0118, 0x00CB, 0x011A, 0x00CD, 0x00CE, 0x010E,
    0x0110, 0x0143, 0x0147, 0x00D3, 0x00D4, 0x0150, 0x00D6, 0x00D7,
    0x0158, 0x016E, 0x00DA, 0x0170, 0x00DC, 0x00DD, 0x0162, 0x00DF,
    0x0155, 0x00E1, 0x00E2, 0x0103, 0x00E4, 0x013A, 0x0107, 0x00E7,
    0x010D, 0x00E9, 0x0119, 0x00EB, 0x011B, 0x00ED, 0x00EE, 0x010F,
    0x0111, 0x0144, 0x0148, 0x00F3, 0x00F4, 0x0151, 0x00F6, 0x00F7,
    0x0159, 0x016F, 0x00FA, 0x0171, 0x00FC, 0x00FD, 0x0163, 0x02D9
};
#define WIN1250CP_length sizeof(WIN1250CP) / sizeof(wchar_t);

/* Windows Cyrillic (Slavic) Code Page */
wchar_t WIN1251CP [] = {
    0x0402, 0x0403, 0x201A, 0x0453, 0x201E, 0x2026, 0x2020, 0x2021,
    0x20AC, 0x2030, 0x0409, 0x2039, 0x040A, 0x040C, 0x040B, 0x040F,
    0x0452, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
    0x0098, 0x2122, 0x0459, 0x203A, 0x045A, 0x045C, 0x045B, 0x045F,
    0x00A0, 0x040E, 0x045E, 0x0408, 0x00A4, 0x0490, 0x00A6, 0x00A7,
    0x0401, 0x00A9, 0x0404, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x0407,
    0x00B0, 0x00B1, 0x0406, 0x0456, 0x0491, 0x00B5, 0x00B6, 0x00B7,
    0x0451, 0x2116, 0x0454, 0x00BB, 0x0458, 0x0405, 0x0455, 0x0457,
    0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
    0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,
    0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
    0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
    0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
    0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F	
};
#define WIN1251CP_length sizeof(WIN1251CP) / sizeof(wchar_t);

/* Windows Latin 1 Code Page */
wchar_t WIN1252CP [] = {
    0x20AC, 0x0081, 0x201A, 0x0192, 0x201E, 0x2026, 0x2020, 0x2021,
    0x02C6, 0x2030, 0x0160, 0x2039, 0x0152, 0x008D, 0x017D, 0x008F,
    0x0090, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
    0x02DC, 0x2122, 0x0161, 0x203A, 0x0153, 0x009D, 0x017E, 0x0178, 
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF
};
#define WIN1252CP_length sizeof(WIN1252CP) / sizeof(wchar_t);

/* Windows Greek Code Page */
wchar_t WIN1253CP [] = {
    0x20AC, 0x0081, 0x201A, 0x0192, 0x201E, 0x2026, 0x2020, 0x2021,
    0x0088, 0x2030, 0x008A, 0x2039, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
    0x0098, 0x2122, 0x009A, 0x203A, 0x009C, 0x009D, 0x009E, 0x009F,
    0x00A0, 0x0385, 0x0386, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x2015,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x0384, 0x00B5, 0x00B6, 0x00B7,
    0x0388, 0x0389, 0x038A, 0x00BB, 0x038C, 0x00BD, 0x038E, 0x038F,
    0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 
    0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F,
    0x03A0, 0x03A1, 0x00D2, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7,
    0x03A8, 0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
    0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7,
    0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF,
    0x03C0, 0x03C1, 0x03C2, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 
    0x03C8, 0x03C9, 0x03CA, 0x03CB, 0x03CC, 0x03CD, 0x03CE, 0x00FF
};
#define WIN1253CP_length sizeof(WIN1253CP) / sizeof(wchar_t);

/* Windows Latin 5 (Turkish) Code Page */
wchar_t WIN1254CP [] = {
    0x20AC, 0x0081, 0x201A, 0x0192, 0x201E, 0x2026, 0x2020, 0x2021, 
    0x02C6, 0x2030, 0x0160, 0x2039, 0x0152, 0x008D, 0x008E, 0x008F, 
    0x0090, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014, 
    0x02DC, 0x2122, 0x0161, 0x203A, 0x0153, 0x009D, 0x009E, 0x0178, 
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x011E, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x0130, 0x015E, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0x011F, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x0131, 0x015F, 0x00FF
};
#define WIN1254CP_length sizeof(WIN1254CP) / sizeof(wchar_t);

/* Windows Hebrew Code Page */
wchar_t WIN1255CP [] = {
    0x20AC, 0x0081, 0x201A, 0x0192, 0x201E, 0x2026, 0x2020, 0x2021, 
    0x02C6, 0x2030, 0x008A, 0x2039, 0x008C, 0x008D, 0x008E, 0x008F,
    0x0090, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
    0x02DC, 0x2122, 0x009A, 0x203A, 0x009C, 0x009D, 0x009E, 0x009F, 
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x20AA, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00D7, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7, 
    0x00B8, 0x00B9, 0x00F7, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x05B0, 0x05B1, 0x05B2, 0x05B3, 0x05B4, 0x05B5, 0x05B6, 0x05B7,
    0x05B8, 0x05B9, 0x05BA, 0x05BB, 0x05BC, 0x05BD, 0x05BE, 0x05BF,
    0x05C0, 0x05C1, 0x05C2, 0x05C3, 0x05F0, 0x05F1, 0x05F2, 0x05F3,
    0x05F4, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
    0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4, 0x05D5, 0x05D6, 0x05D7,
    0x05D8, 0x05D9, 0x05DA, 0x05DB, 0x05DC, 0x05DD, 0x05DE, 0x05DF,
    0x05E0, 0x05E1, 0x05E2, 0x05E3, 0x05E4, 0x05E5, 0x05E6, 0x05E7,
    0x05E8, 0x05E9, 0x05EA, 0x00FB, 0x00FC, 0x200E, 0x200F, 0x00FF
};
#define WIN1255CP_length sizeof(WIN1255CP) / sizeof(wchar_t);

/* Windows Arabic Code Page */
wchar_t WIN1256CP [] = {
    0x20AC, 0x067E, 0x201A, 0x0192, 0x201E, 0x2026, 0x2020, 0x2021,
    0x02C6, 0x2030, 0xFFFE, 0x2039, 0x0152, 0x0686, 0x0698, 0xFFFE,
    0x06AF, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
    0xFFFE, 0x2122, 0xFFFE, 0x203A, 0x0153, 0x200C, 0x200D, 0xFFFE,
    0x00A0, 0x060C, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0xFFFE, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x061B, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x061F,
    0xFFFE, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627,
    0x0628, 0x0629, 0x062A, 0x062B, 0x062C, 0x062D, 0x062E, 0x062F,
    0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x00D7,
    0x0637, 0x0638, 0x0639, 0x063A, 0x0640, 0x0641, 0x0642, 0x0643,
    0x00E0, 0x0644, 0x00E2, 0x0645, 0x0646, 0x0647, 0x0648, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x0649, 0x064A, 0x00EE, 0x00EF,
    0x064B, 0x064C, 0x064D, 0x064E, 0x00F4, 0x064F, 0x0650, 0x00F7,
    0x0651, 0x00F9, 0x0652, 0x00FB, 0x00FC, 0x200E, 0x200F, 0xFFFE
};
#define WIN1256CP_length sizeof(WIN1256CP) / sizeof(wchar_t);

/* Windows Baltic RIM Code Page */
wchar_t WIN1257CP [] = {
    0x20AC, 0xFFFE, 0x201A, 0xFFFE, 0x201E, 0x2026, 0x2020, 0x2021,
    0xFFFE, 0x2030, 0xFFFE, 0x2039, 0xFFFE, 0x00A8, 0x02C7, 0x00B8,
    0xFFFE, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
    0xFFFE, 0x2122, 0xFFFE, 0x203A, 0xFFFE, 0x00AF, 0x02DB, 0xFFFE, 
    0x00A0, 0xFFFE, 0x00A2, 0x00A3, 0x00A4, 0xFFFE, 0x00A6, 0x00A7,
    0x00D8, 0x00A9, 0x0156, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00C6,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00F8, 0x00B9, 0x0157, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00E6,
    0x0104, 0x012E, 0x0100, 0x0106, 0x00C4, 0x00C5, 0x0118, 0x0112,
    0x010C, 0x00C9, 0x0179, 0x0116, 0x0122, 0x0136, 0x012A, 0x013B,
    0x0160, 0x0143, 0x0145, 0x00D3, 0x014C, 0x00D5, 0x00D6, 0x00D7, 
    0x0172, 0x0141, 0x015A, 0x016A, 0x00DC, 0x017B, 0x017D, 0x00DF,
    0x0105, 0x012F, 0x0101, 0x0107, 0x00E4, 0x00E5, 0x0119, 0x0113,
    0x010D, 0x00E9, 0x017A, 0x0117, 0x0123, 0x0137, 0x012B, 0x013C,
    0x0161, 0x0144, 0x0146, 0x00F3, 0x014D, 0x00F5, 0x00F6, 0x00F7,
    0x0173, 0x0142, 0x015B, 0x016B, 0x00FC, 0x017C, 0x017E, 0x02D9
};
#define WIN1257CP_length sizeof(WIN1257CP) / sizeof(wchar_t);

/* Russian Encoding */
wchar_t KOI8 [] = {
     0x2500, 0x2502, 0x250C, 0x2510, 0x2514, 0x2518, 0x251C, 0x2524,
     0x252C, 0x2534, 0x253C, 0x2580, 0x2584, 0x2588, 0x258C, 0x2590,
     0x2591, 0x2592, 0x2593, 0x2320, 0x25A0, 0x2219, 0x221A, 0x2248,
     0x2264, 0x2265, 0x00A0, 0x2321, 0x00B0, 0x00B2, 0x00B7, 0x00F7,
     0x2550, 0x2551, 0x2552, 0x0451, 0x2553, 0x2554, 0x2555, 0x2556,
     0x2557, 0x2558, 0x2559, 0x255A, 0x255B, 0x255C, 0x255d, 0x255E,
     0x255F, 0x2560, 0x2561, 0x0401, 0x2562, 0x2563, 0x2564, 0x2565,
     0x2566, 0x2567, 0x2568, 0x2569, 0x256A, 0x256B, 0x256C, 0x00A9,
     0x044E, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433,
     0x0445, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043d, 0x043E,
     0x043F, 0x044F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432,
     0x044C, 0x044B, 0x0437, 0x0448, 0x044d, 0x0449, 0x0447, 0x044A,
     0x042E, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413,
     0x0425, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041d, 0x041E,
     0x041F, 0x042F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412,
     0x042C, 0x042B, 0x0417, 0x0428, 0x042d, 0x0429, 0x0427, 0x042A
   };
#define KOI8_length sizeof(KOI8) / sizeof(wchar_t);

/* Macintosh Mac OS Roman/US Code Page */
wchar_t MACROMANCP [] = {
    0x00C4, 0x00C5, 0x00C7, 0x00C9, 0x00D1, 0x00D6, 0x00DC, 0x00E1,
    0x00E0, 0x00E2, 0x00E4, 0x00E3, 0x00E5, 0x00E7, 0x00E9, 0x00E8,
    0x00EA, 0x00EB, 0x00ED, 0x00EC, 0x00EE, 0x00EF, 0x00F1, 0x00F3,
    0x00F2, 0x00F4, 0x00F6, 0x00F5, 0x00FA, 0x00F9, 0x00FB, 0x00FC,
    0x2020, 0x00B0, 0x00A2, 0x00A3, 0x00A7, 0x00B7, 0x00B6, 0x00DF,
    0x00AE, 0x00A9, 0x2122, 0x00B4, 0x00A8, 0x2260, 0x00C6, 0x00D8,
    0x221E, 0x00B1, 0x2264, 0x2265, 0x00A5, 0x00B5, 0x2202, 0x2211,
    0x220F, 0x03C0, 0x222B, 0x00BA, 0x00AA, 0x03A9, 0x00E6, 0x00F8,
    0x00BF, 0x00A1, 0x00AC, 0x221A, 0x0192, 0x2248, 0x2206, 0x00AB,
    0x00BB, 0x2026, 0x00CA, 0x00C0, 0x00C3, 0x00D5, 0x0152, 0x0153,
    0x2013, 0x2014, 0x201C, 0x201D, 0x201B, 0x2019, 0x00F7, 0x25CA,
    0x00FF, 0x0178, 0x2215, 0x20AC, 0x2039, 0x203A, 0x00DE, 0x00DF, /* check the last two */
    0x2021, 0x2027, 0x201A, 0x201E, 0x2031, 0x00C2, 0x00CA, 0x00C1,
    0x00CB, 0x00C8, 0x00CD, 0x00CE, 0x00CF, 0x00CC, 0x00D3, 0x00D4,
    0x00F0, 0x00D2, 0x00DA, 0x00DB, 0x00D9, 0x0131, 0x02C6, 0x02DC, /* check the first */
    0x02C9, 0x02D8, 0x02D9, 0x02DA, 0x00B8, 0x02BA, 0x02BD, 0x02C7
};
#define MACROMANCP_length sizeof(MACROMANCP) / sizeof(wchar_t);

#include "memory_f.h"


/*----------------------------------------------------------------------
  TtaGetCharFromWC returns the ISO or Windows character code
  of the Unicode value wc.
  ----------------------------------------------------------------------*/
unsigned char TtaGetCharFromWC (wchar_t wc, CHARSET encoding)
{
  unsigned int  c, max, base;
  wchar_t      *table;

  if (wc < 128)
    /* ASCII character */
    return (unsigned char) wc;
  else
    {
      base = 128;
      if (encoding == ISO_SYMBOL)
	{
	  base = 0;
	  table = ISO_SYMBOL_Map;
	  max = ISO_SYMBOL_length;
	}
      else
	{
	/* look for the right table */
	switch (encoding)
	  {
	  case ISO_8859_1:
	    if (wc <= 255)
	      return (unsigned char) wc;
	    else
	      return EOS;
	    break;
	  case ISO_8859_2:
	    table = ISO_8859_2_Map;
	    max = ISO_8859_2_length;
	    break;
	  case ISO_8859_3:
	    table = ISO_8859_3_Map;
	    max = ISO_8859_3_length;
	    break;
	  case ISO_8859_4:
	    table = ISO_8859_4_Map;
	    max = ISO_8859_4_length;
	    break;
	  case ISO_8859_5:
	    table = ISO_8859_5_Map;
	    max = ISO_8859_5_length;
	    break;
	  case ISO_8859_6:
	    table = ISO_8859_6_Map;
	    max = ISO_8859_6_length;
	    break;
	  case ISO_8859_7:
	    table = ISO_8859_7_Map;
	    max = ISO_8859_7_length;
	    break;
	  case ISO_8859_8:
	    table = ISO_8859_8_Map;
	    max = ISO_8859_8_length;
	    break;
	  case ISO_8859_9:
	    table = ISO_8859_9_Map;
	    max = ISO_8859_9_length;
	    break;
	  case ISO_8859_13:
	    table = ISO_8859_13_Map;
	    max = ISO_8859_13_length;
	    break;
	  case ISO_8859_15:
	    table = ISO_8859_15_Map;
	    max = ISO_8859_15_length;
	    break;
	  case WINDOWS_1250:
	    table = WIN1250CP;
	    max = WIN1250CP_length;
	    break;
	  case WINDOWS_1251:
	    table = WIN1251CP;
	    max = WIN1251CP_length;
	    break;
	  case WINDOWS_1252:
	    table = WIN1252CP;
	    max = WIN1252CP_length;
	    break;
	  case WINDOWS_1253:
	    table = WIN1253CP;
	    max = WIN1253CP_length;
	    break;
	  case WINDOWS_1254:
	    table = WIN1254CP;
	    max = WIN1254CP_length;
	    break;
	  case WINDOWS_1255:
	    table = WIN1255CP;
	    max = WIN1255CP_length;
	    break;
	  case WINDOWS_1256:
	    table = WIN1256CP;
	    max = WIN1256CP_length;
	    break;
	  case WINDOWS_1257:
	    table = WIN1257CP;
	    max = WIN1257CP_length;
	    break;
	  case KOI8_R:
	    table = KOI8;
	    max = KOI8_length;
	    break;
	  case MAC_OS_ROMAN:
	    table = MACROMANCP;
	    max = MACROMANCP_length;
	    break;
	  default:
	    return EOS;
	    break;
	  }
	}
      c = 0;
      while (table[c] != wc && c < max)
	c++;
      if (c < max)
	return (unsigned char) (c + base);
      else
	/* not found */
	if (table == ISO_SYMBOL_Map && wc > 127)
	  return EOS;
        else
	  return EOS;
    }
}


/*-------------------------------------------------------------
  TtaConvertJisToWC convert a jis 2 byte character to a unicode
  wide character.
  -------------------------------------------------------------*/
wchar_t TtaConvertJisToWC (unsigned char b1, unsigned char b2, CHARSET charset)
{
  wchar_t wc;
  
  wc = EOS;
  switch (charset)
    {
    case JIS_X_0201_ROMAN:
      if (b1 < sizeof (JIS_X_0201_ROMAN_Map) / sizeof (wchar_t))
        wc = JIS_X_0201_ROMAN_Map[b1];
      break;
    case JIS_X_0201_KANA:
      if (b1 < sizeof (JIS_X_0201_KANA_Map) / sizeof (wchar_t))
        wc = JIS_X_0201_KANA_Map[b1];
      break;
    case JIS_X_0208:
      if (32 < b1 && b1 < 127 && 32 < b2 && b2 < 127)
        wc = JIS_X_0208_Map[b1 - 33][b2 - 33];
      break;
    case JIS_X_0212:
      if (32 < b1 && b1 < 127 && 32 < b2 && b2 < 127)
        wc = JIS_X_0212_Map[b1 - 33][b2 - 33];
      break;
    case GB_2312:
      if (32 < b1 && b1 < 127 && 32 < b2 && b2 < 127)
        wc = GB_2312_Map[b1 - 33][b2 - 33];
      break;
    case KSC_5601:
      if (32 < b1 && b1 < 127 && 32 < b2 && b2 < 127)
        wc = KSC_5601_Map[b1 - 33][b2 - 33];
      break;
    case ISO_8859_1:
      wc = b1 | 0x80;
      break;
    case ISO_8859_7:
      if (b1 < ISO_SYMBOL_length)
        wc = ISO_SYMBOL_Map [b1];
      break;
    default:
      wc = b1;
      break;
    }
  return wc;
}

/*-------------------------------------------------------------
  TtaConvertSJisToWC shift-jis 2 bytes to a unicode wide character.
  -------------------------------------------------------------*/
wchar_t TtaConvertSjisToWC (unsigned char b1, unsigned char b2)
{
  unsigned char c1, c2;

  if (b1 >= 0xe0) b1 -= 0x40;
  c1 = (b1 - 0x80) * 2 - ((b2 >= 0x9f)? 0x8 * 2 : 0x9 *2 - 1) + 0x30;
  c2 = (b2 >= 0x9f) ? (b2 - 0x7e): b2 - ((b2>=0x7f)? 1: 0) - 0x1f;
  return TtaConvertJisToWC ((unsigned char)(c1 & 0x7f),
                            (unsigned char)(c2 & 0x7f), JIS_X_0208);
}

/*----------------------------------------------------------------------
  TtaGetWCFromCharJis returns the Unicode value of the corresponding
  JIS character code c.  It may return 0 for asking more characters.
  ----------------------------------------------------------------------*/
int TtaJisEscMatch(unsigned char *buf, unsigned char *match, int *more)
{
  while (*match)
    {
      if (*buf == EOS)
	{
	  *more = 1;
	  return 0;
	}
      else if (*buf != *match)
	return 0;
      buf++;
      match++;
    }
  return 1;
}

/*----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
wchar_t TtaGetWCFromJisChar (unsigned char c, CHARSET encoding)
{
  static CHARSET g0, g1, g2;
  static int shift;
  static unsigned char b[8];
  static unsigned int n;
  wchar_t wc;
  int more;

  if (c == EOS)
    {
      g0 = US_ASCII;
      g1 = g2 = ISO_8859_1;
      shift = 0;
      n = 0;
      return (wchar_t)0;
    }

  b[n++] = c;
  b[n] = EOS;

  wc = (wchar_t)EOS;
  if (b[0] & 0x80)
    {
      if (n >= 2)
	{
	  if (encoding == EUC_JP)
	    wc = TtaConvertJisToWC((unsigned char)(b[0] & 0x7f),
                               (unsigned char)(b[1] & 0x7f), JIS_X_0208);
	  else if (encoding == SHIFT_JIS)
	    wc = TtaConvertSjisToWC(b[0], b[1]);
	  n = 0;
	}
    }
  else if (b[0] == '\033') /* Escape */
    {
      more = 0;
      if (TtaJisEscMatch(&b[1], (unsigned char *)"(B", &more))
	{
	  g0 = US_ASCII;
	  n = 0;
	}
      else if (TtaJisEscMatch(&b[1], (unsigned char *)"(J", &more))
	{
	  g0 = JIS_X_0201_ROMAN;
	  n = 0;
	}
      else if (TtaJisEscMatch(&b[1], (unsigned char *)"$@", &more))
	{
	  g0 = JIS_X_0208;
	  n = 0;
	}
      else if (TtaJisEscMatch(&b[1], (unsigned char *)"$B", &more))
	{
	  g0 = JIS_X_0208;
	  n = 0;
	}
      else if (TtaJisEscMatch(&b[1], (unsigned char *)"$A", &more))
	{
	  g0 = GB_2312;
	  n = 0;
	}
      else if (TtaJisEscMatch(&b[1], (unsigned char *)"$(C", &more))
	{
	  g0 = KSC_5601;
	  n = 0;
	}
      else if (TtaJisEscMatch(&b[1], (unsigned char *)"$(D", &more))
	{
	  g0 = JIS_X_0212;
	  n = 0;
	}
      else if (TtaJisEscMatch(&b[1], (unsigned char *)".A", &more))
	{
	  g2 = ISO_8859_1;
	  n = 0;
	}
      else if (TtaJisEscMatch(&b[1], (unsigned char *)".F", &more))
	{
	  g2 = ISO_8859_7;
	  n = 0;
	}
      else if (TtaJisEscMatch(&b[1], (unsigned char *)"N", &more))
	{
	  if (n >= 3)
	    {
	      wc = TtaConvertJisToWC(b[2], EOS, g2);
	      n = 0;
	    }
	}
      else if (!more)
	{
	  n = 0;
	}
    }
  else if (b[0] == '\017') /* Shift Out */
    {
      shift = 1;
      n = 0;
    }
  else if (b[0] == '\016') /* Shift In */
    {
      shift = 0;
      n = 0;
    }
  else if (shift == 1)
    {
      wc = TtaConvertJisToWC(b[0], EOS, g1);
      n = 0;
    }
  else if (g0 == JIS_X_0208 || g0 == JIS_X_0212 ||
	   g0 == GB_2312 || g0 == KSC_5601)
    {
      if (n >= 2)
	{
	  wc = TtaConvertJisToWC (b[0], b[1], g0);
	  n = 0;
	}
    }
  else
    {
      wc = TtaConvertJisToWC (b[0], EOS, g0);
      n = 0;
    }
  return wc;
}

/*----------------------------------------------------------------------
  TtaGetWCFromChar returns the Unicode value of the corresponding
  ISO or Windows character code c.
  ----------------------------------------------------------------------*/
wchar_t TtaGetWCFromChar (unsigned char c, CHARSET encoding)
{
  unsigned int   val, max;
  wchar_t       *table;

  if (encoding == ISO_2022_JP || encoding == EUC_JP || encoding == SHIFT_JIS)
    return TtaGetWCFromJisChar (c, encoding);
  else if (c < 128 && encoding != ISO_SYMBOL)
    return (wchar_t) c;
  else
    {
      if (encoding == ISO_SYMBOL)
	val = c;
      else
	val = c - 128;
      /* look for the right table */
      switch (encoding)
	{
	case ISO_SYMBOL:
	  table = ISO_SYMBOL_Map;
	  max = ISO_SYMBOL_length;
	  break;
	case ISO_8859_2:
	  table = ISO_8859_2_Map;
	  max = ISO_8859_2_length;
	  break;
	case ISO_8859_3:
	  table = ISO_8859_3_Map;
	  max = ISO_8859_3_length;
	  break;
	case ISO_8859_4:
	  table = ISO_8859_4_Map;
	  max = ISO_8859_4_length;
	  break;
	case ISO_8859_5:
	  table = ISO_8859_5_Map;
	  max = ISO_8859_5_length;
	  break;
	case ISO_8859_6:
	  table = ISO_8859_6_Map;
	  max = ISO_8859_6_length;
	  break;
	case ISO_8859_7:
	  table = ISO_8859_7_Map;
	  max = ISO_8859_7_length;
	  break;
	case ISO_8859_8:
	  table = ISO_8859_8_Map;
	  max = ISO_8859_8_length;
	  break;
	case ISO_8859_9:
	  table = ISO_8859_9_Map;
	  max = ISO_8859_9_length;
	  break;
	case ISO_8859_13:
	  table = ISO_8859_13_Map;
	  max = ISO_8859_13_length;
	  break;
	case ISO_8859_15:
	  table = ISO_8859_15_Map;
	  max = ISO_8859_15_length;
	  break;
	case WINDOWS_1250:
	  table = WIN1250CP;
	  max = WIN1250CP_length;
	  break;
	case WINDOWS_1251:
	  table = WIN1251CP;
	  max = WIN1251CP_length;
	  break;
	case WINDOWS_1252:
	  table = WIN1252CP;
	  max = WIN1252CP_length;
	  break;
	case WINDOWS_1253:
	  table = WIN1253CP;
	  max = WIN1253CP_length;
	  break;
	case WINDOWS_1254:
	  table = WIN1254CP;
	  max = WIN1254CP_length;
	  break;
	case WINDOWS_1255:
	  table = WIN1255CP;
	  max = WIN1255CP_length;
	  break;
	case WINDOWS_1256:
	  table = WIN1256CP;
	  max = WIN1256CP_length;
	  break;
	case WINDOWS_1257:
	  table = WIN1257CP;
	  max = WIN1257CP_length;
	  break;
	case KOI8_R:
	  table = KOI8;
	  max = KOI8_length;
	  break;
        case MAC_OS_ROMAN:
	  table = MACROMANCP;
	  max = MACROMANCP_length;
	  break;
	default:
	  return (wchar_t) c;
	  break;
	}
      if (val < max)
	return table[val];
      else
	return (wchar_t) c;
    }
}


/*----------------------------------------------------------------------
  TtaWCToMBstring converts a Unicode wide character into a UTF-8 multibyte string.
  Returns the number of bytes in the multibyte character or -1
  The pointer to the dest multibyte string is updated.
  ----------------------------------------------------------------------*/
int TtaWCToMBstring (wchar_t src, unsigned char **dest)
{
  unsigned char   leadByteMark;
  unsigned char  *mbcptr = *dest;
  int             nbBytes = 1;

  if (src < 0x80)
    {
      nbBytes  = 1;
      leadByteMark = 0x00;
    }
  else if (src < 0x800)
    {
      nbBytes      = 2;
      leadByteMark = 0xC0;
    }
  else if (src < 0x10000)
    {
      nbBytes      = 3;
      leadByteMark = 0xE0;
    }
  else if (src < 0x200000) /* fix this to have the exact top value of plane 16 */
    {
      nbBytes      = 4;
      leadByteMark = 0xF0;
    }
  else
    {
      *mbcptr = '?';
      return -1;
    }

  mbcptr += nbBytes;
  *dest = mbcptr;
  switch (nbBytes)
    {
    case 4:
      *--mbcptr = (src | 0x80) & 0xBF;
      src >>= 6;
    case 3:
      *--mbcptr = (src | 0x80) & 0xBF;
      src >>= 6;
    case 2:
      *--mbcptr = (src | 0x80) & 0xBF;
      src >>= 6;
    case 1:
      *--mbcptr = src | leadByteMark;
    }
  return nbBytes;
}


/*----------------------------------------------------------------------
  TtaMBstringToWCS converts a UTF-8 multibyte string into a Unicode wide character.
  Returns the number of bytes in the multibyte character or -1
  The pointer to the source multibyte string is updated.
  ----------------------------------------------------------------------*/
int TtaMBstringToWC (unsigned char **src, wchar_t *dest)
{
  unsigned char *ptrSrc = *src;
  wchar_t        res;
  int            nbBytesConverted = 0;
  int            nbBytesToConvert, i;

  if (*ptrSrc < 0x80)
    nbBytesToConvert = 1;
  else if (*ptrSrc < 0xC0)
    {
      /* not a valid UTF-8 character */
      *dest = '?';
      *src = ptrSrc + 1;
      return -1;
    }
  else if (*ptrSrc < 0xE0)
    nbBytesToConvert = 2;
  else if (*ptrSrc < 0xF0)
    nbBytesToConvert = 3;
  else if (*ptrSrc < 0xF8)
    nbBytesToConvert = 4;
  else
    {
      /* not a valid UTF-8 character */
      *dest = '?';
      *src = ptrSrc + 1;
      return -1;
    }
                 
  nbBytesConverted += nbBytesToConvert;
  res = 0;
  switch (nbBytesToConvert)
    {
    case 4:
      res += *ptrSrc++;
      res <<= 6;
    case 3:
      res += *ptrSrc++;
      res <<= 6;
    case 2:
      res += *ptrSrc++;
      res <<= 6;
    case 1:
      res += *ptrSrc++;
    }

  /* Leading bits in each byte are not masked or checked, but
     accounted for by subtracting the appropriate offset value.
     This assumes that the input is correct :-(. */
  i = offset[nbBytesToConvert - 1];
  res -= (wchar_t) i;
  if (res <= 0xFFFF)
    *dest = res;
  else 
    *dest = '?';
  *src = ptrSrc;
  if (nbBytesConverted > 0)
    return nbBytesConverted;
  else
    return -1;
}


/*----------------------------------------------------------------------
  TtaGetNextWCFromString: Looks for the next Wide character 
  value in a multibyte character string.
  Returns the number of bytes in the multibyte character or -1
  ----------------------------------------------------------------------*/
int TtaGetNextWCFromString (wchar_t *car, unsigned char **txt, CHARSET encoding)
{
  int            nbBytesToRead, i;
  unsigned char *start = *txt;
  wchar_t        res;

  if (encoding ==  UTF_8)
    {
      if (*start < 0x80)
	nbBytesToRead = 1;
      else if (*start < 0xC0)
	{
	  /* not a valid UTF-8 character */
	  *car = 63;
	  start++;
	  return -1;
	}
      else if (*start < 0xE0)
	nbBytesToRead = 2;
      else if (*start < 0xF0)
	nbBytesToRead = 3;
      else if (*start < 0xF8)
	nbBytesToRead = 4;
      else
	{
	  /* not a valid UTF-8 character */
	  *car = 63;
	  start++;
	  return -1;
	}
      
      res = 0;
      /* See how many bytes to read to build a wide character */
      switch (nbBytesToRead)
	{
	  /** WARNING: There is not break statement between cases */
	case 4:
	  res += *start++;
	  res <<= 6;
	case 3:
	  res += *start++;
	  res <<= 6;
	case 2:
	  res += *start++;
	  res <<= 6;
	case 1:
	  res += *start++;
	}
      i = offset[nbBytesToRead - 1];
      res -= (wchar_t) i;
      *car = res;
    }
  else
    {
      nbBytesToRead = 1;
      *car = TtaGetWCFromChar (*start, encoding);
      start++;
    }
  return nbBytesToRead;
}

/*----------------------------------------------------------------------
  TtaGetNumberOfBytesToRead: 
  Returns the number of bytes to read
  ----------------------------------------------------------------------*/
int  TtaGetNumberOfBytesToRead (unsigned char **txt, CHARSET encoding)
{
  int            nbBytesToRead = 1;
  unsigned char *start = *txt;

  if (encoding ==  UTF_8)
    {
      if (*start < 0x80)
	nbBytesToRead = 1;
      else if (*start < 0xC0)
	/* add some error processing here */ ;
      else if (*start < 0xE0)
	nbBytesToRead = 2;
      else if (*start < 0xF0)
	nbBytesToRead = 3;
      else if (*start < 0xF8)
	nbBytesToRead = 4;
      /*else
        add some error processing here  ; */ 
    }

  return nbBytesToRead;
}

/*-------------------------------------------------------------
  TtaConvertWCToByte converts the src (16-bit) into an ISO string
  (8-bit).
  The returned string should be freed by the caller.
  -------------------------------------------------------------*/
unsigned char *TtaConvertWCToByte (wchar_t *src, CHARSET encoding)
{
  unsigned char   *dest, *ptr, utf8str[8];
  int              i, l, len, nl;

  dest = NULL;
  if (src)
    {
      if (encoding == UTF_8)
	{
	  len = 0;
	  while (src[len] != 0)
	    len++;
	  len *= 4;
	  dest = (unsigned char *) TtaGetMemory (len + 1);
	  i = 0;
	  l = 0;
	  while (l < len && src[i] != 0)
	    {
	      ptr = utf8str;
	      nl = TtaWCToMBstring (src[i], &ptr);
	      if (nl + l < len)
		{
		  strncpy ((char *) &dest[l], (char *) utf8str, nl);
		  l += nl;
		}
	      else
		len = l;
	      i++;
	    }
	  dest[l] = EOS;
	}
      else
	{
	  i = 0;
	  while (src[i] != EOS)
	    i++;
	  dest = (unsigned char *) TtaGetMemory (i + 1);
	  i = 0;
	  while (src[i] != EOS)
	    {
	      dest[i] = TtaGetCharFromWC (src[i], encoding);
	      i++;
	    }
	  dest[i] = EOS;
	}
    }
  return (unsigned char *)dest;
}

/*-------------------------------------------------------------
  TtaConvertByteToWC converts the src (8-bit) into a wide character
  string (16-bit).
  The returned string should be freed by the caller.
  -------------------------------------------------------------*/
wchar_t *TtaConvertByteToWC (unsigned char *src, CHARSET encoding)
{
  wchar_t          *dest;
  int               i, len;
  unsigned char     c;
  wchar_t           wc;

  dest = NULL;
  if (src)
    {
      if (encoding == UTF_8)
	dest = TtaConvertMbsToCHAR (src);
      else
	{
	  len = strlen ((const char *)src);
	  dest = (wchar_t *)TtaGetMemory ((len + 1) * sizeof (wchar_t));
	  i = 0;
	  while (i < len && (c = *src++) != EOS)
	    {
	      wc = TtaGetWCFromChar (c, encoding);
	      if (wc)
		dest[i++] = wc;
	    }
	  dest[i] = EOS;
	}
    }
  return dest;
}

/*-------------------------------------------------------------
  TtaConvertByteToMbs converts the src (8-bit) into a UTF-8
  string (8-bit).
  The returned string should be freed by the caller.
  -------------------------------------------------------------*/
unsigned char *TtaConvertByteToMbs (unsigned char *src, CHARSET encoding)
{
  wchar_t         *tmp;
  unsigned char   *dest;

  dest = NULL;
  if (src)
    {
      if (encoding == UTF_8)
	dest = (unsigned char *)TtaStrdup ((char *)src);
      else
	{
	  /* generate the WC string */
	  tmp = TtaConvertByteToWC (src, encoding);
	  dest = TtaConvertWCToByte (tmp, UTF_8);
	  TtaFreeMemory (tmp);
	}
    }
  return dest;
}

/*-------------------------------------------------------------
  TtaConvertMbsToByte converts a UTF-8 string (8-bit) into an
  Byte string (8-bit).
  The returned string should be freed by the caller.
  -------------------------------------------------------------*/
unsigned char *TtaConvertMbsToByte (unsigned char *src, CHARSET encoding)
{
  wchar_t         *tmp;
  unsigned char   *dest, *ptr;
  int              i, l, len;

  dest = NULL;
  if (src)
    {
      if (encoding == UTF_8)
	dest = (unsigned char *)TtaStrdup ((char *)src);
      else
	{
      /* generate the WC string */
      len = strlen ((char *)src);
      tmp = (wchar_t *)TtaGetMemory ((len + 1) * sizeof (wchar_t));
      i = 0;
      l = 0;
      while (src[l] != 0 && i < len)
	{
	  ptr = &src[l];
	  l += TtaMBstringToWC (&ptr, &tmp[i]);
	  i++;
	}
      tmp[i] = 0;
      /* now generate the ISO string */
      dest = TtaConvertWCToByte (tmp, encoding);
      TtaFreeMemory (tmp);
	  }
    }
  return dest;
}

/*-------------------------------------------------------------
  TtaConvertMbsToCHAR converts a UTF-8 string (8-bit) into CHAR_T
  string (8-bit or 16-bit).
  The returned string should be freed by the caller.
  -------------------------------------------------------------*/
CHAR_T *TtaConvertMbsToCHAR (unsigned char *src)
{
  CHAR_T          *dest = NULL;
  unsigned char   *ptr;
  int              i, l, len;

  if (src)
    {
      /* generate the WC string */
      len = strlen ((char *)src);
      dest = (CHAR_T *)TtaGetMemory ((len + 1) * sizeof (CHAR_T));
      i = 0;
      l = 0;
      while (src[l] != 0 && i < len)
	{
	  ptr = &src[l];
	  l += TtaMBstringToWC (&ptr, &dest[i]);
	  i++;
	}
      dest[i] = 0;
    }
  return dest;
}

/*-------------------------------------------------------------
  TtaConvertCHARToByte converts the src CHAR_T* into an ISO
  string (8-bit).
  The returned string should be freed by the caller.
  -------------------------------------------------------------*/
unsigned char *TtaConvertCHARToByte (CHAR_T *src, CHARSET encoding)
{
  return TtaConvertWCToByte (src, encoding);
}


/*-------------------------------------------------------------
  TtaConvertByteToCHAR converts the src (8-bit) into a CHAR_T*
  string.
  The returned string should be freed by the caller.
  -------------------------------------------------------------*/
CHAR_T *TtaConvertByteToCHAR (unsigned char *src, CHARSET encoding)
{
  return TtaConvertByteToWC (src, encoding);
}
