/*
    Copyright (C) 2006-2009 Fons Adriaensen <fons@kokkinizita.net>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ADCONF_H
#define __ADCONF_H

#include <stdio.h>
#include "global.h"


class Speaker
{
public:

    Speaker (void);
    void reset (void);

    float   _r;
    float   _a;
    float   _e;
    float   _x;
    float   _y;
    float   _z;
    char    _label [4];
    char    _jackp [64];
};


class Matrow
{
public:

    Matrow (void);
    void reset (void);

    float   _w;
    float   _x;
    float   _y;
    float   _z;
    float   _r;
    float   _s;
    float   _t;
    float   _u;
    float   _v;
    float   _p;
    float   _q;
};


class AD_conf
{
public:

    enum { N3D, SN3D, FUMA };
    enum { OFF, ON };
    enum { NONE, INPUT, OUTPUT };
    enum { ST_INPS = 1, ST_OUTS = 2, ST_OPTS = 4, ST_MATR = 8, ST_ALL = 15 };

    AD_conf (void);
    void reset (void);
    int  load (const char *file);
    int  save (const char *file);

    unsigned int   _fform;
    unsigned int   _state;
    char           _fname [128];
    char           _descr [128];
    struct
    {
	int   h_ord;
	int   v_ord;
	int   nband;
	int   nspkr;
	int   scale;
    }              _dec;
    struct
    {
        int   scale;
	int   nfeff;
        int   delay;
        int   level;
	float xfreq;
	float ratio;
    }              _opt;
    Speaker        _speakers [MAXOP];
    Matrow         _lfmatrix [MAXOP];
    Matrow         _hfmatrix [MAXOP];
    float          _lfgain [4];
    float          _hfgain [4];

    void default_label (void);
    void default_jackp (void);

private:

    enum { NOERR, ERROR, COMM, ARGS, EXTRA, SCOPE };

    void save_matrix (FILE *, const char *, Matrow *, float *);
    int  read_matrow (char **, Matrow *);
};    


#endif
