<?php
/*

 Copyright (c) Ampache.org
 All rights reserved.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License v2
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/**
 * xmlRpcClient
 * This is the other half of the xmlrpcserver class, it Holds the different calls that Ampache might
 * make that are xmlrpc'ie this does not include the API responses. 
 */

class xmlRpcClient {

	/**
	 * construtor
	 * not used
	 */
	private function __construct() { 

		// Rien a faire

	} // constructor

	/**
	 * ampache_handshake
	 * This handshakes with ampache servers, this is used by the internal xml-rpc mojo
	 */
	public static function ampache_handshake($target_url,$key) { 

		// Generate the client
		$client = self::create_client($target_url); 

                // 6 that's right, the secret level because if you do have debug on most likely you're 
                // going to just crash your browser... sorry folks
                if (Config::get('debug') AND Config::get('debug_level') == '6') { $client->setDebug(1); }  

		// Build our key
                $timestamp      = time();
                $handshake_key  = md5($timestamp . $key);

                $encoded_key    = new xmlrpcval($handshake_key,'string');
                $timestamp      = new xmlrpcval($timestamp,'int');
                $xmlrpc_message = new xmlrpcmsg('xmlrpcserver.handshake',array($encoded_key,$timestamp));

                // Send it off
                $response = $client->send($xmlrpc_message,10);
                if ($response->faultCode()) {
                        $error_msg = _('Error connecting to') . " " . $server . " " . _("Code") . ": " . $response->faultCode() . " " . _("Reason") . ": " . $response->faultString();
                        debug_event('XMLCLIENT',$error_msg,'1');
			Error::add('general',$error_msg); 
                        return;
                }

                $token = php_xmlrpc_decode($response->value());

		debug_event('XML-RPC',$token . ' returned from ' . $server,'3'); 

		return $token; 

	} // ampache_handshake

	/**
	 * ampache_create_stream_session
	 * This generates a new stream session, it takes a target_url and a token as generated by 
	 * a ampache_handshake action
	 */
	public static function ampache_create_stream_session($target_url,$token) { 

		$client = self::create_client($target_url); 

                // 6 that's right, the secret level because if you do have debug on most likely you're 
                // going to just crash your browser... sorry folks
                if (Config::get('debug') AND Config::get('debug_level') == '6') { $client->setDebug(1); }
	
		$encoded_key    = new xmlrpcval($token,'string');
		$xmlrpc_message = new xmlrpcmsg('xmlrpcserver.create_stream_session',array($encoded_key)); 

		$response = $client->send($xmlrpc_message,4);

                if ($response->faultCode() ) {
                        $error_msg = _("Error connecting to") . " " . $server . " " . _("Code") . ": " . $response->faultCode() . " " .
                        debug_event('XMLCLIENT',$error_msg,'1');
                        return false; 
                }

		$sid = php_xmlrpc_decode($response->value());

		debug_event('XML-RPC',$sid . ' stream session ID returned from ' . $server,'3'); 

		return $sid; 

	} // ampache_create_stream_session

	/**
	 * create_client
	 * This creates the xmlrpc client object from a URL 
	 */
	public static function create_client($target_url) { 

                // Figure out the host etc
                preg_match("/http:\/\/([^\/\:]+):?(\d*)\/*(.*)/", $target_url, $match);
                $server = $match['1'];
                $port   = $match['2'] ? intval($match['2']) : '80';
                $path   = $match['3'];

                $full_url = ltrim("/$path/server/xmlrpc.server.php",'/');
                $client = new xmlrpc_client($full_url,$server,$port);

		return $client; 

	} // create_client

} // xmlRpcClient
?>
