//
// This file is part of the aMule Project.
//
// Copyright (c) 2003-2008 aMule Team ( admin@amule.org / http://www.amule.org )
// Copyright (c) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// Any parts of this program derived from the xMule, lMule or eMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

#ifndef UPLOADQUEUE_H
#define UPLOADQUEUE_H

#include "MD4Hash.h"		// Needed for CMD4Hash


class CUpDownClient;

class CUploadQueue
{
public:
	CUploadQueue();
	~CUploadQueue();
	void	Process();
	void	AddClientToQueue(CUpDownClient* client);
	bool	RemoveFromUploadQueue(CUpDownClient* client,bool updatewindow = true);
	bool	RemoveFromWaitingQueue(CUpDownClient* client,bool updatewindow = true);
	bool	IsOnUploadQueue(const CUpDownClient* client) const;
	bool	IsDownloading(CUpDownClient* client) const;
	bool	CheckForTimeOver(CUpDownClient* client);
	
	const CClientPtrList& GetWaitingList() const { return m_waitinglist; }
	const CClientPtrList& GetUploadingList() const { return m_uploadinglist; }
// ADUNANZA BEGIN
	// mod Adu
	// Emanem
	inline uint32     GetAdunanzAUserCount() const {return m_AduClientsNum;}
	// mod Adu
	// lupz
	inline uint16  GetAduUploadCount()    const { return aduuploadinglist.size(); }
	inline uint16  GetUploadCount()       const { return m_uploadinglist.size(); }
	// fine mod Adu
// ADUNANZA END
	
	CUpDownClient* GetWaitingClientByIP(uint32 dwIP);
	CUpDownClient* GetWaitingClientByIP_UDP(uint32 dwIP, uint16 nUDPPort, bool bIgnorePortOnUniqueIP, bool* pbMultipleIPs = NULL);

	uint16	GetWaitingPosition(const CUpDownClient *client) const;
	void	SuspendUpload(const CMD4Hash &);
	void	ResumeUpload(const CMD4Hash &);

// ADUNANZA BEGIN
	// Stefano Picerno: metodi presi da emule
	void    UpdateMaxClientScore();
	inline uint32  GetMaxClientScore() const { return m_imaxscore; }
	// fine
	uint32 lastmax;
// ADUNANZA END

private:
	void	RemoveFromWaitingQueue(CClientPtrList::iterator pos);
	bool	AcceptNewClient();
// ADUNANZA BEGIN
	bool	AcceptNewClient(bool isAduClient/* = false*/);

	// Mr Hyde: il parametro typeClient non e' piu' usato.
	// Rimosso prototipo personalizzato per AdunanzA
	void	AddUpNextClient(CUpDownClient* directadd = 0);


	// Inizio mod Adu
	inline uint32 GetAduMaxClientScore() const {return m_AduImaxscore;}
	inline uint32 GetExtMaxClientScore() const {return m_ExtImaxscore;}
	// fine mod Adu
private:
	// Stefano Picerno: preso da emule
	uint32 m_imaxscore;
	// Fine
	// Mod Adu
	uint32	m_AduImaxscore;
	uint32	m_ExtImaxscore;
	uint32	m_AduClientsNum;
	// fine mod Adu
// ADUNANZA END

	CClientPtrList m_waitinglist;
	CClientPtrList m_uploadinglist;
// ADUNANZA BEGIN
	// Mod Adu
	// lupz
	CClientPtrList aduuploadinglist;
	// Fine Mod Adu	
// ADUNANZA END
	
	typedef std::list<CMD4Hash> suspendlist;
	suspendlist suspended_uploads_list;  //list for suspended uploads
	uint32	m_nLastStartUpload;
	bool	lastupslotHighID; // VQB lowID alternation
};

#endif // UPLOADQUEUE_H
// File_checked_for_headers
