# 2 What do "anarcho"-capitalists mean by "freedom"?

For "anarcho"-capitalists, the concept of freedom is limited to the idea of
_"freedom from."_ For them, freedom means simply freedom from the _"initiation
of force,"_ or the _"non-aggression against anyone's person and property."_
[Murray Rothbard, **For a New Liberty**, p. 23] The notion that real freedom
must combine both freedom _"to"_ **and** freedom _"from"_ is missing in their
ideology, as is the social context of the so-called freedom they defend.

Before starting, it is useful to quote Alan Haworth when he notes that _"[i]n
fact, it is surprising how **little** close attention the concept of freedom
receives from libertarian writers. Once again **Anarchy, State, and Utopia**
is a case in point. The word 'freedom' doesn't even appear in the index. The
word 'liberty' appears, but only to refer the reader to the 'Wilt Chamberlain'
passage. In a supposedly 'libertarian' work, this is more than surprising. It
is truly remarkable."_ [**Anti-Libertarianism**, p. 95]

Why this is the case can be seen from how the "anarcho"-capitalist defines
freedom.

In a right-libertarian or "anarcho"-capitalist society, freedom is considered
to be a product of property. As Murray Rothbard puts it, _"the libertarian
defines the concept of 'freedom' or 'liberty'. . .[as a] condition in which a
person's ownership rights in his body and his legitimate material property
rights are not invaded, are not aggressed against. . . . Freedom and
unrestricted property rights go hand in hand."_ [**Op. Cit.**, p.41]

This definition has some problems, however. In such a society, one cannot
(legitimately) do anything with or on another's property if the owner
prohibits it. This means that an individual's only **guaranteed** freedom is
determined by the amount of property that he or she owns. This has the
consequence that someone with no property has no guaranteed freedom at all
(beyond, of course, the freedom not to be murdered or otherwise harmed by the
deliberate acts of others). In other words, a distribution of property is a
distribution of freedom, as the right-libertarians themselves define it. It
strikes anarchists as strange that an ideology that claims to be committed to
promoting freedom entails the conclusion that some people should be more free
than others. However, this is the logical implication of their view, which
raises a serious doubt as to whether "anarcho"-capitalists are actually
interested in freedom.

Looking at Rothbard's definition of "liberty" quoted above, we can see that
freedom is actually no longer considered to be a fundamental, independent
concept. Instead, freedom is a derivative of something more fundamental,
namely the _"legitimate rights"_ of an individual, which are identified as
property rights. In other words, given that "anarcho"-capitalists and right
libertarians in general consider the right to property as "absolute," it
follows that freedom and property become one and the same. This suggests an
alternative name for the right Libertarian, namely **_"Propertarian."_** And,
needless to say, if we do not accept the right-libertarians' view of what
constitutes "legitimate" "rights," then their claim to be defenders of liberty
is weak.

Another important implication of this "liberty as property" concept is that it
produces a strangely alienated concept of freedom. Liberty, as we noted, is no
longer considered absolute, but a derivative of property -- which has the
important consequence that you can "sell" your liberty and still be considered
free by the ideology. This concept of liberty (namely "liberty as property")
is usually termed "self-ownership." But, to state the obvious, I do not "own"
myself, as if were an object somehow separable from my subjectivity -- I
**am** myself. However, the concept of "self-ownership" is handy for
justifying various forms of domination and oppression -- for by agreeing
(usually under the force of circumstances, we must note) to certain contracts,
an individual can "sell" (or rent out) themselves to others (for example, when
workers sell their labour power to capitalists on the "free market"). In
effect, "self-ownership" becomes the means of justifying treating people as
objects -- ironically, the very thing the concept was created to stop! As L.
Susan Brown notes, _"[a]t the moment an individual 'sells' labour power to
another, he/she loses self-determination and instead is treated as a
subjectless instrument for the fulfilment of another's will."_ [**The Politics
of Individualism**, p. 4]

Given that workers are paid to obey, you really have to wonder which planet
Murray Rothbard is on when he argues that a person's _"labour service is
alienable, but his **will** is not"_ and that he [sic!] _"cannot alienate his
**will**, more particularly his control over his own mind and body."_ [**The
Ethics of Liberty**, p. 40, p. 135] He contrasts private property and self-
ownership by arguing that _"[a]ll physical property owned by a person is
alienable . . . I can give away or sell to another person my shoes, my house,
my car, my money, etc. But there are certain vital things which, in natural
fact and in the nature of man, are **in**alienable . . . [his] will and
control over his own person are inalienable."_ [**Op. Cit.**, pp. 134-5]

But _"labour services"_ are unlike the private possessions Rothbard lists as
being alienable. As we argued in section B.1 (["Why do anarchists oppose
hierarchy"](secB1.html)) a person's _"labour services"_ and _"will"_ cannot be
divided -- if you sell your labour services, you also have to give control of
your body and mind to another person! If a worker does not obey the commands
of her employer, she is fired. That Rothbard denies this indicates a total
lack of common-sense. Perhaps Rothbard will argue that as the worker can quit
at any time she does not alienate their will (this seems to be his case
against slave contracts -- see [section 2.6](append132.html#secf26)). But this
ignores the fact that between the signing and breaking of the contract and
during work hours (and perhaps outside work hours, if the boss has mandatory
drug testing or will fire workers who attend union or anarchist meetings or
those who have an "unnatural" sexuality and so on) the worker **does**
alienate his will and body. In the words of Rudolf Rocker, _"under the
realities of the capitalist economic form . . . there can be no talk of a
'right over one's own person,' for that ends when one is compelled to submit
to the economic dictation of another if he does not want to starve."_
[**Anarcho-Syndicalism**, p. 17]

Ironically, the rights of property (which are said to flow from an
individual's self-ownership of themselves) becomes the means, under
capitalism, by which self-ownership of non-property owners is denied. The
foundational right (self-ownership) becomes denied by the derivative right
(ownership of things). Under capitalism, a lack of property can be just as
oppressive as a lack of legal rights because of the relationships of
domination and subjection this situation creates.

So Rothbard's argument (as well as being contradictory) misses the point (and
the reality of capitalism). Yes, **if** we define freedom as _"the absence of
coercion"_ then the idea that wage labour does not restrict liberty is
unavoidable, but such a definition is useless. This is because it hides
structures of power and relations of domination and subordination. As Carole
Pateman argues, _"the contract in which the worker allegedly sells his labour
power is a contract in which, since he cannot be separated from his
capacities, he sells command over the use of his body and himself. . . To sell
command over the use of oneself for a specified period . . . is to be an
unfree labourer."_ [**The Sexual Contract**, p. 151]

In other words, contracts about property in the person inevitably create
subordination. "Anarcho"-capitalism defines this source of unfreedom away, but
it still exists and has a major impact on people's liberty. Therefore freedom
is better described as "self-government" or "self-management" -- to be able to
govern ones own actions (if alone) or to participate in the determination of
join activity (if part of a group). Freedom, to put it another way, is not an
abstract legal concept, but the vital concrete possibility for every human
being to bring to full development all their powers, capacities, and talents
which nature has endowed them. A key aspect of this is to govern one own
actions when within associations (self-management). If we look at freedom this
way, we see that coercion is condemned but so is hierarchy (and so is
capitalism for during working hours, people are not free to make their own
plans and have a say in what affects them. They are order takers, **not** free
individuals).

It is because anarchists have recognised the authoritarian nature of
capitalist firms that they have opposed wage labour and capitalist property
rights along with the state. They have desired to replace institutions
structured by subordination with institutions constituted by free
relationships (based, in other words, on self-management) in **all** areas of
life, including economic organisations. Hence Proudhon's argument that the
_"workmen's associations . . . are full of hope both as a protest against the
wage system, and as an affirmation of **reciprocity**"_ and that their
importance lies _"in their denial of the rule of capitalists, money lenders
and governments."_ [**The General Idea of the Revolution**, pp. 98-99]

Unlike anarchists, the "anarcho"-capitalist account of freedom allows an
individual's freedom to be rented out to another while maintaining that the
person is still free. It may seem strange that an ideology proclaiming its
support for liberty sees nothing wrong with the alienation and denial of
liberty but, in actual fact, it is unsurprising. After all, contract theory is
a _"theoretical strategy that justifies subjection by presenting it as
freedom"_ and nothing more. Little wonder, then, that contract _"creates a
relation of subordination"_ and not of freedom [Carole Pateman, **Op. Cit.**,
p. 39, p. 59]

Any attempt to build an ethical framework starting from the abstract
individual (as Rothbard does with his _"legitimate rights"_ method) will
result in domination and oppression between people, **not** freedom. Indeed,
Rothbard provides an example of the dangers of idealist philosophy that
Bakunin warned about when he argued that while _"[m]aterialism denies free
will and ends in the establishment of liberty; idealism, in the name of human
dignity, proclaims free will, and on the ruins of every liberty founds
authority."_ [**God and the State**, p. 48] This is the case with
"anarcho"-capitalism can be seen from Rothbard's wholehearted support for wage
labour and the rules imposed by property owners on those who use, but do not
own, their property. Rothbard, basing himself on abstract individualism,
cannot help but justify authority over liberty.

Overall, we can see that the logic of the right-libertarian definition of
"freedom" ends up negating itself, because it results in the creation and
encouragement of **authority,** which is an **opposite** of freedom. For
example, as Ayn Rand points out, _"man has to sustain his life by his own
effort, the man who has no right to the product of his effort has no means to
sustain his life. The man who produces while others dispose of his product, is
a slave."_ [**The Ayn Rand Lexicon: Objectivism from A to Z**, pp. 388-9] But,
as was shown in [section C](secCcon.html), capitalism is based on, as Proudhon
put it, workers working _"for an entrepreneur who pays them and keeps their
products,"_ and so is a form of **theft.** Thus, by "libertarian" capitalism's
**own** logic, capitalism is based not on freedom, but on (wage) slavery; for
interest, profit and rent are derived from a worker's **unpaid** labour, i.e.
_"others dispose of his [sic] product."_

And if a society **is** run on the wage- and profit-based system suggested by
the "anarcho" and "libertarian" capitalists, freedom becomes a commodity. The
more money you have, the more freedom you get. Then, since money is only
available to those who earn it, Libertarianism is based on that classic saying
_"work makes one free!"_ (**_Arbeit macht frei!_**), which the Nazis placed on
the gates of their concentration camps. Of course, since it is capitalism,
this motto is somewhat different for those at the top. In this case it is
_"other people's work makes one free!"_ \-- a truism in any society based on
private property and the authority that stems from it.

Thus it is debatable that a libertarian or "anarcho" capitalist society would
have less unfreedom or coercion in it than "actually existing capitalism." In
contrast to anarchism, "anarcho"-capitalism, with its narrow definitions,
restricts freedom to only a few aspects of social life and ignores domination
and authority beyond those aspects. As Peter Marshall points out, the right-
libertarian's _"definition of freedom is entirely negative. It calls for the
absence of coercion but cannot guarantee the positive freedom of individual
autonomy and independence."_ [**Demanding the Impossible**, p. 564] By
confining freedom to such a narrow range of human action, "anarcho"-capitalism
is clearly **not** a form of anarchism. Real anarchists support freedom in
every aspect of an individual's life.

## 2.1 What are the implications of defining liberty in terms of (property)
rights?

The change from defending liberty to defending (property) rights has important
implications. For one thing, it allows right libertarians to imply that
private property is similar to a "fact of nature," and so to conclude that the
restrictions on freedom produced by it can be ignored. This can be seen in
Robert Nozick's argument that decisions are voluntary if the limitations on
one's actions are not caused by human action which infringe the rights of
others. Thus, in a "pure" capitalist society the restrictions on freedom
caused by wage slavery are not really restrictions because the worker
voluntarily consents to the contract. The circumstances that drive a worker to
make the contract are irrelevant because they are created by people exercising
their rights and not violating other peoples' ones (see the section on
_"Voluntary Exchange"_ in **Anarchy, State, and Utopia**, pp. 262-265).

This means that within a society _"[w]hether a person's actions are voluntary
depends on what limits his alternatives. If facts of nature do so, the actions
are voluntary. (I may voluntarily walk to someplace I would prefer to fly to
unaided)."_ [**Anarchy, State, and Utopia**, p. 262] Similarly, the results of
voluntary actions and the transference of property can be considered alongside
the "facts of nature" (they are, after all, the resultants of "natural
rights"). This means that the circumstances created by the existence and use
of property can be considered, in essence, as a "natural" fact and so the
actions we take in response to these circumstances are therefore "voluntary"
and we are "free" (Nozick presents the example [p. 263] of someone who marries
the only available person -- all the more attractive people having already
chosen others -- as a case of an action that is voluntary despite removal of
all but the least attractive alternative through the legitimate actions of
others. Needless to say, the example can be -- and is -- extended to workers
on the labour market -- although, of course, you do not starve to death if you
decide not to marry).

However, such an argument fails to notice that property is different from
gravity or biology. Of course not being able to fly does not restrict freedom.
Neither does not being able to jump 10 feet into the air. But unlike gravity
(for example), private property has to be protected by laws and the police. No
one stops you from flying, but laws and police forces must exist to ensure
that capitalist property (and the owners' authority over it) is respected. The
claim, therefore, that private property in general, and capitalism in
particular, can be considered as "facts of nature," like gravity, ignores an
important fact: namely that the people involved in an economy must accept the
rules of its operation -- rules that, for example, allow contracts to be
enforced; forbid using another's property without his or her consent ("theft,"
trespass, copyright infringement, etc.); prohibit "conspiracy," unlawful
assembly, rioting, and so on; and create monopolies through regulation,
licensing, charters, patents, etc. This means that capitalism has to include
the mechanisms for deterring property crimes as well as mechanisms for
compensation and punishment should such crimes be committed. In other words,
capitalism is in fact far more than "voluntary bilateral exchange," because it
**must** include the policing, arbitration, and legislating mechanisms
required to ensure its operation. Hence, like the state, the capitalist market
is a social institution, and the distributions of goods that result from its
operation are therefore the distributions sanctioned by a capitalist society.
As Benjamin Franklin pointed out, _"Private property . . . is a Creature of
Society, and is subject to the Calls of that Society."_

Thus, to claim with Sir Isaiah Berlin (the main, modern, source of the
concepts of _"negative"_ and _"positive"_ freedom -- although we must add that
Berlin was not a right-Libertarian), that _"[i]f my poverty were a kind of
disease, which prevented me from buying bread . . . as lameness prevents me
from running, this inability would not naturally be described as a lack of
freedom"_ totally misses the point [_"Two Concepts of Liberty"_, in **Four
Essays on Liberty**, p. 123]. If you are lame, police officers do not come
round to stop you running. They do not have to. However, they **are** required
to protect property against the dispossessed and those who reject capitalist
property rights.

This means that by using such concepts as "negative" liberty and ignoring the
social nature of private property, right-libertarians are trying to turn the
discussion away from liberty toward "biology" and other facts of nature. And
conveniently, by placing property rights alongside gravity and other natural
laws, they also succeed in reducing debate even about rights.

Of course, coercion and restriction of liberty **can** be resisted, unlike
"natural forces" like gravity. So if, as Berlin argues, _"negative"_ freedom
means that you _"lack political freedom only if you are prevented from
attaining a goal by human beings,"_ then capitalism is indeed based on such a
lack, since property rights need to be enforced by human beings (_"I am
prevented by others from doing what I could otherwise do"_). After all, as
Proudhon long ago noted, the market is manmade, hence any constraint it
imposes is the coercion of man by man and so economic laws are not as
inevitable as natural ones [see Alan Ritter's **The Political Thought of
Pierre-Joseph Proudhon**, p. 122]. Or, to put it slightly differently,
capitalism requires coercion in order to work, and hence, is **not** similar
to a "fact of nature," regardless of Nozick's claims (i.e. property rights
have to be defined and enforced by human beings, although the nature of the
labour market resulting from capitalist property definitions is such that
direct coercion is usually not needed). This implication is actually
recognised by right-libertarians, because they argue that the rights-framework
of society should be set up in one way rather than another. In other words,
they recognise that society is not independent of human interaction, and so
can be changed.

Perhaps, as seems the case, the "anarcho"-capitalist or right-Libertarian will
claim that it is only **deliberate** acts which violate your (libertarian
defined) rights by other humans beings that cause unfreedom (_"we define
freedom . . . as the **absence of invasion** by another man of an man's person
or property"_ [Rothbard, **The Ethics of Liberty**, p. 41]) and so if no-one
deliberately coerces you then you are free. In this way the workings of the
capitalist market can be placed alongside the "facts of nature" and ignored as
a source of unfreedom. However, a moments thought shows that this is not the
case. Both deliberate and non-deliberate acts can leave individuals lacking
freedom.

Let us assume (in an example paraphrased from Alan Haworth's excellent book
**Anti-Libertarianism**, p. 49) that someone kidnaps you and places you down a
deep (naturally formed) pit, miles from anyway, which is impossible to climb
up. No one would deny that you are unfree. Let us further assume that another
person walks by and accidentally falls into the pit with you.

According to right-libertarianism, while you are unfree (i.e. subject to
deliberate coercion) your fellow pit-dweller is perfectly free for they have
subject to the "facts of nature" and not human action (deliberate or
otherwise). Or, perhaps, they "voluntarily choose" to stay in the pit, after
all, it is "only" the "facts of nature" limiting their actions. But,
obviously, both of you are in **exactly the same position,** have **exactly
the same choices** and so are **equally** unfree! Thus a definition of
"liberty" that maintains that only deliberate acts of others -- for example,
coercion -- reduces freedom misses the point totally.

Why is this example important? Let us consider Murray Rothbard's analysis of
the situation after the abolition of serfdom in Russia and slavery in America.
He writes:

> _"The **bodies** of the oppressed were freed, but the property which they
had worked and eminently deserved to own, remained in the hands of their
former oppressors. With economic power thus remaining in their hands, the
former lords soon found themselves virtual masters once more of what were now
free tenants or farm labourers. The serfs and slaves had tasted freedom, but
had been cruelly derived of its fruits."_ [**The Ethics of Liberty**, p. 74]

However, contrast this with Rothbard's claims that if market forces
("voluntary exchanges") result in the creation of free tenants or labourers
then these labourers and tenants are free (see, for example, **The Ethics of
Liberty**, pp. 221-2 on why "economic power" within capitalism does not
exist). But the labourers dispossessed by market forces are in **exactly** the
same situation as the former serfs and slaves. Rothbard sees the obvious
_"economic power"_ in the later case, but denies it in the former. But the
**conditions** of the people in question are identical and it is these
conditions that horrify us. It is only his ideology that stops Rothbard
drawing the obvious conclusion -- identical conditions produce identical
social relationships and so if the formally "free" ex-serfs are subject to
_"economic power"_ and _"masters"_ then so are the formally "free" labourers
within capitalism! Both sets of workers may be formally free, but their
circumstances are such that they are "free" to "consent" to sell their freedom
to others (i.e. economic power produces relationships of domination and
unfreedom between formally free individuals).

Thus Rothbard's definition of liberty in terms of rights fails to provide us
with a realistic and viable understanding of freedom. Someone can be a virtual
slave while still having her rights non-violated (conversely, someone can have
their property rights violated and still be free; for example, the child who
enters your backyard without your permission to get her ball hardly violates
your liberty -- indeed, you would never know that she has entered your
property unless you happened to see her do it). So the idea that freedom means
non-aggression against person and their legitimate material property justifies
extensive **non-freedom** for the working class. The non-violation of property
rights does **not** imply freedom, as Rothbard's discussion of the former
slaves shows. Anyone who, along with Rothbard, defines freedom _"as the
**absence of invasion** by another man of any man's person or property"_ in a
deeply inequality society is supporting, and justifying, capitalist and
landlord domination. As anarchists have long realised, in an unequal society,
a contractarian starting point implies an absolutist conclusion.

Why is this? Simply because freedom is a result of **social** interaction, not
the product of some isolated, abstract individual (Rothbard uses the model of
Robinson Crusoe to construct his ideology). But as Bakunin argued, _"the
freedom of the individual is a function of men in society, a necessary
consequence of the collective development of mankind."_ He goes on to argue
that _"man in isolation can have no awareness of his liberty . . . Liberty is
therefore a feature not of isolation but of interaction, not of exclusion but
rather of connection."_ [**Selected Writings**, p. 146, p. 147] Right
Libertarians, by building their definition of freedom from the isolated
person, end up by supporting restrictions of liberty due to a neglect of an
adequate recognition of the actual interdependence of human beings, of the
fact what each person does is effected by and affects others. People become
aware of their humanity (liberty) in society, not outside it. It is the
**social relationships** we take part in which determine how free we are and
any definition of freedom which builds upon an individual without social ties
is doomed to create relations of domination, not freedom, between individuals
-- as Rothbard's theory does (to put it another way, voluntary association is
a necessary, but not sufficient, condition for freedom. Which is why
anarchists have always stressed the importance of equality -- see [section
3](append133.html) for details).

So while facts of nature can restrict your options and freedom, it is the
circumstances within which they act and the options they limit that are
important (a person trapped at the bottom of a pit is unfree as the options
available are so few; the lame person is free because their available options
are extensive). In the same manner, the facts of society can and do restrict
your freedom because they are the products of human action and are defined and
protected by human institutions, it is the circumstances within which
individuals make their decisions and the social relationships these decisions
produce that are important (the worker driven by poverty to accept a slave
contract in a sweat shop is unfree because the circumstances he faces have
limited his options and the relations he accepts are based upon hierarchy; the
person who decides to join an anarchist commune is free because the commune is
non-hierarchical and she has the option of joining another commune, working
alone and so forth).

All in all, the right-Libertarian concept of freedom is lacking. For an
ideology that takes the name "Libertarianism" it is seems happy to ignore
actual liberty and instead concentrate on an abstract form of liberty which
ignores so many sources of unfreedom as to narrow the concept until it becomes
little more than a justification for authoritarianism. This can be seen from
right-Libertarian attitudes about private property and its effects on liberty
(as discussed in the [next section](append132.html#secf22)).

## 2.2 How does private property affect freedom?

The right-libertarian does not address or even acknowledge that the (absolute)
right of private property may lead to extensive control by property owners
over those who use, but do not own, property (such as workers and tenants).
Thus a free-market capitalist system leads to a very selective and class-based
protection of "rights" and "freedoms." For example, under capitalism, the
"freedom" of employers inevitably conflicts with the "freedom" of employees.
When stockholders or their managers exercise their "freedom of enterprise" to
decide how their company will operate, they violate their employee's right to
decide how their labouring capacities will be utilised. In other words, under
capitalism, the "property rights" of employers will conflict with and restrict
the "human right" of employees to manage themselves. Capitalism allows the
right of self-management only to the few, not to all. Or, alternatively,
capitalism does not recognise certain human rights as **universal** which
anarchism does.

This can be seen from Austrian Economist W. Duncan Reekie's defence of wage
labour. While referring to _"intra-firm labour markets"_ as _"hierarchies"_,
Reekie (in his best _ex cathedra_ tone) states that _"[t]here is nothing
authoritarian, dictatorial or exploitative in the relationship. Employees
order employers to pay them amounts specified in the hiring contract just as
much as employers order employees to abide by the terms of the contract."_
[**Markets, Entrepreneurs and Liberty**, p. 136, p. 137]. Given that _"the
terms of contract"_ involve the worker agreeing to obey the employers orders
and that they will be fired if they do not, its pretty clear that the ordering
that goes on in the _"intra-firm labour market"_ is decidedly **one way**.
Bosses have the power, workers are paid to obey. And this begs the question,
**if** the employment contract creates a free worker, why must she abandon her
liberty during work hours?

Reekie actually recognises this lack of freedom in a "round about" way when he
notes that _"employees in a firm at any level in the hierarchy can exercise an
entrepreneurial role. The area within which that role can be carried out
increases the more authority the employee has."_ [**Op. Cit.**, p. 142] Which
means workers **are** subject to control from above which restricts the
activities they are allowed to do and so they are **not** free to act, make
decisions, participate in the plans of the organisation, to create the future
and so forth within working hours. And it is strange that while recognising
the firm as a hierarchy, Reekie tries to deny that it is authoritarian or
dictatorial -- as if you could have a hierarchy without authoritarian
structures or an unelected person in authority who is not a dictator. His
confusion is shared by Austrian guru Ludwig von Mises, who asserts that the
_"entrepreneur and capitalist are not irresponsible autocrats"_ because they
are _"unconditionally subject to the sovereignty of the consumer"_ while, **on
the next page**, admitting there is a _"managerial hierarchy"_ which contains
_"the average subordinate employee."_ [**Human Action**, p. 809 and p. 810] It
does not enter his mind that the capitalist may be subject to some consumer
control while being an autocrat to their subordinated employees. Again, we
find the right-"libertarian" acknowledging that the capitalist managerial
structure is a hierarchy and workers are subordinated while denying it is
autocratic to the workers! Thus we have "free" workers within a relationship
distinctly **lacking** freedom (in the sense of self-government) -- a strange
paradox. Indeed, if your personal life were as closely monitored and regulated
as the work life of millions of people across the world, you would rightly
consider it oppression.

Perhaps Reekie (like most right-libertarians) will maintain that workers
voluntarily agree ("consent") to be subject to the bosses dictatorship (he
writes that _"each will only enter into the contractual agreement known as a
firm if each believes he will be better off thereby. The firm is simply
another example of mutually beneficial exchange"_ [**Op. Cit.**, p. 137]).
However, this does not stop the relationship being authoritarian or
dictatorial (and so exploitative as it is **highly** unlikely that those at
the top will not abuse their power). And as we argue further in the [next
section](append132.html#secf23) (and also see sections [B.4](secB4.html),
[3.1](append133.html#secf31) and [10.2](append1310.html#secf102)), in a
capitalist society workers have the option of finding a job or facing abject
poverty and/or starvation.

Little wonder, then, that people "voluntarily" sell their labour and "consent"
to authoritarian structures! They have little option to do otherwise. So,
**within** the labour market, workers **can** and **do** seek out the best
working conditions possible, but that does not mean that the final contract
agreed is "freely" accepted and not due to the force of circumstances, that
both parties have equal bargaining power when drawing up the contract or that
the freedom of both parties is ensured. Which means to argue (as many right-
libertarians do) that freedom cannot be restricted by wage labour because
people enter into relationships they consider will lead to improvements over
their initial situation totally misses the points. As the initial situation is
not considered relevant, their argument fails. After all, agreeing to work in
a sweatshop 14 hours a day **is** an improvement over starving to death -- but
it does not mean that those who so agree are free when working there or
actually **want** to be there. They are not and it is the circumstances,
created and enforced by the law, that have ensured that they "consent" to such
a regime (given the chance, they would desire to **change** that regime but
cannot as this would violate their bosses property rights and they would be
repressed for trying).

So the right-wing "libertarian" right is interested only in a narrow concept
of freedom (rather than in "freedom" or "liberty" as such). This can be seen
in the argument of Ayn Rand (a leading ideologue of "libertarian" capitalism)
that _"**Freedom**, in a political context, means freedom from government
coercion. It does **not** mean freedom from the landlord, or freedom from the
employer, or freedom from the laws of nature which do not provide men with
automatic prosperity. It means freedom from the coercive power of the state --
and nothing else!"_ [**Capitalism: The Unknown Ideal**, p. 192] By arguing in
this way, right libertarians ignore the vast number of authoritarian social
relationships that exist in capitalist society and, as Rand does here, imply
that these social relationships are like "the laws of nature." However, if one
looks at the world without prejudice but with an eye to maximising freedom,
the major coercive institution is seen to be not the state but capitalist
social relationships (as indicated in [section B.4](secB4.html)).

The right "libertarian," then, far from being a defender of freedom, is in
fact a keen defender of certain forms of authority and domination. As Peter
Kropotkin noted, the _"modern Individualism initiated by Herbert Spencer is,
like the critical theory of Proudhon, a powerful indictment against the
dangers and wrongs of government, but its practical solution of the social
problem is miserable -- so miserable as to lead us to inquire if the talk of
'No force' be merely an excuse for supporting landlord and capitalist
domination."_ [**Act For Yourselves**, p. 98]

To defend the "freedom" of property owners is to defend authority and
privilege -- in other words, statism. So, in considering the concept of
liberty as "freedom from," it is clear that by defending private property (as
opposed to possession) the "anarcho"-capitalist is defending the power and
authority of property owners to govern those who use "their" property. And
also, we must note, defending all the petty tyrannies that make the work lives
of so many people frustrating, stressful and unrewarding.

However, anarchism, by definition, is in favour of organisations and social
relationships which are non-hierarchical and non-authoritarian. Otherwise,
some people are more free than others. Failing to attack hierarchy leads to
massive contradiction. For example, since the British Army is a volunteer one,
it is an "anarchist" organisation! (see [next section](append132.html#secf23)
for a discussion on why the "anarcho"-capitalism concept of freedom also
allows the state to appear "libertarian").

In other words, "full capitalist property rights" do not protect freedom, in
fact they actively deny it. But this lack of freedom is only inevitable if we
accept capitalist private property rights. If we reject them, we can try and
create a world based on freedom in all aspects of life, rather than just in a
few.

## 2.3 Can "anarcho"-capitalist theory justify the state?

Ironically enough, "anarcho"-capitalist ideology actually allows the state to
be justified along with capitalist hierarchy. This is because the reason why
capitalist authority is acceptable to the "anarcho"-capitalist is because it
is "voluntary" -- no one forces the worker to join or remain within a specific
company (force of circumstances are irrelevant in this viewpoint). Thus
capitalist domination is not really domination at all. But the same can be
said of all democratic states as well. Few such states bar exit for its
citizens -- they are free to leave at any time and join any other state that
will have them (exactly as employees can with companies). Of course there
**are** differences between the two kinds of authority -- anarchists do not
deny that -- but the similarities are all too clear.

The "anarcho"-capitalist could argue that changing jobs is easier than
changing states and, sometimes, this is correct -- but not always. Yes,
changing states does require the moving of home and possessions over great
distances but so can changing job (indeed, if a worker has to move half-way
across a country or even the world to get a job "anarcho"-capitalists would
celebrate this as an example of the benefits of a "flexible" labour market).
Yes, states often conscript citizens and send them into dangerous situations
but bosses often force their employees to accept dangerous working
environments on pain of firing. Yes, many states do restrict freedom of
association and speech, but so do bosses. Yes, states tax their citizens but
landlords and companies only let others use their property if they get money
in return (i.e. rent or profits). Indeed, if the employee or tenant does not
provide the employer or landlord with enough profits, they will quickly be
shown the door. Of course employees can start their own companies but citizens
can start their own state if they convince an existing state (the owner of a
set of resources) to sell/give land to them. Setting up a company also
requires existing owners to sell/give resources to those who need them. Of
course, in a democratic state citizens can influence the nature of laws and
orders they obey. In a capitalist company, this is not the case.

This means that, logically, "anarcho"-capitalism must consider a series of
freely exitable states as "anarchist" and not a source of domination. If
consent (not leaving) is what is required to make capitalist domination not
domination then the same can be said of statist domination. Stephen L. Newman
makes the same point:

> _"The emphasis [right-wing] libertarians place on the opposition of liberty
and political power tends to obscure the role of authority in their worldview
. . . the authority exercised in private relationships, however -- in the
relationship between employer and employee, for instance -- meets with no
objection. . . . [This] reveals a curious insensitivity to the use of private
authority as a means of social control. Comparing public and private
authority, we might well ask of the [right-wing] libertarians: When the price
of exercising one's freedom is terribly high, what practical difference is
there between the commands of the state and those issued by one's employer? .
. . Though admittedly the circumstances are not identical, telling disgruntled
empowers that they are always free to leave their jobs seems no different in
principle from telling political dissidents that they are free to emigrate."_
[**Liberalism at Wit's End**, pp. 45-46]

Murray Rothbard, in his own way, agrees:

> _"**If** the State may be said too properly **own** its territory, then it
is proper for it to make rules for everyone who presumes to live in that area.
It can legitimately seize or control private property because there **is** no
private property in its area, because it really owns the entire land surface.
**So long** as the State permits its subjects to leave its territory, then, it
can be said to act as does any other owner who sets down rules for people
living on his property."_ [**The Ethics of Liberty**, p. 170]

Rothbard's argues that this is **not** the case simply because the state did
not acquire its property in a _"just"_ manner and that it claims rights over
virgin land (both of which violates Rothbard's "homesteading" theory of
property -- see [section 4.1](append134.html#secf41) for details and a
critique). Rothbard argues that this defence of statism (the state as property
owner) is unrealistic and ahistoric, but his account of the origins of
property is equally unrealistic and ahistoric and that does not stop him
supporting capitalism. People in glass houses should not throw stones!

Thus he claims that the state is evil and its claims to authority/power false
simply because it acquired the resources it claims to own _"unjustly"_ \-- for
example, by violence and coercion (see **The Ethics of Liberty**, pp. 170-1,
for Rothbard's attempt to explain why the state should not be considered as
the owner of land). And even **if** the state **was** the owner of its
territory, it cannot appropriate virgin land (although, as he notes elsewhere,
the _"vast"_ US frontier no longer exists _"and there is no point crying over
the fact"_ [**Op. Cit.**, p. 240]).

So what makes hierarchy legitimate for Rothbard is whether the property it
derives from was acquired justly or unjustly. Which leads us to a few **very**
important points.

Firstly, Rothbard is explicitly acknowledging the similarities between statism
and capitalism. He is arguing that **if** the state had developed in a
_"just"_ way, then it is perfectly justifiable in governing (_"set[ting] down
rules"_) those who "consent" to live on its territory in **exactly** the same
why a property owner does. In other words, private property can be considered
as a "justly" created state! These similarities between property and statism
have long been recognised by anarchists and that is why we reject private
property along with the state (Proudhon did, after all, note that _"property
is despotism"_ and well as _"theft"_). But, according to Rothbard, something
can look like a state (i.e. be a monopoly of decision making over an area) and
act like a state (i.e. set down rules for people, govern them, impose a
monopoly of force) but not be a state. But if it looks like a duck and sounds
like a duck, it is a duck. Claiming that the origins of the thing are what
counts is irrelevant -- for example, a cloned duck is just as much a duck as a
naturally born one. A statist organisation is authoritarian whether it comes
from _"just"_ or _"unjust"_ origins. Does transforming the ownership of the
land from states to capitalists **really** make the relations of domination
created by the dispossession of the many less authoritarian and unfree? Of
course not.

Secondly, much property in "actually existing" capitalism is the product
(directly or indirectly) of state laws and violence (_"the emergence of both
agrarian and industrial capitalism in Britain [and elsewhere, we must add] . .
. could not have got off the ground without resources to state violence --
legal or otherwise"_ [Brian Morris, **Ecology &amp; Anarchism**, p. 190]). If
state claims of ownership are invalid due to their history, then so are many
others (particularly those which claim to own land). As the initial creation
was illegitimate, so are the transactions which have sprung from it. Thus if
state claims of property rights are invalid, so are most (if not all)
capitalist claims. If the laws of the state are illegitimate, so are the rules
of the capitalist. If taxation is illegitimate, then so are rent, interest and
profit. Rothbard's "historical" argument against the state can also be applied
to private property and if the one is unjustified, then so is the other.

Thirdly, **if** the state had evolved "justly" then Rothbard would actually
have nothing against it! A strange position for an anarchist to take.
Logically this means that if a system of corporate states evolved from the
workings of the capitalist market then the "anarcho"-capitalist would have
nothing against it. This can be seen from "anarcho"-capitalist support for
company towns even though they have correctly been described as _"industrial
feudalism"_ (see [section 6](append136.html) for more on this).

Fourthly, Rothbard's argument implies that similar circumstances producing
similar relationships of domination and unfreedom are somehow different if
they are created by _"just"_ and _"unjust"_ means. Rothbard claims that
because the property is _"justly"_ acquired it means the authority a
capitalist over his employees is totally different from that of a state over
its subject. But such a claim is false -- both the subject/citizen and the
employee are in a similar relationship of domination and authoritarianism. As
we argued in [section 2.2](append132.html#secf22), how a person got into a
situation is irrelevant when considering how free they are. Thus, the person
who "consents" to be governed by another because all available resources are
privately owned is in exactly the same situation as a person who has to join a
state because all available resources are owned by one state or another. Both
are unfree and are part of authoritarian relationships based upon domination.

And, lastly, while "anarcho"-capitalism may be a "just" society, it is
definitely **not** a free one. It will be marked by extensive hierarchy,
unfreedom and government, but these restrictions of freedom will be of a
private nature. As Rothbard indicates, the property owner and the state
create/share the same authoritarian relationships. If statism is unfree, then
so is capitalism. And, we must add, how "just" is a system which undermines
liberty. Can "justice" ever be met in a society in which one class has more
power and freedom than another. If one party is in an inferior position, then
they have little choice but to agree to the disadvantageous terms offered by
the superior party (see [section 3.1](append133.html#secf31)). In such a
situation, a "just" outcome will be unlikely as any contract agreed will be
skewed to favour one side over the other.

The implications of these points are important. We can easily imagine a
situation within "anarcho"-capitalism where a few companies/people start to
buy up land and form company regions and towns. After all, this **has**
happened continually throughout capitalism. Thus a "natural" process may
develop where a few owners start to accumulate larger and larger tracks of
land "justly". Such a process does not need to result in **one** company
owning the world. It is likely that a few hundred, perhaps a few thousand,
could do so. But this is not a cause for rejoicing -- after all the current
"market" in "unjust" states also has a few hundred competitors in it. And even
if there is a large multitude of property owners, the situation for the
working class is exactly the same as the citizen under current statism! Does
the fact that it is "justly" acquired property that faces the worker really
change the fact she must submit to the government and rules of another to gain
access to the means of life?

When faced with anarchist criticisms that **circumstances** force workers to
accept wage slavery the "anarcho"-capitalist claims that these are to be
considered as objective facts of nature and so wage labour is not domination.
However, the same can be said of states -- we are born into a world where
states claim to own all the available land. If states are replaced by
individuals or groups of individuals does this change the essential nature of
our dispossession? Of course not.

Rothbard argues that _"[o]bviously, in a free society, Smith has the ultimate
decision-making power over his own just property, Jones over his, etc."_
[**Op. Cit.**, p. 173] and, equally obviously, this ultimate-decision making
power extends to those who **use,** but do not own, such property. But how
"free" is a free society where the majority have to sell their liberty to
another in order to live? Rothbard (correctly) argues that the State _"uses
its monopoly of force . . . to control, regulate, and coerce its hapless
subjects. Often it pushes its way into controlling the morality and the very
lives of its subjects."_ [**Op. Cit.**, p. 171] However he fails to note that
employers do exactly the same thing to their employees. This, from an
anarchist perspective, is unsurprising, for (after all) the employer **is**
_"the ultimate decision-making power over his just property"_ just as the
state is over its "unjust" property. That similar forms of control and
regulation develop is not a surprise given the similar hierarchical relations
in both structures.

That there is a choice in available states does not make statism any less
unjust and unfree. Similarly, just because we have a choice between employers
does not make wage labour any less unjust or unfree. But trying to dismiss one
form of domination as flowing from "just" property while attacking the other
because it flows from "unjust" property is not seeing the wood for the trees.
If one reduces liberty, so does the other. Whether the situation we are in
resulted from "just" or "unjust" steps is irrelevant to the restrictions of
freedom we face because of them (and as we argue in [ section
2.5](append132.html#secf25), "unjust" situations can easily flow from "just"
steps).

The "anarcho"-capitalist insistence that the voluntary nature of an
association determines whether it is anarchistic is deeply flawed -- so flawed
in fact that states and state-like structures (such as capitalist firms) can
be considered anarchistic! In contrast, anarchists think that the hierarchical
nature of the associations we join is equally as important as its voluntary
nature when determining whether it is anarchistic or statist. However this
option is not available to the "anarcho"-capitalist as it logically entails
that capitalist companies are to be opposed along with the state as sources of
domination, oppression and exploitation.

## 2.4 But surely transactions on the market are voluntary?

Of course, it is usually maintained by "anarcho"-capitalists that no-one puts
a gun to a worker's head to join a specific company. Yes, indeed, this is true
-- workers can apply for any job they like. But the point is that the vast
majority cannot avoid having to sell their liberty to others (self-employment
and co-operatives **are** an option, but they account for less than 10% of the
working population and are unlikely to spread due to the nature of capitalist
market forces -- see sections [J.5.11](secJ5.html#secj511) and
[J.5.12](secJ5.html#secj512) for details). And as Bob Black pointed out, right
libertarians argue that _"'one can at least change jobs.' but you can't avoid
having a job -- just as under statism one can at least change nationalities
but you can't avoid subjection to one nation-state or another. But freedom
means more than the right to change masters."_ [**The Libertarian as
Conservative**]

So why do workers agree to join a company? Because circumstances force them to
do so - circumstances created, we must note, by **human** actions and
institutions and not some abstract "fact of nature." And if the world that
humans create by their activity is detrimental to what we should value most
(individual liberty and individuality) then we should consider how to **change
that world for the better.** Thus "circumstances" (current "objective
reality") is a valid source of unfreedom and for human investigation and
creative activity -- regardless of the claims of right-Libertarians.

Let us look at the circumstances created by capitalism. Capitalism is marked
by a class of dispossessed labourers who have nothing to sell by their labour.
They are legally barred from access to the means of life and so have little
option but to take part in the labour market. As Alexander Berkman put it:

> _"The law says your employer does not sell anything from you, because it is
done with your consent. You have agreed to work for your boss for certain pay,
he to have all that you produce . . . _

>

> _"But did you really consent? _

>

> _"When the highway man holds his gun to your head, you turn your valuables
over to him. You 'consent' all right, but you do so because you cannot help
yourself, because you are **compelled** by his gun. _

>

> _"Are you not **compelled** to work for an employer? Your need compels you
just as the highwayman's gun. You must live. . . You can't work for yourself .
. .The factories, machinery, and tools belong to the employing class, so you
**must** hire yourself out to that class in order to work and live. Whatever
you work at, whoever your employer may be, it is always comes to the same: you
must work **for him**. You can't help yourself. You are **compelled**."_
[**What is Communist Anarchism?**, p. 9]

Due to this class monopoly over the means of life, workers (usually) are at a
disadvantage in terms of bargaining power -- there are more workers than jobs
(see sections [B.4.3](secB4.html#secb43) and [10.2](append1310.html#secf102)
for a discussion why this is the normal situation on the labour market).

As was indicated in section B.4 ([How does capitalism affect
liberty?](secB4.html)), within capitalism there is no equality between owners
and the dispossessed, and so property is a source of **power.** To claim that
this power should be "left alone" or is "fair" is _"to the anarchists. . .
preposterous. Once a State has been established, and most of the country's
capital privatised, the threat of physical force is no longer necessary to
coerce workers into accepting jobs, even with low pay and poor conditions. To
use Ayn Rand's term, 'initial force' has **already taken place,** by those who
now have capital against those who do not. . . . In other words, if a thief
died and willed his 'ill-gotten gain' to his children, would the children have
a right to the stolen property? Not legally. So if 'property is theft,' to
borrow Proudhon's quip, and the fruit of exploited labour is simply legal
theft, then the only factor giving the children of a deceased capitalist a
right to inherit the 'booty' is the law, the State. As Bakunin wrote, 'Ghosts
should not rule and oppress this world, which belongs only to the living'"_
[Jeff Draughn, **Between Anarchism and Libertarianism**].

Or, in other words, right-Libertarianism fails to _"meet the charge that
normal operations of the market systematically places an entire class of
persons (wage earners) in circumstances that compel them to accept the terms
and conditions of labour dictated by those who offer work. While it is true
that individuals are formally free to seek better jobs or withhold their
labour in the hope of receiving higher wages, in the end their position in the
market works against them; they cannot live if they do not find employment.
When circumstances regularly bestow a relative disadvantage on one class of
persons in their dealings with another class, members of the advantaged class
have little need of coercive measures to get what they want."_ [Stephen L.
Newman, **Liberalism at Wit's End**, p. 130]

To ignore the circumstances which drive people to seek out the most
"beneficial exchange" is to blind yourself to the power relationships inherent
within capitalism -- power relationships created by the unequal bargaining
power of the parties involved (also see [section 3.1](append133.html#secf31)).
And to argue that "consent" ensures freedom is false; if you are "consenting"
to be join a dictatorial organisation, you "consent" **not** to be free (and
to paraphrase Rousseau, a person who renounces freedom renounces being human).

Which is why circumstances are important -- if someone truly wants to join an
authoritarian organisation, then so be it. It is their life. But if
circumstances ensure their "consent" then they are not free. The danger is, of
course, that people become **accustomed** to authoritarian relationships and
end up viewing them as forms of freedom. This can be seen from the state,
which the vast majority support and "consent" to. And this also applies to
wage labour, which many workers today accept as a "necessary evil" (like the
state) but, as we indicate in [section 8.6](append138.html#secf86), the first
wave of workers viewed with horror as a form of (wage) slavery and did all
that they could to avoid. In such situations all we can do is argue with them
and convince them that certain forms of organisations (such as the state and
capitalist firms) are an evil and urge them to change society to ensure their
extinction.

So due to this lack of appreciation of circumstances (and the fact that people
become accustomed to certain ways of life) "anarcho"-capitalism actively
supports structures that restrict freedom for the many. And how is
"anarcho"-capitalism **anarchist** if it generates extensive amounts of archy?
It is for this reason that all anarchists support self-management within free
association -- that way we maximise freedom both inside **and** outside
organisations. But only stressing freedom outside organisations,
"anarcho"-capitalism ends up denying freedom as such (after all, we spend most
of our waking hours at work). If "anarcho"-capitalists **really** desired
freedom, they would reject capitalism and become anarchists -- only in a
libertarian socialist society would agreements to become a wage worker be
truly voluntary as they would not be driven by circumstances to sell their
liberty.

This means that while right-Libertarianism appears to make "choice" an ideal
(which sounds good, liberating and positive) in practice it has become a
"dismal politics," a politics of choice where most of the choices are bad.
And, to state the obvious, the choices we are "free" to make are shaped by the
differences in wealth and power in society (see [section
3.1](append133.html#secf31)) as well as such things as "isolation paradoxes"
(see [ section B.6](secB6.html)) and the laws and other human institutions
that exist. If we ignore the context within which people make their choices
then we glorify abstract processes at the expense of real people. And, as
importantly, we must add that many of the choices we make under capitalism
(shaped as they are by the circumstances within which they are made), such as
employment contracts, result in our "choice" being narrowed to "love it or
leave it" in the organisations we create/join as a result of these "free"
choices.

This ideological blind spot flows from the "anarcho"-capitalist definition of
"freedom" as "absence of coercion" -- as workers "freely consent" to joining a
specific workplace, their freedom is unrestricted. But to defend **only**
"freedom from" in a capitalist society means to defend the power and authority
of the few against the attempts of the many to claim their freedom and rights.
To requote Emma Goldman, _"'Rugged individualism' has meant all the
'individualism' for the masters . . . , in whose name political tyranny and
social oppression are defended and held up as virtues' while every aspiration
and attempt of man to gain freedom . . . is denounced as . . . evil in the
name of that same individualism."_ [**Red Emma Speaks**, p. 112]

In other words, its all fine and well saying (as right-libertarians do) that
you aim to abolish force from human relationships but if you support an
economic system which creates hierarchy (and so domination and oppression) by
its very workings, "defensive" force will always be required to maintain and
enforce that domination. Moreover, if one class has extensive power over
another due to the systematic (and normal) workings of the market, any force
used to defend that power is **automatically** "defensive". Thus to argue
against the use of force and ignore the power relationships that exist within
and shape a society (and so also shape the individuals within it) is to defend
and justify capitalist and landlord domination and denounce any attempts to
resist that domination as "initiation of force."

Anarchists, in contrast, oppose **hierarchy** (and so domination within
relationships -- bar S&amp;M personal relationships, which are a totally
different thing altogether; they are truly voluntary and they also do not
attempt to hide the power relationships involved by using economic jargon).
This opposition, while also including opposition to the use of force against
equals (for example, anarchists are opposed to forcing workers and peasants to
join a self-managed commune or syndicate), also includes support for the
attempts of those subject to domination to end it (for example, workers
striking for union recognition are not "initiating force", they are fighting
for their freedom).

In other words, apparently "voluntary" agreements can and do limit freedom and
so the circumstances that drive people into them **must** be considered when
deciding whether any such limitation is valid. By ignoring circumstances,
"anarcho"-capitalism ends up by failing to deliver what it promises -- a
society of free individuals -- and instead presents us with a society of
masters and servants. The question is, what do we feel moved to insist that
people enjoy? Formal, abstract (bourgeois) self-ownership ("freedom") or a
more substantive control over one's life (i.e. autonomy)?

## 2.5 But surely circumstances are the result of liberty and so cannot be
objected to?

It is often argued by right-libertarians that the circumstances we face within
capitalism are the result of individual decisions (i.e. individual liberty)
and so we must accept them as the expressions of these acts (the most famous
example of this argument is in Nozick's **Anarchy, State, and Utopia** pp.
161-163 where he maintains that _"liberty upsets patterns"_). This is because
whatever situation evolves from a just situation by just (i.e. non-coercive
steps) is also (by definition) just.

However, it is not apparent that adding just steps to a just situation will
result in a just society. We will illustrate with a couple of banal examples.
If you add chemicals which are non-combustible together you can create a new,
combustible, chemical (i.e. X becomes not-X by adding new X to it). Similarly,
if you have an odd number and add another odd number to it, it becomes even
(again, X becomes not-X by adding a new X to it). So it **is** very possible
to go from an just state to an unjust state by just step (and it is possible
to remain in an unjust state by just acts; for example if we tried to
implement "anarcho"-capitalism on the existing -- unjustly created --
situation of "actually existing" capitalism it would be like having an odd
number and adding even numbers to it). In other words, the outcome of "just"
steps can increase inequality within society and so ensure that some acquire
an unacceptable amount of power over others, via their control over resources.
Such an inequality of power would create an "unjust" situation where the major
are free to sell their liberty to others due to inequality in power and
resources on the "free" market.

Ignoring this objection, we could argue (as many "anarcho"-capitalists and
right-libertarians do) that the unforeseen results of human action are fine
unless we assume that these human actions are in themselves bad (i.e. that
individual choice is evil).

Such an argument is false for three reasons.

First, when we make our choices the aggregate impact of these choices are
unknown to us -- and not on offer when we make our choices. Thus we cannot be
said to "choose" these outcomes, outcomes which we may consider deeply
undesirable, and so the fact that these outcomes are the result of individual
choices is besides the point (if we knew the outcome we could refrain from
doing them). The choices themselves, therefore, do not validate the outcome as
the outcome was not part of the choices when they where made (i.e. the means
do not justify the ends). In other words, private acts often have important
public consequences (and "bilateral exchanges" often involve externalities for
third parties). Secondly, if the outcome of individual choices is to deny or
restrict individual choice on a wider scale at a later stage, then we are
hardly arguing that individual choice is a bad thing. We want to arrange it so
that the decisions we make now do not result in them restricting our ability
to make choices in important areas of life at a latter stage. Which means we
are in favour of individual choices and so liberty, not against them. Thirdly,
the unforeseen or unplanned results of individual actions are not necessarily
a good thing. If the aggregate outcome of individual choices harms individuals
then we have a right to modify the circumstances within which choices are made
and/or the aggregate results of these choices.

An example will show what we mean (again drawn from Haworth's excellent
**Anti-Libertarianism**, p. 35). Millions of people across the world bought
deodorants which caused a hole to occur in the ozone layer surrounding the
Earth. The resultant of these acts created a situation in which individuals
and the eco-system they inhabited were in great danger. The actual acts
themselves were by no means wrong, but the aggregate impact was. A similar
argument can apply to any form of pollution. Now, unless the right-Libertarian
argues that skin cancer or other forms of pollution related illness are fine,
its clear that the resultant of individual acts can be harmful to individuals.

The right-Libertarian could argue that pollution is an "initiation of force"
against an individual's property-rights in their person and so individuals can
sue the polluters. But hierarchy also harms the individual (see [section
B.1](secB1.html)) -- and so can be considered as an infringement of their
"property-rights" (i.e. liberty, to get away from the insane property fetish
of right-Libertarianism). The loss of autonomy can be just as harmful to an
individual as lung cancer although very different in form. And the differences
in wealth resulting from hierarchy is well known to have serious impacts on
life-span and health.

As noted in [section 2.1](append132.html#secf21), the market is just as man-
made as pollution. This means that the "circumstances" we face are due to
aggregate of millions of individual acts and these acts occur within a
specific framework of rights, institutions and ethics. Anarchists think that a
transformation of our society and its rights and ideals is required so that
the resultant of individual choices does not have the ironic effect of
limiting individual choice (freedom) in many important ways (such as in work,
for example).

In other words, the **circumstances** created by capitalist rights and
institutions requires a **transformation** of these rights and institutions in
such a way as to maximise individual choice for all -- namely, to abolish
these rights and replace them with new ones (for example, replace property
rights with use rights). Thus Nozick's claims that _"Z does choose voluntarily
if the other individuals A through Y each acted voluntarily and within their
rights"_ [**Op. Cit.**, p. 263] misses the point -- it is these rights that
are in question (given that Nozick **assumes** these rights then his whole
thesis is begging the question).

And we must add (before anyone points it out) that, yes, we are aware that
many decisions will unavoidably limit current and future choices. For example,
the decision to build a factory on a green-belt area will make it impossible
for people to walk through the woods that are no longer there. But such
"limitations" (if they can be called that) of choice are different from the
limitations we are highlighting here, namely the lose of freedom that
accompanies the circumstances created via exchange in the market. The human
actions which build the factory modify reality but do not generate social
relationships of domination between people in so doing. The human actions of
market exchange, in contrast, modify the relative strengths of everyone in
society and so has a distinct impact on the social relationships we
"voluntarily" agree to create. Or, to put it another way, the decision to
build on the green-belt site does "limit" choice in the abstract but it does
**not** limit choice in the kind of relationships we form with other people
nor create authoritarian relationships between people due to inequality
influencing the content of the associations we form. However, the profits
produced from using the factory increases inequality (and so market/economic
power) and so weakens the position of the working class in respect to the
capitalist class within society. This increased inequality will be reflected
in the "free" contracts and working regimes that are created, with the weaker
"trader" having to compromise far more than before.

So, to try and defend wage slavery and other forms of hierarchy by arguing
that "circumstances" are created by individual liberty runs aground on its own
logic. If the circumstances created by individual liberty results in pollution
then the right-Libertarian will be the first to seek to change those
circumstances. They recognise that the right to pollute while producing is
secondary to our right to be healthy. Similarly, if the circumstances created
by individual liberty results in hierarchy (pollution of the mind and our
relationships with others as opposed to the body, although it affects that to)
then we are entitled to change these circumstances too and the means by which
we get there (namely the institutional and rights framework of society). Our
right to liberty is more important than the rights of property -- sadly, the
right-Libertarian refuses to recognise this.

## 2.6 Do Libertarian-capitalists support slavery?

Yes. It may come as a surprise to many people, but right-Libertarianism is one
of the few political theories that justifies slavery. For example, Robert
Nozick asks whether _"a free system would allow [the individual] to sell
himself into slavery"_ and he answers _"I believe that it would."_ [**Anarchy,
State and Utopia**, p. 371] While some right-Libertarians do not agree with
Nozick, there is no logical basis in their ideology for such disagreement.

The logic is simple, you cannot really own something unless you can sell it.
Self-ownership is one of the cornerstones of laissez-faire capitalist
ideology. Therefore, since you own yourself you can sell yourself.

(For Murray Rothbard's claims of the _"unenforceability, in libertarian
theory, of voluntary slave contracts"_ see **The Ethics of Liberty**, pp.
134-135 -- of course, **other** libertarian theorists claim the exact opposite
so _"libertarian theory"_ makes no such claims, but nevermind! Essentially,
his point revolves around the assertion that a person _"cannot, in nature,
sell himself into slavery and have this sale enforced - for this would mean
that his future will over his own body was being surrendered in advance"_ and
that if a _"labourer remains totally subservient to his master's will
voluntarily, he is not yet a slave since his submission is voluntary."_ [p.
40] However, as we noted in [ section 2](append132.html), Rothbard emphasis on
quitting fails to recognise that actual denial of will and control over ones
own body that is explicit in wage labour. It is this failure that pro-slave
contract "libertarians" stress -- as we will see, they consider the slave
contract as an extended wage contract. Moreover, a modern slave contract would
likely take the form of a _"performance bond"_ [p. 136] in which the slave
agrees to perform X years labour or pay their master substantial damages. The
threat of damages that enforces the contract and such a "contract" Rothbard
does agree is enforceable -- along with _"conditional exchange"_ [p. 141]
which could be another way of creating slave contracts.)

Nozick's defence of slavery should not come as a surprise to any one familiar
with classical liberalism. An elitist ideology, its main rationale is to
defend the liberty and power of property owners and justify unfree social
relationships (such as government and wage labour) in terms of "consent."
Nozick just takes it to its logical conclusion, a conclusion which Rothbard,
while balking at the label used, does not actually disagree with.

This is because Nozick's argument is not new but, as with so many others, can
be found in John Locke's work. The key difference is that Locke refused the
term _"slavery"_ and favoured _"drudgery"_ as, for him, slavery mean a
relationship _"between a lawful conqueror and a captive"_ where the former has
the power of life and death over the latter. Once a _"compact"_ is agreed
between them, _"an agreement for a limited power on the one side, and
obedience on the other . . . slavery ceases."_ As long as the master could not
kill the slave, then it was _"drudgery."_ Like Nozick, he acknowledges that
_"men did sell themselves; but, it is plain, this was only to drudgery, not to
slavery: for, it is evident, the person sold was not under an absolute,
arbitrary, despotical power: for the master could not have power to kill him,
at any time, whom, at a certain time, he was obliged to let go free out of his
service."_ [Locke, **Second Treatise of Government**, Section 24] In other
words, like Rothbard, voluntary slavery was fine but just call it something
else.

Not that Locke was bothered by involuntary slavery. He was heavily involved in
the slave trade. He owned shares in the "Royal Africa Company" which carried
on the slave trade for England, making a profit when he sold them. He also
held a significant share in another slave company, the "Bahama Adventurers."
In the _"Second Treatise"_, Locke justified slavery in terms of _"Captives
taken in a just war."_ [Section 85] In other words, a war waged against
aggressors. That, of course, had nothing to do with the **actual** slavery
Locke profited from (slave raids were common, for example). Nor did his
"liberal" principles stop him suggesting a constitution that would ensure that
_"every freeman of Carolina shall have absolute power and authority over his
Negro slaves."_ The constitution itself was typically autocratic and
hierarchical, designed explicitly to _"avoid erecting a numerous democracy."_
[**The Works of John Locke**, vol. X, p. 196]

So the notion of contractual slavery has a long history within right-wing
liberalism, although most refuse to call it by that name. It is of course
simply embarrassment that stops Rothbard calling a spade a spade. He
incorrectly assumes that slavery has to be involuntary. In fact, historically,
voluntary slave contracts have been common (David Ellerman's **Property and
Contract in Economics** has an excellent overview). Any new form of voluntary
slavery would be a "civilised" form of slavery and could occur when an
individual would "agree" to sell themselves to themselves to another (as when
a starving worker would "agree" to become a slave in return for food). In
addition, the contract would be able to be broken under certain conditions
(perhaps in return for breaking the contract, the former slave would have pay
damages to his or her master for the labour their master would lose - a
sizeable amount no doubt and such a payment could result in debt slavery,
which is the most common form of "civilised" slavery. Such damages may be
agreed in the contract as a "performance bond" or "conditional exchange").

In summary, right-Libertarians are talking about "civilised" slavery (or, in
other words, civil slavery) and not forced slavery. While some may have
reservations about calling it slavery, they agree with the basic concept that
since people own themselves they can sell themselves as well as selling their
labour for a lifetime.

We must stress that this is no academic debate. "Voluntary" slavery has been a
problem in many societies and still exists in many countries today
(particularly third world ones where bonded labour -- i.e. where debt is used
to enslave people -- is the most common form). With the rise of sweat shops
and child labour in many "developed" countries such as the USA, "voluntary"
slavery (perhaps via debt and bonded labour) may become common in all parts of
the world -- an ironic (if not surprising) result of "freeing" the market and
being indifferent to the actual freedom of those within it.

And it is interesting to note that even Murray Rothbard is not against the
selling of humans. He argued that children are the property of their parents.
They can (bar actually murdering them by violence) do whatever they please
with them, even sell them on a _"flourishing free child market."_ [**The
Ethics of Liberty**, p. 102] Combined with a whole hearted support for child
labour (after all, the child can leave its parents if it objects to working
for them) such a "free child market" could easily become a "child slave
market" -- with entrepreneurs making a healthy profit selling infants to other
entrepreneurs who could make profits from the toil of "their" children (and
such a process did occur in 19th century Britain). Unsurprisingly, Rothbard
ignores the possible nasty aspects of such a market in human flesh (such as
children being sold to work in factories, homes and brothels). And, of course,
such a market could see women "specialising" in producing children for it (the
use of child labour during the Industrial Revolution actually made it
economically sensible for families to have more children) and, perhaps, gluts
and scarcities of babies due to changing market conditions. But this is
besides the point.

Of course, this theoretical justification for slavery at the heart of an
ideology calling itself "libertarianism" is hard for many right-Libertarians
to accept. Some of the "anarcho"-capitalist type argue that such contracts
would be very hard to enforce in their system of capitalism. This attempt to
get out of the contradiction fails simply because it ignores the nature of the
capitalist market. If there is a demand for slave contracts to be enforced,
then companies will develop to provide that "service" (and it would be
interesting to see how two "protection" firms, one defending slave contracts
and another not, could compromise and reach a peaceful agreement over whether
slave contracts were valid). Thus we could see a so-called "anarchist" or
"free" society producing companies whose specific purpose was to hunt down
escaped slaves (i.e. individuals in slave contracts who have not paid damages
to their owners for freedom). Of course, perhaps Rothbard would claim that
such slave contracts would be "outlawed" under his "general libertarian law
code" but this is a denial of market "freedom". If slave contracts **are**
"banned" then surely this is paternalism, stopping individuals from
contracting out their "labour services" to whom and however long they
"desire". You cannot have it both ways.

So, ironically, an ideology proclaiming itself to support "liberty" ends up
justifying and defending slavery. Indeed, for the right-libertarian the slave
contract is an exemplification, not the denial, of the individual's liberty!
How is this possible? How can slavery be supported as an expression of
liberty? Simple, right-Libertarian support for slavery is a symptom of a
**deeper** authoritarianism, namely their uncritical acceptance of contract
theory. The central claim of contract theory is that contract is the means to
secure and enhance individual freedom. Slavery is the antithesis to freedom
and so, in theory, contract and slavery must be mutually exclusive. However,
as indicated above, some contract theorists (past and present) have included
slave contracts among legitimate contracts. This suggests that contract theory
cannot provide the theoretical support needed to secure and enhance individual
freedom. Why is this?

As Carole Pateman argues, _"contract theory is primarily about a way of
creating social relations constituted by subordination, not about exchange."_
Rather than undermining subordination, contract theorists justify modern
subjection -- _"contract doctrine has proclaimed that subjection to a master
-- a boss, a husband -- is freedom."_ [**The Sexual Contract**, p. 40 and p.
146] The question central to contract theory (and so right-Libertarianism) is
not "are people free" (as one would expect) but "are people free to
subordinate themselves in any manner they please." A radically different
question and one only fitting to someone who does not know what liberty means.

Anarchists argue that not all contracts are legitimate and no free individual
can make a contract that denies his or her own freedom. If an individual is
able to express themselves by making free agreements then those free
agreements must also be based upon freedom internally as well. Any agreement
that creates domination or hierarchy negates the assumptions underlying the
agreement and makes itself null and void. In other words, voluntary government
is still government and the defining chararacteristic of an anarchy must be,
surely, "no government" and "no rulers."

This is most easily seen in the extreme case of the slave contract. John
Stuart Mill stated that such a contract would be "null and void." He argued
that an individual may voluntarily choose to enter such a contract but in so
doing _"he abdicates his liberty; he foregoes any future use of it beyond that
single act. He therefore defeats, in his own case, the very purpose which is
the justification of allowing him to dispose of himself. . .The principle of
freedom cannot require that he should be free not to be free. It is not
freedom, to be allowed to alienate his freedom."_ He adds that _"these
reasons, the force of which is so conspicuous in this particular case, are
evidently of far wider application."_ [quoted by Pateman, **Op. Cit.**, pp.
171-2]

And it is such an application that defenders of capitalism fear (Mill did in
fact apply these reasons wider and unsurprisingly became a supporter of a
market syndicalist form of socialism). If we reject slave contracts as
illegitimate then, logically, we must also reject **all** contracts that
express qualities similar to slavery (i.e. deny freedom) including wage
slavery. Given that, as David Ellerman points out, _"the voluntary slave . . .
and the employee cannot in fact take their will out of their intentional
actions so that they could be 'employed' by the master or employer"_ we are
left with _"the rather implausible assertion that a person can vacate his or
her will for eight or so hours a day for weeks, months, or years on end but
cannot do so for a working lifetime."_ [**Property and Contract in
Economics**, p. 58]

The implications of supporting voluntary slavery is quite devastating for all
forms of right-wing "libertarianism." This was proven by Ellerman when he
wrote an extremely robust defence of it under the pseudonym "J. Philmore"
called **The Libertarian Case for Slavery** (first published in **The
Philosophical Forum**, xiv, 1982). This classic rebuttal takes the form of
"proof by contradiction" (or **reductio ad absurdum**) whereby he takes the
arguments of right-libertarianism to their logical end and shows how they
reach the memorably conclusion that the _"time has come for liberal economic
and political thinkers to stop dodging this issue and to critically re-examine
their shared prejudices about certain voluntary social institutions . . . this
critical process will inexorably drive liberalism to its only logical
conclusion: libertarianism that finally lays the true moral foundation for
economic and political slavery."_

Ellerman shows how, from a right-"libertarian" perspective there is a
_"fundamental contradiction"_ in a modern liberal society for the state to
prohibit slave contracts. He notes that there _"seems to be a basic shared
prejudice of liberalism that slavery is inherently involuntary, so the issue
of genuinely voluntary slavery has received little scrutiny. The perfectly
valid liberal argument that involuntary slavery is inherently unjust is thus
taken to include voluntary slavery (in which case, the argument, by
definition, does not apply). This has resulted in an abridgment of the freedom
of contract in modern liberal society."_ Thus it is possible to argue for a
_"civilised form of contractual slavery."_ ["J. Philmore,", **Op. Cit.**]

So accurate and logical was Ellerman's article that many of its readers were
convinced it **was** written by a right-libertarian (including, we have to
say, us!). One such writer was Carole Pateman, who correctly noted that
_"[t]here is a nice historical irony here. In the American South, slaves were
emancipated and turned into wage labourers, and now American contractarians
argue that all workers should have the opportunity to turn themselves into
civil slaves."_ [**Op. Cit.**, p. 63]).

The aim of Ellerman's article was to show the problems that employment (wage
labour) presents for the concept of self-government and how contract need not
result in social relationships based on freedom. As "Philmore" put it, _"[a]ny
thorough and decisive critique of voluntary slavery or constitutional
nondemocratic government would carry over to the employment contract -- which
is the voluntary contractual basis for the free-market free-enterprise system.
Such a critique would thus be a **reductio ad absurdum**."_ As _"contractual
slavery"_ is an _"extension of the employer-employee contract,"_ he shows that
the difference between wage labour and slavery is the time scale rather than
the principle or social relationships involved. [**Op. Cit.**] This explains,
firstly, the early workers' movement called capitalism _**"wage slavery"**_
(anarchists still do) and, secondly, why capitalists like Rothbard support the
concept but balk at the name. It exposes the unfree nature of the system they
support! While it is possible to present wage labour as "freedom" due to its
"consensual" nature, it becomes much harder to do so when talking about
slavery or dictatorship. Then the contradictions are exposed for all to see
and be horrified by.

All this does not mean that we must reject free agreement. Far from it! Free
agreement is **essential** for a society based upon individual dignity and
liberty. There are a variety of forms of free agreement and anarchists support
those based upon co-operation and self-management (i.e. individuals working
together as equals). Anarchists desire to create relationships which reflect
(and so express) the liberty that is the basis of free agreement. Capitalism
creates relationships that deny liberty. The opposition between autonomy and
subjection can only be maintained by modifying or rejecting contract theory,
something that capitalism cannot do and so the right-wing Libertarian rejects
autonomy in favour of subjection (and so rejects socialism in favour of
capitalism).

The real contrast between anarchism and right-Libertarianism is best expressed
in their respective opinions on slavery. Anarchism is based upon the
individual whose individuality depends upon the maintenance of free
relationships with other individuals. If individuals deny their capacities for
self-government from themselves through a contract the individuals bring about
a qualitative change in their relationship to others - freedom is turned into
mastery and subordination. For the anarchist, slavery is thus the paradigm of
what freedom is **not**, instead of an exemplification of what it is (as
right-Libertarians state). As Proudhon argued:

> _"If I were asked to answer the following question: What is slavery? and I
should answer in one word, It is murder, my meaning would be understood at
once. No extended argument would be required to show that the power to take
from a man his thought, his will, his personality, is a power of life and
death; and that to enslave a man is to kill him."_ [**What is Property?**, p.
37]

In contrast, the right-Libertarian effectively argues that "I support slavery
because I believe in liberty." It is a sad reflection of the ethical and
intellectual bankruptcy of our society that such an "argument" is actually
taken seriously by (some) people. The concept of "slavery as freedom" is far
too Orwellian to warrant a critique - we will leave it up to right
Libertarians to corrupt our language and ethical standards with an attempt to
prove it.

From the basic insight that slavery is the opposite of freedom, the anarchist
rejection of authoritarian social relations quickly follows (the right-wing
Libertarians fear):

> _"Liberty is inviolable. I can neither sell nor alienate my liberty; every
contract, every condition of a contract, which has in view the alienation or
suspension of liberty, is null: the slave, when he plants his foot upon the
soil of liberty, at that moment becomes a free man. . . Liberty is the
original condition of man; to renounce liberty is to renounce the nature of
man: after that, how could we perform the acts of man?"_ [P.J. Proudhon, **Op.
Cit.**, p. 67]

The employment contract (i.e. wage slavery) abrogates liberty. It is based
upon inequality of power and _"exploitation is a consequence of the fact that
the sale of labour power entails the worker's subordination."_ [Carole
Pateman, **Op. Cit.**, P. 149] Hence Proudhon's (and Mill's) support of self-
management and opposition to capitalism - any relationship that resembles
slavery is illegitimate and no contract that creates a relationship of
subordination is valid. Thus in a truly anarchistic society, slave contracts
would be unenforceable -- people in a truly free (i.e. non-capitalist) society
would **never** tolerate such a horrible institution or consider it a valid
agreement. If someone was silly enough to sign such a contract, they would
simply have to say they now rejected it in order to be free -- such contracts
are made to be broken and without the force of a law system (and private
defence firms) to back it up, such contracts will stay broken.

The right-Libertarian support for slave contracts (and wage slavery) indicates
that their ideology has little to do with liberty and far more to do with
justifying property and the oppression and exploitation it produces. Their
support and theoretical support for slavery indicates a deeper
authoritarianism which negates their claims to be libertarians.

## 2.7 But surely abolishing capitalism would restrict liberty?

Many "anarcho"-capitalists and other supporters of capitalism argue that it
would be "authoritarian" to restrict the number of alternatives that people
can choose between by abolishing capitalism. If workers become wage labourers,
so it is argued, it is because they "value" other things more -- otherwise
they would not agree to the exchange. But such an argument ignores that
reality of capitalism.

By **maintaining** capitalist private property, the options available to
people **are** restricted. In a fully developed capitalist economy the vast
majority have the "option" of selling their labour or starving/living in
poverty -- self-employed workers account for less than 10% of the working
population. Usually, workers are at a disadvantage on the labour market due to
the existence of unemployment and so accept wage labour because otherwise they
would starve (see [ section 10.2](append1310.html#secf102) for a discussion on
why this is the case). And as we argue in sections
[J.5.11](secJ5.html#secj511) and [J.5.12](secJ5.html#secj512), even **if** the
majority of the working population desired co-operative workplaces, a
capitalist market will not provide them with that outcome due to the nature of
the capitalist workplace (also see Juliet C. Schor's excellent book **The
Overworked American** for a discussion of why workers desire for more free
time is not reflected in the labour market). In other words, it is a myth to
claim that wage labour exists or that workplaces are hierarchical because
workers value other things -- they are hierarchical because bosses have more
clout on the market than workers and, to use Schor's expression, workers end
up wanting what they get rather than getting what they want.

Looking at the reality of capitalism we find that because of inequality in
resources (protected by the full might of the legal system, we should note)
those with property get to govern those without it during working hours (and
beyond in many cases). If the supporters of capitalism were actually concerned
about liberty (as opposed to property) that situation would be abhorrent to
them -- after all, individuals can no longer exercise their ability to make
decisions, choices, and are reduced to being order takers. If choice and
liberty are the things we value, then the ability to make choices in all
aspects of life automatically follows (including during work hours). However,
the authoritarian relationships and the continual violation of autonomy wage
labour implies are irrelevant to "anarcho"-capitalists (indeed, attempts to
change this situation are denounced as violations of the autonomy of the
property owner!). By purely concentrating on the moment that a contract is
signed they blind themselves to the restricts of liberty that wage contracts
create.

Of course, anarchists have no desire to **ban** wage labour -- we aim to
create a society within which people are not forced by circumstances to sell
their liberty to others. In order to do this, anarchists propose a
modification of property and property rights to ensure true freedom of choice
(a freedom of choice denied to us by capitalism). As we have noted many times,
"bilateral exchanges" can and do adversely effect the position of third
parties if they result in the build-up of power/money in the hands of a few.
And one of these adverse effects can be the restriction of workers options due
to economic power. Therefore it is the supporter of capitalist who restricts
options by supporting an economic system and rights framework that by their
very workings reduce the options available to the majority, who then are "free
to choose" between those that remain (see also [section B.4](secB4.html)).
Anarchists, in contrast, desire to expand the available options by abolishing
capitalist private property rights and removing inequalities in wealth and
power that help restrict our options and liberties artificially.

So does an anarchist society have much to fear from the spread of wage labour
within it? Probably not. If we look at societies such as the early United
States or the beginnings of the Industrial Revolution in Britain, for example,
we find that, given the choice, most people preferred to work for themselves.
Capitalists found it hard to find enough workers to employ and the amount of
wages that had to be offered to hire workers were so high as to destroy any
profit margins. Moreover, the mobility of workers and their "laziness" was
frequently commented upon, with employers despairing at the fact workers would
just work enough to make end meet and then disappear. Thus, left to the
actions of the "free market," it is doubtful that wage labour would have
spread. But it was not left to the "free market".

In response to these "problems", the capitalists turned to the state and
enforced various restrictions on society (the most important being the land,
tariff and money monopolies -- see sections [B.3](secB3.html) and
[8](append138.html)). In free competition between artisan and wage labour,
wage labour only succeeded due to the use of state action to create the
required circumstances to discipline the labour force and to accumulate enough
capital to give capitalists an edge over artisan production (see [section
8](append138.html) for more details).

Thus an anarchist society would not have to fear the spreading of wage labour
within it. This is simply because would-be capitalists (like those in the
early United States) would have to offer such excellent conditions, workers'
control and high wages as to make the possibility of extensive profits from
workers' labour nearly impossible. Without the state to support them, they
will not be able to accumulate enough capital to give them an advantage within
a free society. Moreover, it is somewhat ironic to hear capitalists talking
about anarchism denying choice when we oppose wage labour considering the fact
workers were not given any choice when the capitalists used the state to
develop wage labour in the first place!

## 2.8 Why should we reject the "anarcho"-capitalist definitions of freedom
and justice?

Simply because they lead to the creation of authoritarian social relationships
and so to restrictions on liberty. A political theory which, when consistently
followed, has evil or iniquitous consequences, is a bad theory.

For example, any theory that can justify slavery is obviously a bad theory -
slavery does not cease to stink the moment it is seen to follow your theory.
As right-Libertarians can justify slave contracts as a type of wage labour
(see [section 2.6](append132.html#secf26)) as well as numerous other
authoritarian social relationships, it is obviously a bad theory.

It is worth quoting Noam Chomsky at length on this subject:

> _"Consider, for example, the 'entitlement theory of justice'. . .
[a]ccording to this theory, a person has a right to whatever he has acquired
by means that are just. If, by luck or labour or ingenuity, a person acquires
such and such, then he is entitled to keep it and dispose of it as he wills,
and a just society will not infringe on this right. _

>

> _"One can easily determine where such a principle might lead. It is entirely
possible that by legitimate means - say, luck supplemented by contractual
arrangements 'freely undertaken' under pressure of need - one person might
gain control of the necessities of life. Others are then free to sell
themselves to this person as slaves, if he is willing to accept them.
Otherwise, they are free to perish. Without extra question-begging conditions,
the society is just. _

>

> _"The argument has all the merits of a proof that 2 + 2 = 5. . . Suppose
that some concept of a 'just society' is advanced that fails to characterise
the situation just described as unjust. . . Then one of two conclusions is in
order. We may conclude that the concept is simply unimportant and of no
interest as a guide to thought or action, since it fails to apply properly
even in such an elementary case as this. Or we may conclude that the concept
advanced is to be dismissed in that it fails to correspond to the
pretheorectical notion that it intends to capture in clear cases. If our
intuitive concept of justice is clear enough to rule social arrangements of
the sort described as grossly unjust, then the sole interest of a
demonstration that this outcome might be 'just' under a given 'theory of
justice' lies in the inference by **reductio ad absurdum** to the conclusion
that the theory is hopelessly inadequate. While it may capture some partial
intuition regarding justice, it evidently neglects others. _

>

> _"The real question to be raised about theories that fail so completely to
capture the concept of justice in its significant and intuitive sense is why
they arouse such interest. Why are they not simply dismissed out of hand on
the grounds of this failure, which is striking in clear cases? Perhaps the
answer is, in part, the one given by Edward Greenberg in a discussion of some
recent work on the entitlement theory of justice. After reviewing empirical
and conceptual shortcomings, he observes that such work 'plays an important
function in the process of . . . 'blaming the victim,' and of protecting
property against egalitarian onslaughts by various non-propertied groups.' An
ideological defence of privileges, exploitation, and private power will be
welcomed, regardless of its merits. _

>

> _"These matters are of no small importance to poor and oppressed people here
and elsewhere."_ [**The Chomsky Reader**, pp. 187-188]

It may be argued that the reductions in liberty associated with capitalism is
not really an iniquitous outcome, but such an argument is hardly fitting for a
theory proclaiming itself "libertarian." And the results of these
authoritarian social relationships? To quote Adam Smith, under the capitalist
division of labour the worker _"has no occasion to exert his understanding, or
exercise his invention"_ and _"he naturally loses, therefore, the habit of
such exercise and generally becomes as stupid and ignorant as it is possible
for a human creature to become."_ The worker's mind falls _"into that drowsy
stupidity, which, in a civilised society, seems to benumb the understanding of
almost all of the inferior [sic!] ranks of people."_ [cited by Chomsky, **Op.
Cit.**, p. 186]

Of course, it may be argued that these evil effects of capitalist authority
relations on individuals are also not iniquitous (or that the very real
domination of workers by bosses is not really domination) but that suggests a
desire to sacrifice real individuals, their hopes and dreams and lives to an
abstract concept of liberty, the accumulative effect of which would be to
impoverish all our lives. The kind of relationships we create **within** the
organisations we join are of as great an importance as their voluntary nature.
Social relations **shape** the individual in many ways, restricting their
freedom, their perceptions of what freedom is and what their interests
actually are. This means that, in order not to be farcical, any relationships
we create must reflect in their internal workings the critical evaluation and
self-government that created them in the first place. Sadly capitalist
individualism masks structures of power and relations of domination and
subordination within seemingly "voluntary" associations -- it fails to note
the relations of domination resulting from private property and so _"what has
been called 'individualism' up to now has been only a foolish egoism which
belittles the individual. Foolish because it was not individualism at all. It
did not lead to what was established as a goal; that is the complete, broad,
and most perfectly attainable development of individuality."_ [Peter
Kropotkin, **Selected Writings**, p. 297]

This right-Libertarian lack of concern for concrete individual freedom and
individuality is a reflection of their support for "free markets" (or
"economic liberty" as they sometimes phrase it). However, as Max Stirner
noted, this fails to understand that _"[p]olitical liberty means that the
**polis,** the State, is free; . . . not, therefore, that I am free of the
State. . . It does not mean **my** liberty, but the liberty of a power that
rules and subjugates me; it means that one of my **despots** . . . is free."_
[**The Ego and Its Own**, p. 107] Thus the desire for "free markets" results
in a blindness that while the market may be "free" the individuals within it
may not be (as Stirner was well aware, _"[u]nder the **regime** of the
commonality the labourers always fall into the hands of the possessors . . .
of the capitalists, therefore."_ [**Op. Cit.**, p. 115])

In other words, right-libertarians give the greatest importance to an abstract
concept of freedom and fail to take into account the fact that real, concrete
freedom is the outcome of self-managed activity, solidarity and voluntary co-
operation. For liberty to be real it must exist in all aspects of our daily
life and cannot be contracted away without seriously effecting our minds,
bodies and lives. Thus, the right-Libertarian's _"defence of freedom is
undermined by their insistence on the concept of negative liberty, which all
too easily translates in experience as the negation of liberty."_ [Stephan L.
Newman, **Liberalism as Wit's End**, p. 161]

Thus right-Libertarian's fundamental fallacy is that "contract" does not
result in the end of power or domination (particularly when the bargaining
power or wealth of the would-be contractors is not equal). As Carole Pateman
notes, _"[i]ronically, the contractarian ideal cannot encompass capitalist
employment. Employment is not a continual series of discrete contracts between
employer and worker, but . . . one contract in which a worker binds himself to
enter an enterprise and follow the directions of the employer for the duration
of the contract. As Huw Benyon has bluntly stated, 'workers are paid to
obey.'"_ [**The Sexual Contract**, p. 148] This means that _"the employment
contract (like the marriage contract) is not an exchange; both contracts
create social relations that endure over time - social relations of
subordination."_ [**Ibid.**]

Authority impoverishes us all and must, therefore, be combated wherever it
appears. That is why anarchists oppose capitalism, so that there shall be _"no
more government of man by man, by means of accumulation of capital."_ [P-J
Proudhon, cited by Woodcock in **Anarchism**, p. 110] If, as Murray Bookchin
point it, _"the object of anarchism is to increase choice"_ [**The Ecology of
Freedom**, p. 70] then this applies both to when we are creating
associations/relationships with others and when we are **within** these
associations/relationships -- i.e. that they are consistent with the liberty
of all, and that implies participation and self-management **not** hierarchy.
"Anarcho"-capitalism fails to understand this essential point and by
concentrating purely on the first condition for liberty ensures a society
based upon domination, oppression and hierarchy and not freedom.

It is unsurprising, therefore, to find that the basic unit of analysis of the
"anarcho"-capitalist/right-libertarian is the transaction (the "trade," the
"contract"). The freedom of the individual is seen as revolving around an act,
the contract, and **not** in our relations with others. All the social facts
and mechanisms that precede, surround and result from the transaction are
omitted. In particular, the social relations that result from the transaction
are ignored (those, and the circumstances that make people contract, are the
two unmentionables of right-libertarianism).

For anarchists it seems strange to concentrate on the moment that a contract
is signed and ignore the far longer time the contract is active for (as we
noted in [ section A.2.14](secA2.html#seca214), if the worker is free when
they sign a contract, slavery soon overtakes them). Yes, the voluntary nature
of a decision is important, but so are the social relationships we experience
due to those decisions.

For the anarchist, freedom is based upon the insight that other people, apart
from (indeed, **because** of) having their own intrinsic value, also are
"means to my end", that it is through their freedom that I gain my own -- so
enriching my life. As Bakunin put it:

> _"I who want to be free cannot be because all the men around me do not yet
want to be free, and consequently they become tools of oppression against
me."_ [quoted by Errico Malatesta in **Anarchy**, p. 27]

Therefore anarchists argue that we must reject the right-Libertarian theories
of freedom and justice because they end up supporting the denial of liberty as
the expression of liberty. What this fails to recognise is that freedom is a
product of social life and that (in Bakunin's words) _"[n]o man can achieve
his own emancipation without at the same time working for the emancipation of
all men around him. My freedom is the freedom of all since I am not truly free
in thought and in fact, except when my freedom and my rights are confirmed and
approved in the freedom and rights of all men who are my equals."_ [**Ibid.**]

Other people give us the possibilities to develop our full human potentiality
and thereby our freedom, so when we destroy the freedom of others we limit our
own. _"To treat others and oneself as property,"_ argues anarchist L. Susan
Brown, _"objectifies the human individual, denies the unity of subject and
object and is a negation of individual will . . . even the freedom gained by
the other is compromised by this relationship, for to negate the will of
another to achieve one's own freedom destroys the very freedom one sought in
the first place."_ [**The Politics of Individualism**, p. 3]

Fundamentally, it is for this reason that anarchists reject the right-
Libertarian theories of freedom and justice -- it just does not ensure
individual freedom or individuality.

[‹ 1 Are "anarcho"-capitalists really anarchists?](/afaq/append131.html "Go to
previous page" ) [up](/afaq/append13.html "Go to parent page" ) [3 Why do
anarcho"-capitalists place little or no value on "equality"?
›](/afaq/append133.html "Go to next page" )

