/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-project-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-project-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_project_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-project-manager-quark");
	}
	
	return quark;
}

/**
* ianjuta_project_manager_add_group:
* @obj: Self
* @group_name_to_add: fixme
* @default_location_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
gchar*
ianjuta_project_manager_add_group (IAnjutaProjectManager *obj, const gchar *group_name_to_add, const gchar *default_location_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	g_return_val_if_fail (group_name_to_add != NULL, NULL);
	g_return_val_if_fail (default_location_uri != NULL, NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->add_group (obj, group_name_to_add, default_location_uri, err);
}

/**
* ianjuta_project_manager_add_source:
* @obj: Self
* @source_uri_to_add: fixme
* @default_location_uri: fixme
* @err: Error propagation and reporting.
*
* Prompt the user to add a file to the project. If the user selects multiple files only
* the first uri is returned.
*
* Returns: element URIs. Must be freed when no longer required.
*/
char*
ianjuta_project_manager_add_source (IAnjutaProjectManager *obj, const gchar *source_uri_to_add, const gchar *default_location_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	g_return_val_if_fail (source_uri_to_add != NULL, NULL);
	g_return_val_if_fail (default_location_uri != NULL, NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->add_source (obj, source_uri_to_add, default_location_uri, err);
}

/**
* ianjuta_project_manager_add_source_multi:
* @obj: Self
* @source_uris_to_add: fixme
* @default_location_uri: fixme
* @err: Error propagation and reporting.
*
* Prompt the user to add a file to the project. If the user selects multiple files only
* the first uri is returned.
*
* Returns: element URIs. Must be freed when no longer required.
*/
GSList*
ianjuta_project_manager_add_source_multi (IAnjutaProjectManager *obj, GSList *source_uri_to_add, const gchar *default_location_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	g_return_val_if_fail (default_location_uri != NULL, NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->add_source_multi (obj, source_uri_to_add, default_location_uri, err);
}

/**
* ianjuta_project_manager_add_target:
* @obj: Self
* @target_name_to_add: fixme
* @default_location_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns:
*/
gchar*
ianjuta_project_manager_add_target (IAnjutaProjectManager *obj, const gchar *target_name_to_add, const gchar *default_location_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	g_return_val_if_fail (target_name_to_add != NULL, NULL);
	g_return_val_if_fail (default_location_uri != NULL, NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->add_target (obj, target_name_to_add, default_location_uri, err);
}

/**
* ianjuta_project_manager_get_children:
* @obj: Self
* @element_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
GList*
ianjuta_project_manager_get_children (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	g_return_val_if_fail (element_uri != NULL, NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_children (obj, element_uri, err);
}

/**
* ianjuta_project_manager_get_element_type:
* @obj: Self
* @element_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
IAnjutaProjectManagerElementType
ianjuta_project_manager_get_element_type (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), 0);
	g_return_val_if_fail (element_uri != NULL, 0);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_element_type (obj, element_uri, err);
}

/**
* ianjuta_project_manager_get_elements:
* @obj: Self
* @element_type: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
GList*
ianjuta_project_manager_get_elements (IAnjutaProjectManager *obj, IAnjutaProjectManagerElementType element_type, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_elements (obj, element_type, err);
}

/**
* ianjuta_project_manager_get_parent:
* @obj: Self
* @element_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gchar*
ianjuta_project_manager_get_parent (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	g_return_val_if_fail (element_uri != NULL, NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_parent (obj, element_uri, err);
}

/**
* ianjuta_project_manager_get_selected:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
gchar*
ianjuta_project_manager_get_selected (IAnjutaProjectManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_selected (obj, err);
}

/**
* ianjuta_project_manager_get_target_type:
* @obj: Self
* @target_uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
IAnjutaProjectManagerTargetType
ianjuta_project_manager_get_target_type (IAnjutaProjectManager *obj, const gchar *target_uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), 0);
	g_return_val_if_fail (target_uri != NULL, 0);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_target_type (obj, target_uri, err);
}

/**
* ianjuta_project_manager_get_targets:
* @obj: Self
* @target_type: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
GList*
ianjuta_project_manager_get_targets (IAnjutaProjectManager *obj, IAnjutaProjectManagerTargetType target_type, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), NULL);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->get_targets (obj, target_type, err);
}

/**
* ianjuta_project_manager_is_open:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/ 
gboolean
ianjuta_project_manager_is_open (IAnjutaProjectManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_MANAGER(obj), FALSE);
	return IANJUTA_PROJECT_MANAGER_GET_IFACE (obj)->is_open (obj, err);
}

static void
ianjuta_project_manager_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("element-added",
			IANJUTA_TYPE_PROJECT_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaProjectManagerIface, element_added),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);

		/* Signal */
		g_signal_new ("element-removed",
			IANJUTA_TYPE_PROJECT_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaProjectManagerIface, element_removed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);

		/* Signal */
		g_signal_new ("element-selected",
			IANJUTA_TYPE_PROJECT_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaProjectManagerIface, element_selected),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);


		initialized = TRUE;
	}
}

GType
ianjuta_project_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaProjectManagerIface),
			ianjuta_project_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaProjectManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_project_manager_elementtype_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_PROJECT_MANAGER_UNKNOWN, "IANJUTA_PROJECT_MANAGER_UNKNOWN", "unknown" }, 
		{ IANJUTA_PROJECT_MANAGER_SOURCE, "IANJUTA_PROJECT_MANAGER_SOURCE", "source" }, 
		{ IANJUTA_PROJECT_MANAGER_TARGET, "IANJUTA_PROJECT_MANAGER_TARGET", "target" }, 
		{ IANJUTA_PROJECT_MANAGER_GROUP, "IANJUTA_PROJECT_MANAGER_GROUP", "group" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaProjectManagerElementType", values);
	}

	return type;
}

GType
ianjuta_project_manager_targettype_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_PROJECT_MANAGER_TARGET_UNKNOWN, "IANJUTA_PROJECT_MANAGER_TARGET_UNKNOWN", "target-unknown" }, 
		{ IANJUTA_PROJECT_MANAGER_TARGET_SHAREDLIB, "IANJUTA_PROJECT_MANAGER_TARGET_SHAREDLIB", "target-sharedlib" }, 
		{ IANJUTA_PROJECT_MANAGER_TARGET_STATICLIB, "IANJUTA_PROJECT_MANAGER_TARGET_STATICLIB", "target-staticlib" }, 
		{ IANJUTA_PROJECT_MANAGER_TARGET_EXECUTABLE, "IANJUTA_PROJECT_MANAGER_TARGET_EXECUTABLE", "target-executable" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaProjectManagerTargetType", values);
	}

	return type;
}
