/*
 *  Copyright (C) 2005 Massimo Cora'
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef __CLASS_GEN_CALLBACKS__
#define __CLASS_GEN_CALLBACKS__


#include <gtk/gtk.h>
#include <glib.h>
#include "plugin.h"

typedef struct _ClassGenData
{
	GladeXML* gxml;
	AnjutaClassGenPlugin* plugin;
} ClassGenData;

void on_classgen_new (AnjutaClassGenPlugin* plugin);
void on_cc_button_browse_header_clicked (GtkButton *button, GladeXML* gxml);
void on_cc_button_browse_source_clicked (GtkButton *button, GladeXML* gxml);
void on_go_button_browse_header_clicked (GtkButton *button, GladeXML* gxml);
void on_go_button_browse_source_clicked (GtkButton *button, GladeXML* gxml);
void on_create_button_clicked (GtkButton *button, ClassGenData* data);
void on_cancel_button_clicked (GtkButton *button, ClassGenData *data);
gboolean on_class_gen_key_press_event(GtkWidget *widget, GdkEventKey *event,
                                           ClassGenData *data);
void on_inline_toggled (GtkToggleButton *buttom, ClassGenData *data);

#endif
