/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-folds.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor-folds
 * @title: IAnjutaEditorFolds
 * @short_description: Text editor folds inteface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-folds.h
 * 
 */

#include "ianjuta-editor-folds.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_folds_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-folds-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_view_close_folds:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Close all folds
 *
 */
void
ianjuta_editor_folds_close_all (IAnjutaEditorFolds *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_FOLDS(obj));
	IANJUTA_EDITOR_FOLDS_GET_IFACE (obj)->close_all (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_folds_close_all_default (IAnjutaEditorFolds *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_view_open_folds:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Open all folds
 *
 */
void
ianjuta_editor_folds_open_all (IAnjutaEditorFolds *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_FOLDS(obj));
	IANJUTA_EDITOR_FOLDS_GET_IFACE (obj)->open_all (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_folds_open_all_default (IAnjutaEditorFolds *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_view_toggle_fold:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Open/Close current fold
 *
 */
void
ianjuta_editor_folds_toggle_current (IAnjutaEditorFolds *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_FOLDS(obj));
	IANJUTA_EDITOR_FOLDS_GET_IFACE (obj)->toggle_current (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_folds_toggle_current_default (IAnjutaEditorFolds *obj, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_editor_folds_base_init (IAnjutaEditorFoldsIface* klass)
{
	static gboolean initialized = FALSE;

	klass->close_all = ianjuta_editor_folds_close_all_default;
	klass->open_all = ianjuta_editor_folds_open_all_default;
	klass->toggle_current = ianjuta_editor_folds_toggle_current_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_editor_folds_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorFoldsIface),
			(GBaseInitFunc) ianjuta_editor_folds_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorFolds", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
