// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "asciireport.h"

asciiReport::asciiReport() :
		strPrefix( "ascii" ),
		strName( "Ascii Report" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "Create output in plain ascii text." ),
		ScreenWidth( 79 )  // default value.
{
	addParam( "width", "Set a new screen width for the ascii output.", "Integer between 79 and 500.", Parameter::STRING, "79" );
}

void asciiReport::startNewReport( const std::string &title, const reportType_e reportType )
{
	// check the screenwidth.
	ScreenWidth = getIntParam( "width" );
	if( ScreenWidth < 79 || ScreenWidth > 500 ) ScreenWidth = 79;
	// Now a call to the Report function:
	Report::startNewReport( title, reportType );
}

void asciiReport::printHeader( void )
{
	if( col_list.size() == 0 ) return ; // Fehler.
	( *os ) << std::endl;
	printSpace( ( ScreenWidth - Title.size() ) / 2 );
	( *os ) << Title.substr( 0, ScreenWidth ).c_str() << std::endl;
	printLine( '=' );

	if( Type == TABLE )
	{
		// Evt. nicht aufgelste Spaltenbreiten (-1) auflsen.
		std::list< col_t >::iterator i;
		int width = 0;
		int cols = 0; // Anzahl der betroffenen Spalten.
		for( i = col_list.begin(); i != col_list.end(); i++ )
		{
			if ( ( *i ).Size > 0 ) width += ( ( *i ).Size + 1 ); else cols++;
		};
		if( cols > 0 )  // Falls berhaupt betroffene Spalten vorhanden.
		{
			width = ( ScreenWidth - width ) + 1; // Rest berechnen.
			int colwidth = 1; // Minimalbreite;
			int colrest = 0; // Rest zum verteilen.
			if( width > 0 )  // Positiver wert?
			{
				colwidth = width / cols; // durch anzahl spalten teilen.
				colrest = width % cols; // Restbetrag.
				if( colwidth < 1 )
				{
					colwidth = 1; // Minimalbreite
					colrest = 0;
				};
			}
			for( i = col_list.begin(); i != col_list.end(); i++ )  // Verteilen.
			{
				if( ( *i ).Size < 1 ) ( *i ).Size = colwidth - 1 + ( colrest-- > 0 ? 1 : 0 );
			}
		}
		bool f = false;
		for( i = col_list.begin(); i != col_list.end(); i++ )
		{
			// Summen lschen.
			( *i ).floatSum = 0.0;
			( *i ).longSum = 0;
			if( f ) printSpace();
			( *os ).width( ( *i ).Size );
			switch( ( *i ).Align )
			{
				case LEFT: ( *os ).setf( std::ios::left, std::ios::adjustfield ); break;
				case RIGHT: ( *os ).setf( std::ios::right, std::ios::adjustfield ); break;
			};
			( *os ) << ( *i ).Title.substr( 0, ( *i ).Size ).c_str();
			f = true;
		}
		( *os ) << std::endl;
		f = false;
		for( i = col_list.begin(); i != col_list.end(); i++ )
		{
			if ( f ) printSpace();
			printLine( '-', ( *i ).Size );
			f = true;
		}
		( *os ) << std::endl;

		// Zeiger auf erste Spalte.
		ci = col_list.begin();
		// Liniencounter ruecksetzen.
		lc = 1;

	};

}

void asciiReport::printField( const std::string &field )
{
	int subwidth = 0;

	if( col_list.size() == 0 ) return ; // Fehler.
	checkAutoField();
	if( ( *ci ).Typ == PERCENT ) subwidth++;
	switch( ( *ci ).Style )
	{
		default:
		case NONE:
			break;
		case ROUND:
			subwidth += 2;
			( *os ).put( '(' );
			break;
		case RECT:
			subwidth += 2;
			( *os ).put( '[' );
			break;
		case QUOTE:
			subwidth += 2;
			( *os ).put( '"' );
			break;
	};
	if( field.length() > static_cast<std::string::size_type>( ( *ci ).Size - subwidth ) ) subwidth++; // Platz fr kennzeichnung...
	( *os ).width( ( *ci ).Size - subwidth );
	switch( ( *ci ).Align )
	{
		default:
		case LEFT:
			( *os ).setf( std::ios::left, std::ios::adjustfield );
			break;
		case RIGHT:
			( *os ).setf( std::ios::right, std::ios::adjustfield );
			break;
	};
	( *os ) << field.substr( 0, ( *ci ).Size - subwidth ).c_str();
	if( field.length() > static_cast<std::string::size_type>( ( *ci ).Size - subwidth ) ) ( *os ).put( '#' );
	if( ( *ci ).Typ == PERCENT ) ( *os ).put( '%' );
	switch ( ( *ci ).Style )
	{
		default:
		case NONE:
			break;
		case ROUND:
			( *os ).put( ')' );
			break;
		case RECT:
			( *os ).put( ']' );
			break;
		case QUOTE:
			( *os ).put( '"' );
			break;
	};
	if( !nextField() ) printSpace();
}

void asciiReport::printField( const long field )
{
	int subwidth = 0;

	if( col_list.size() == 0 ) return ; // Fehler.
	checkAutoField();
	if( ( *ci ).Typ == PERCENT ) subwidth++;
	switch ( ( *ci ).Style )
	{
		default:
		case NONE:
			( *os ).width( ( *ci ).Size - subwidth );
			break;
		case ROUND:
			subwidth += 2;
			( *os ).width( ( *ci ).Size - subwidth );
			( *os ).put( '(' );
			break;
		case RECT:
			subwidth += 2;
			( *os ).width( ( *ci ).Size - subwidth );
			( *os ).put( '[' );
			break;
		case QUOTE:
			subwidth += 2;
			( *os ).width( ( *ci ).Size - subwidth );
			( *os ).put( '"' );
			break;
	};
	switch ( ( *ci ).Align )
	{
		default:
		case LEFT:
			( *os ).setf( std::ios::left, std::ios::adjustfield );
			break;
		case RIGHT:
			( *os ).setf( std::ios::right, std::ios::adjustfield );
			break;
	};
	if ( ( *ci ).Typ == DATE )
	{
		( *os ) << getDateStr( field );
	}
	else
	{
		( *os ) << field;
	};
	if ( ( *ci ).Typ == PERCENT ) ( *os ).put( '%' );
	switch ( ( *ci ).Style )
	{
		default:
		case NONE:
			break;
		case ROUND:
			( *os ).put( ')' );
			break;
		case RECT:
			( *os ).put( ']' );
			break;
		case QUOTE:
			( *os ).put( '"' );
			break;
	};
	// Testen, ob Summe
	if( ( *ci ).Sum ) ( *ci ).longSum += field;
	if( !nextField() ) printSpace();
}

void asciiReport::printField( const double field )
{
	int subwidth = 0;

	if( col_list.size() == 0 ) return ; // Fehler.
	checkAutoField();
	if( ( *ci ).Typ == PERCENT ) subwidth++;
	( *os ).precision( 1 ); // Nachkommastellen.
	( *os ).setf( std::ios::fixed );
	switch( ( *ci ).Style )
	{
		default:
		case NONE:
			( *os ).width( ( *ci ).Size - subwidth );
			break;
		case ROUND:
			subwidth += 2;
			( *os ).width( ( *ci ).Size - subwidth );
			( *os ).put( '(' );
			break;
		case RECT:
			subwidth += 2;
			( *os ).width( ( *ci ).Size - subwidth );
			( *os ).put( '[' );
			break;
		case QUOTE:
			subwidth += 2;
			( *os ).width( ( *ci ).Size - subwidth );
			( *os ).put( '"' );
			break;
	};
	switch( ( *ci ).Align )
	{
		default:
		case LEFT:
			( *os ).setf( std::ios::left, std::ios::adjustfield );
			break;
		case RIGHT:
			( *os ).setf( std::ios::right, std::ios::adjustfield );
			break;
	};
	( *os ) << field;
	if( ( *ci ).Typ == PERCENT ) ( *os ).put( '%' );
	switch( ( *ci ).Style )
	{
		default:
		case NONE:
			break;
		case ROUND:
			( *os ).put( ')' );
			break;
		case RECT:
			( *os ).put( ']' );
			break;
		case QUOTE:
			( *os ).put( '"' );
			break;
	};
	// Testen, ob Summe
	if( ( *ci ).Sum ) ( *ci ).floatSum += field;
	if( !nextField() ) printSpace();
}

void asciiReport::skipField( const bool realline )
{
	if( col_list.size() == 0 ) return ; // Fehler.
	if( realline ) checkAutoField();
	printSpace( ( *ci ).Size );
	if( !nextField() ) printSpace(); else lc--; // Line wieder zuruecksetzen.
}

void asciiReport::printFooter( void )
{
	bool sf = false; // Summe bilden?

	if( Type == TABLE )
	{
		if( col_list.size() == 0 ) return ; // Fehler.
		bool f = false;
		for( ci = col_list.begin(); ci != col_list.end(); ci++ )
		{
			if( f ) printSpace();
			if( ( *ci ).Sum )
			{
				printLine( '+' , ( *ci ).Size );
				sf = true;
			}
			else
			{
				printLine( '-' , ( *ci ).Size );
			};
			f = true;
		}
		( *os ) << std::endl;
		if( sf )
		{
			ci = col_list.begin();
			do
			{
				if( ( *ci ).Sum )
				{
					switch ( ( *ci ).Typ )
					{
						case FLOAT:
							printField( ( *ci ).floatSum );
							break;
						case INTEGER:
							printField( ( *ci ).longSum );
							break;
						default:
							skipField( false );
					}
				}
				else
				{
					skipField( false );
				}
			}
			while( ci != col_list.begin() );
			f = false;
			for( ci = col_list.begin(); ci != col_list.end(); ci++ )
			{
				if ( f ) printSpace();
				if ( ( *ci ).Sum )
				{
					printLine( '=' , ( *ci ).Size );
				}
				else
				{
					printSpace( ( *ci ).Size );
				};
				f = true;
			}
			( *os ) << std::endl;
		}
		( *os ) << std::endl;
	}
}

/** Gibt width anzahl spaces aus. */
void asciiReport::printSpace( const int width )
{
	int i;
	for( i = 0; i < width; i++ ) ( *os ).put( ' ' );
}

/** Zeichnet eine Linie ber die gesammte Breite mit zeichen ch. */
void asciiReport::printLine( const char ch, const int size )
{
	int i;
	for( i = 0; i < ( size == -1 ? ScreenWidth : size ) ; i++ ) ( *os ).put( ch );
	if( size == -1 ) ( *os ) << std::endl;
}

/** Erzeugt ggf. alle Automatischen Felder. */
void asciiReport::checkAutoField( void )
{
	while( true )
	{
		if( ( *ci ).Typ == COUNTER )
		{
			( *os ).width( ( *ci ).Size );
			( *os ).setf( std::ios::right, std::ios::adjustfield );
			( *os ) << lc;
			if( nextField() )
			{
				return ;
			}
			else
			{
				printSpace();
			}
		}
		else
		{
			return ;
		}
	}
}

/** Springt zum nchsten feld und mach ggf. einen Zeilenumbruch. */
bool asciiReport::nextField( void )
{
	if( ++ci == col_list.end() )
	{
		( *os ) << std::endl;
		ci = col_list.begin();
		lc++; // Linecounter.
		return true;
	}
	else
	{
		return false;
	}
}
