// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef POSTFIXFILTER_H
#define POSTFIXFILTER_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>
#include <string>
#include <map>
#include "filter.h"

/** This filter try to read the default postfux format.
  *@short Syslog filter.
  *@author Tobias Erbsland
  */
class postfixFilter : public Filter
{

private:

	const char * const strPrefix;
	const char * const strName;
	const char * const strVersion;
	const char * const strAuthor;
	const char * const strHelp;

	const char * const intern_mail_suffix;

	struct logline_t
	{
		time_t time;
		std::string host;
		std::string command;
		long pid;
		std::string message;
	};

	class endOfLog { };

	int intYear; // Store current Year.

	int readTwoChars( std::istream &streamin );
	logline_t getLogLine( std::istream &streamin );
	void postfix( const time_t time, const std::string &line );
	std::string translate( const std::string &email );

public:

	postfixFilter();

	virtual const char * Prefix( void ) const { return strPrefix; };
	virtual const char * Name( void ) const { return strName; };
	virtual const char * Version( void ) const { return strVersion; };
	virtual const char * Author( void ) const { return strAuthor; };
	virtual const char * Help( void ) const { return strHelp; };

	virtual bool run( void );

	virtual ~postfixFilter() { };
};

#endif
