/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**  Antenna Visualization Toolkit                                          **/
/**                                                                         **/
/**  Adrian Agogino  agogino@ece.utexas.edu                                 **/
/**  Ken Harker      kharker@cs.utexas.edu                                  **/
/**                                                                         **/
/**  May 1998                                                               **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


#ifndef PARSEARGS_H
#define PARSEARGS_H

#include <tk.h>
#include <GL/gl.h>
#include "MyTypes.h"


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                               Definitions                               **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


#define PA_CHANGED 7


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                               Data Types                                **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


enum PA_Type {PA_END, PA_FLOAT, PA_BOOL, PA_INT, PA_RGB};

struct PA_Config {
  enum PA_Type  type;    /**  Type for parsing  **/
  char         *name;    /**  Name              **/
  int           offset;  /**  An offset         **/
};


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                            Function Prototypes                          **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


extern GLint PA_ParseArgs(Tcl_Interp  *interp, 
                               GLint   argc, 
                                char **argv,
                    struct PA_Config  *cfg, 
                                void  *data);


#endif


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                             End of ParseArgs.h                          **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


