/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __MYSQLRESULTROW_HPP
#define __MYSQLRESULTROW_HPP

#include "include.hpp"
#include <mysql/mysql.h>
#include "resultRow.hpp"

/** @addtogroup mysqlCpp
    @{ */
/** Class for accessing a single row of an SQL-query's result.
    @date Thu Mar 03 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class MySQLResultRow: public ResultRow
{
public:
  /** Constructor requiring a handle to a result-row.
      Use \c MySQLStatement::fetchRow instead of this constructor. */
  MySQLResultRow( MYSQL_ROW _result );
  /// Destructor.
  /** Operator for retrieving columns.
      @param i Number of column (starting from <TT>0</TT>).
      @see MySQLStatement::getNumCols */
  virtual std::string operator[]( int i ) throw (Error);
  /** Invalidate the row.
      This method is called by the destructor of \c MySQLStatement to prevent
      the \c MySQLResultRow object from using invalidated data. */
  virtual void invalidate(void) { result = NULL; }
protected:
  ///
  MYSQL_ROW result;
};

///
typedef boost::shared_ptr< MySQLResultRow > MySQLResultRowPtr;

///@}

#endif
