/* Copyright (C) 2002, 2003, 2004, 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __XMLDOCUMENT_HPP
#define __XMLDOCUMENT_HPP

// #define SIMPLEXPATH

#include "include.hpp"
#include <string>
#include <XalanDOM/XalanDocument.hpp>
#include <XalanDOM/XalanElement.hpp>
#include <XalanSourceTree/XalanSourceTreeDOMSupport.hpp>
#include <XalanSourceTree/XalanSourceTreeParserLiaison.hpp>
#ifndef SIMPLEXPATH
#include <XPath/XPathEnvSupportDefault.hpp>
#include <XPath/XObjectFactoryDefault.hpp>
// With which version was this introduced exactly?
#if _XALAN_VERSION >= 10500
#include <XPath/XPathConstructionContextDefault.hpp>
#endif
#include <XPath/XPathFactoryDefault.hpp>
#include <XPath/XPathExecutionContextDefault.hpp>
#endif
#include <util/XMLException.hpp>
#include "error.hpp"
#include "object.hpp"
#include "xmlErrorHandler.hpp"
#include "xmlReference.hpp"

#ifdef XERCES_HAS_CPP_NAMESPACE
using namespace XERCES_CPP_NAMESPACE;
#endif
#ifdef XALAN_HAS_CPP_NAMESPACE
using namespace XALAN_CPP_NAMESPACE;
#endif

/** @defgroup XMLCpp XML C++ Wrappers
    The XML C++ wrappers are offering a higher-level interface to the Xalan-
    and Xerces-XML API.
    @{ */
/** Class for parsing XML documents.
    Don't forget to add the following initialization code to your main
    application, before using this class:
    \verbatim
    XMLPlatformUtils::Initialize();
    XPathInit oTheXPathInit;
    \endverbatim
    After using this class, execute the following code:
    \verbatim
    XMLPlatformUtils::Terminate();
    \endverbatim
    See Apache Xerces and Xalan documentation for more details.
    @date Thu Mar 10 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class XMLDocument: public Object
{
public:
  /** Constructor.
      Create empty XML-document and configure verification.
      @param schemaURI (Namespace-URI and) XSD-filename of XML schema. Specify
      "", if you don't want verification. */
  XMLDocument( const std::string &schemaURI );
  ///
  void load( const std::string &fileName ) throw (Error);
  ///
  void save( const std::string &fileName ) throw (Error);
  ///
  void fromString( const std::string &string ) throw (Error);
  ///
  void fromInputSource( InputSource &inputSource ) throw (Error);
  ///
  const XalanDocument *getDocument(void) const
  { return document; }
  ///
  XMLReference< XalanElement > getDocumentElement(void)
  { return XMLReference< XalanElement >
      ( document->getDocumentElement(), this ); }
#ifndef SIMPLEXPATH
  ///
  XalanSourceTreeDOMSupport *getDOMSupport(void)
  { return &theDOMSupport; }
  ///
  XPathEnvSupportDefault *getEnvSupport(void) { return &theEnvSupport; }
#if _XALAN_VERSION >= 10500
  ///
  XPathConstructionContextDefault *getXPathConstructionContext(void)
  { return &theXPathConstructionContext; }
#endif
  ///
  XPathFactoryDefault *getXPathFactory(void) { return &theXPathFactory; }
  ///
  XPathExecutionContextDefault *getExecutionContext(void)
  { return &theExecutionContext; }
#endif
protected:
  /** @name Xalan classes for parsing and maintaining the XML DOM */
  //@{
  ///
  XalanSourceTreeDOMSupport theDOMSupport;
  ///
  XalanSourceTreeParserLiaison theLiaison;
  //@}
  /// Error handler for catching parse errors.
  XMLErrorHandler xmlErrorHandler;
  /// The XML DOM.
  const XalanDocument *document;
  /** @name Xalan classes for making XPath queries */
  ///@{
#ifdef SIMPLEXPATH
#else
  ///
  XPathEnvSupportDefault theEnvSupport;
  ///
  XObjectFactoryDefault theXObjectFactory;
  // With which version was this introduced exactly?
#if _XALAN_VERSION >= 10500
  ///
  XPathConstructionContextDefault theXPathConstructionContext;
#endif
  ///
  XPathFactoryDefault theXPathFactory;
  ///
  XPathExecutionContextDefault theExecutionContext;
#endif
  ///@}
};

///@}

#endif
