%define name anyremote
%define version 4.2

Summary: Remote control through bluetooth or IR connection.
Name: %{name}
Version: %{version}
Release: 1%{?dist}
License: GPLv2+
Group: Applications/Telephony
Source0: %{name}-%{version}.tar.gz
Requires: bluez-libs, libXtst, anyremote-doc >= %{version},anyremote-data >= %{version}
BuildRequires: bluez-libs-devel, xorg-x11-proto-devel
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

%description
The overall goal of this project is to provide remote control service on Linux 
through Bluetooth, InfraRed, Wi-Fi or TCP/IP connection.

anyRemote supports wide range of modern cell phones like Nokia, SonyEricsson, 
Motorola and others. 

anyRemote was developed as thin "communication" layer between Buetooth (IR, Wi-Fi)-capabled phone 
and Linux, and in could be configured to manage almost any software. 

%prep
%setup -q

%build
./configure --prefix=%{_prefix}
make %{?_smp_mflags} CFLAGS="$RPM_OPT_FLAGS"
strip src/%{name}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files 
%defattr(-,root,root)
%{_bindir}/%{name}
%{_datadir}/*/*/%{name}.1.gz

%changelog
* Fri Jan 10 2007 Mikhail Fedotov <anyremote at mail.ru> - 4.2
- Spec file modified.

%package data
Summary: Configuration files for anyRemote
Group: Applications/Telephony

%description data
Configuration files for anyRemote

%files data
%defattr(-,root,root)
%{_datadir}/%{name}/cfg-data/*
%{_datadir}/%{name}/anyRemote.jad 
%{_datadir}/%{name}/anyRemote.jar
%{_datadir}/%{name}/anyRemote-64.jad 
%{_datadir}/%{name}/anyRemote-64.jar

%package doc
Summary: Documentation for anyRemote
Group: Applications/Telephony

%description doc
Documentation for anyRemote

%files doc
%defattr(-,root,root)
%{_datadir}/%{name}/README 
%{_datadir}/%{name}/COPYING
%{_datadir}/%{name}/NEWS
%{_datadir}/%{name}/doc-html/*
