//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006-2011 Mikhail Fedotov <anyremote@mail.ru>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
//

//#define USE_XTEST
 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>


#ifdef USE_XTEST
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>
#include <X11/XF86keysym.h>
#endif

// some of X11/XF86keysym.h does not contains this key
#ifndef XF86XK_AudioForward
#define XF86XK_AudioForward   0x1008FF97
#endif

#ifndef XF86XK_MonBrightnessUp
#define XF86XK_MonBrightnessUp   0x1008FF02
#endif

#ifndef XF86XK_MonBrightnessDown
#define XF86XK_MonBrightnessDown 0x1008FF03
#endif

#include "common.h"
#include "utils.h"

extern char tmp[MAXMAXLEN];

#ifdef USE_XTEST
static Display* disp = NULL;
#endif

void freeDisplay()
{
	#ifdef USE_XTEST
	if (disp) {
		XCloseDisplay(disp);
		disp = NULL;
	}
	#endif
}

#ifdef USE_XTEST
static void mouseClick(int button)
{
	XTestFakeButtonEvent(disp, button, True, CurrentTime);
        XTestFakeButtonEvent(disp, button, False, CurrentTime);
}

static void mouseDoubleClick()
{
	mouseClick(1);
        usleep(1000);
        mouseClick(1);
}

static KeyCode keysymStr2keycode(Display* disp, const char* keysymStr)
{
	KeySym ks = XStringToKeysym(keysymStr);
        if(ks == NoSymbol) {
	
		if(strcmp("AudioForward",keysymStr) == 0)        	{ ks = XF86XK_AudioForward; }
		else if (strcmp("AudioLowerVolume",keysymStr) == 0)  	{ ks = XF86XK_AudioLowerVolume; }
		else if(strcmp("AudioMute",keysymStr) == 0)	      	{ ks = XF86XK_AudioMute; }
		else if(strcmp("AudioNext",keysymStr) == 0)	      	{ ks = XF86XK_AudioNext; }
		else if(strcmp("AudioPause",keysymStr) == 0)	      	{ ks = XF86XK_AudioPause; }
		else if(strcmp("AudioPlay",keysymStr) == 0)	      	{ ks = XF86XK_AudioPlay; }
		else if(strcmp("AudioPrev",keysymStr) == 0)	      	{ ks = XF86XK_AudioPrev; }
		else if(strcmp("AudioRaiseVolume",keysymStr) == 0)	{ ks = XF86XK_AudioRaiseVolume; }
		else if(strcmp("AudioRewind",keysymStr) == 0)	      	{ ks = XF86XK_AudioRewind; }
		else if(strcmp("Back",keysymStr) == 0)   		{ ks = XF86XK_Back; }	
		else if(strcmp("Close",keysymStr) == 0)   		{ ks = XF86XK_Close; }	
		else if(strcmp("Eject",keysymStr) == 0)   		{ ks = XF86XK_Eject; }	
		else if(strcmp("Forward",keysymStr) == 0)   		{ ks = XF86XK_Forward; } 
		else if(strcmp("MonBrightnessDown",keysymStr) == 0)   	{ ks = XF86XK_MonBrightnessDown; }
		else if(strcmp("MonBrightnessUp",keysymStr) == 0)     	{ ks = XF86XK_MonBrightnessUp; }
		else if(strcmp("PowerOff",keysymStr) == 0)   		{ ks = XF86XK_PowerOff; }
		else if(strcmp("WakeUp",keysymStr) == 0)   		{ ks = XF86XK_WakeUp; } 
		else {	
	        	DEBUG2("couldn't map keysymbol %s", keysymStr);
                	ks = XStringToKeysym("space");
		}
        }
        KeyCode kk = XKeysymToKeycode(disp, ks);
	if (kk == 0) {
		kk = XKeysymToKeycode(disp,XStringToKeysym("space"));
	}
	return kk;
}

#endif

// Input can be something like:
// key,a,key,by_value,40,keyup,b,keydown,c,mouse,1,mouseup,1,mousedown,1,mousemove,100,100,mousermove,10,10,mousedblclick,sleep,1000
//
int emulateCommands(char* cmdString) 
{
	#ifdef USE_XTEST

	if (disp == NULL) {
        	disp = XOpenDisplay(NULL);
        }
        if (disp == NULL) {
		return EXIT_NOK;
	}        

	char * cmd = strdup(cmdString);
       
        KeyCode fakeKey;
	
        char* token = strtok(cmd,",");
        while (token) {
        
        	if (strcmp(token,"keyup") == 0) {
                	char * key = strtok(NULL,",");
                        if (key) {
				if (strcmp(key,"by_value") == 0) {
				        char * keyval = strtok(NULL,",");
					if (keyval) {
						fakeKey = XKeysymToKeycode(disp,strtol(keyval, (char**) NULL, 0));
						if (fakeKey == 0) {
							logger("DBG", "emulateCommands: improper keyup value");
							continue;
						}
					} else {
					 	logger("DBG", "emulateCommands: keyup value absent");
						continue;
					}
				} else{
					fakeKey = keysymStr2keycode(disp,key);
				}
				XTestFakeKeyEvent(disp, fakeKey, False, CurrentTime);
                        } else {
                        	logger("DBG", "emulateCommands: improper keyup");
                        }
                } else if (strcmp(token,"keydown") == 0) {
                	char * key = strtok(NULL,",");
                        if (key) {
				if (strcmp(key,"by_value") == 0) {
				        char * keyval = strtok(NULL,",");
					if (keyval) {
						fakeKey = XKeysymToKeycode(disp,strtol(keyval, (char**) NULL, 0));
						if (fakeKey == 0) {
							logger("DBG", "emulateCommands: improper keydown value");
							continue;
						}
					} else {
					 	logger("DBG", "emulateCommands: keydown value absent");
						continue;
					}
				} else{
					fakeKey = keysymStr2keycode(disp,key);
				}
				XTestFakeKeyEvent(disp, fakeKey, True, CurrentTime );
                        } else {
                        	logger("DBG", "emulateCommands: improper keydown");
                        }
                
                } else if (strcmp(token,"key") == 0) {
                	char * key = strtok(NULL,",");
                        if (key) {
				if (strcmp(key,"by_value") == 0) {
				        char * keyval = strtok(NULL,",");
					if (keyval) {
					        //printf("Emulate key %s\n",keyval);
						fakeKey = XKeysymToKeycode(disp,strtol(keyval, (char**) NULL, 0));
						if (fakeKey == 0) {
							logger("DBG", "emulateCommands: improper key value");
							continue;
						}
					} else {
					 	logger("DBG", "emulateCommands: key value absent");
						continue;
					}
				} else{
					fakeKey = keysymStr2keycode(disp,key);
				}
                        	//printf("Emulate key dec=%d hex=0x%x\n",fakeKey,fakeKey);
        			XTestFakeKeyEvent(disp, fakeKey, True, CurrentTime);
        			XTestFakeKeyEvent(disp, fakeKey, False, CurrentTime);
                        } else {
                        	logger("DBG", "emulateCommands: improper key");
                        }
                
                } else if (strcmp(token,"mousemove") == 0) {
                	char * x = strtok(NULL,",");
                	char * y = (x ? strtok(NULL,",") : NULL);
                        if (x && y) {
				XTestFakeMotionEvent(disp, -1, atoi(x), atoi(y), CurrentTime );
                        } else {
                        	logger("DBG", "emulateCommands: improper mousemove");
                        }
                
                } else if (strcmp(token,"mousermove") == 0) {
                	char * x = strtok(NULL,",");
                	char * y = (x ? strtok(NULL,",") : NULL);
                        if (x && y) {
				XTestFakeRelativeMotionEvent(disp,atoi(x), atoi(y), CurrentTime );
                        } else {
                        	logger("DBG", "emulateCommands: improper mousermove");
                        }
                
                } else if (strcmp(token,"mousedblclick") == 0) {
                
                	mouseDoubleClick();
                        
                } else if (strcmp(token,"mouseup") == 0) {
        		char * x = strtok(NULL,",");
                        if (x) {
				XTestFakeButtonEvent(disp, atoi(x), False, CurrentTime);
                        } else {
                        	logger("DBG", "emulateCommands: improper mouseup");
                        }

                } else if (strcmp(token,"mousedown") == 0) {
        		char * x = strtok(NULL,",");
                        if (x) {
				XTestFakeButtonEvent(disp, atoi(x), True, CurrentTime);
                        } else {
                        	logger("DBG", "emulateCommands: improper mousedown");
                        }

                } else if (strcmp(token,"mouse") == 0) {
        		char * x = strtok(NULL,",");
                        if (x) {
                        	mouseClick(atoi(x));
                        } else {
                        	logger("DBG", "emulateCommands: improper mouse");
                        }

                } else if (strcmp(token,"sleep") == 0) {
                
        		char * x = strtok(NULL,",");
                        if (x) {
                        	usleep(atoi(x));
                        } else {
                        	logger("DBG", "emulateCommands: improper sleep");
                        }

        	} else {
                	logger("DBG", "emulateCommands: unknown operation");
                }
                token = strtok(NULL,",");
		
		XFlush(disp);
        }
        XFlush(disp);
	
        free(cmd);
	#endif
        
        return EXIT_OK;
}
