/* class to encapsulate set of functions to manage a circular array;
 * recent hit information is stored in the looping array; each hit
 * has information written into the next slot of structs. If
 * we reach the end, start over. Then the top-URL/IP is summed up from
 * this information. The bigger the table, the more hits you'll have
 * to summarise from.
*/

#include "apachetop.h"

int Hits_Circle::create(unsigned int passed_size)
{
	size = passed_size;
	pos = 0;
	walkpos = 0;

	tab = (struct circle_struct *)
	    calloc(size, sizeof(struct circle_struct));
	if (!tab)
	{
		abort();
	}

	reqcount = bytecount = 0;
	memset(rc_summary, (char) NULL, sizeof(rc_summary));

	return 0;
}

#if 0
/*we don't need to resize anymore*/
int Hits_Circle::resize(int newsize)
{
	int x, y;
	extern map *u; /* global */
	extern map *i; /* global */
	extern config cf; /* global */

	/* make the circle bigger */
	tab = (struct circle_struct *)
	    realloc(tab, newsize * sizeof(struct circle_struct));
	if (!tab)
		abort();
	
	/* zero the new area */
	for (x = pos ; x < newsize ; ++x)
	{
		tab[x].retcode = 0;
		tab[x].time = 0;
		tab[x].bytes = 0;
	}

	/* refresh urlmap and ip map */
	map *nu; /* new, temporary urlmap */
	nu = new map;
	nu->create(newsize);

	/* populate it */
	for (x = 0 ; x < pos ; ++x)
	{
		/* We get the char *url from the old urlmap
		 * (u->reverse()) which still exists */

		/* is this url already in the new urlmap? */
		if ((y = nu->lookup(u->reverse(tab[x].url_pos))) == -1)
		{
			/* url_pos will change */
			tab[x].url_pos = nu->insert(u->reverse(tab[x].url_pos));
		}
		else
		{
			/* url is alerady in, give this
			 * circle the existing url_pos */
			tab[x].url_pos = y;
		}
	}

	u->destroy(); /* get rid of the old, small urlmap */
	delete u;
	u = nu; /* point old u at new urlmap */


	map *ni; /* new, temporary ip map */
	ni = new map;
	ni->create(newsize);

	/* populate it */
	for (x = 0 ; x < pos ; ++x)
	{
		/* We get the char *url from the old ip map 
		 * (i->reverse()) which still exists */

		/* is this url already in the new urlmap? */
		if ((y = ni->lookup(i->reverse(tab[x].ip_pos))) == -1)
		{
			/* url_pos will change */
			tab[x].ip_pos = ni->insert(i->reverse(tab[x].ip_pos));
		}
		else
		{
			/* url is alerady in, give this
			 * circle the existing url_pos */
			tab[x].ip_pos = y;
		}
	}

	i->destroy(); /* get rid of the old, small urlmap */
	delete i;
	i = ni; /* point old u at new urlmap */

	cf.circle_size = newsize; /* tell config we're bigger */
	size = newsize; /* circle object internal size */

	return 0;
}
#endif

int Hits_Circle::insert(struct logbits lb)
{
	struct circle_struct *posptr;
	short rc_tmp_old, rc_tmp_new;

	/* insert the given data into the current position,
	 * and update pos to point at next position */
	posptr = &tab[pos];

	/* if this is a new insert, increment our count */
	if (posptr->time == 0)
		++reqcount;
	
	/* maintain some stats */
	/* bytecount; remove the previous one and add the new one */
	bytecount -= posptr->bytes;
	bytecount += lb.bytes;
	/* retcodes, remember how many we have of each */
	rc_tmp_old = (int)posptr->retcode/100;
	rc_tmp_new = (int)lb.retcode/100;
	if (rc_tmp_old != rc_tmp_new)
	{
		--rc_summary[rc_tmp_old];
		++rc_summary[rc_tmp_new];
	}

	/* store the data */
	memcpy(posptr, &lb, sizeof(lb));

	++pos;

	/* see if we're running out of space. We'd like to keep however many
	 * hits of data the user has asked for; if we're not managing
	 * that, increase */
	if (pos == size)
	{
		/* loop round */
		pos = 0;
	}

	return 0;
}

//int Hits_Circle::walk(unsigned int *url_pos, unsigned int *ip_pos,
//    int *bytes, time_t *time, unsigned int *ipl, unsigned int *retcode)
int Hits_Circle::walk(struct logbits **lb)
{
	/* return each value in the circle one by one, starting at 0 and
	 * working up; return 0 when there are more to go, or -1 when we're
	 * done */

	*lb = NULL;

	if (walkpos == size || tab[walkpos].time == 0)
	{
		walkpos = 0;
		return -1;
	}

	*lb = &tab[walkpos];

	++walkpos;
	return 0;
}

time_t Hits_Circle::oldest(void)
{
	int tmp;

	/* return the first entry we have. normally this will be pos+1, but
	 * cater for circumstances where it is isn't; ie we're initially
	 * filling up the array (use 0), or we're at position size (use 0) */
	if (pos == size)
		tmp = 0; /* earliest will be 0 */
	else
		tmp = pos + 1; /* earliest is next element */

	if (tab[tmp].time > 0)
		return tab[tmp].time;

	return tab[0].time;
}

