/** 
 * <center>
 * @mainpage APBS Programmers Guide
 *  
 * APBS was written by Nathan A. Baker.<br>
 * Additional contributing authors listed in the code documentation.
 * </center>
 * 
 * <hr width="100%">
 * @section toc   Table of Contents
 * <ul> 
 *   <li> @ref style
 *   <li> @ref api
 *     <ul>
 *       <li> <a href="modules.html">Modules</a>
 *       <li> <a href="annotated.html">Class list</a>
 *       <li> <a href="functions.html">Class members</a>
 *       <li> <a href="globals.html">Class methods</a>
 *    </ul>
 * </ul>
 * 
 * <hr width="100%">
 * @section license License
 *
 * APBS -- Adaptive Poisson-Boltzmann Solver
 * <br><br>
 * Nathan A. Baker (baker@biochem.wustl.edu) <br>
 * Dept. of Biochemistry and Molecular Biophysics <br>
 * Center for Computational Biology <br>
 * Washington University in St. Louis <br>
 * <br><br>
 * Additional contributing authors listed in the code documentation.
 * <br><br>
 * Copyright (c) 2002-2007.  Washington University in St. Louis.<br>
 * All Rights Reserved.<br>
 * Portions Copyright (c) 1999-2002.  The Regents of the University of
 * California.  <br>
 * Portions Copyright (c) 1995.  Michael Holst.<br>
 * <p>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the <a href="http://www.gnu.org/licenses/gpl.txt">GNU
 * General Public License</a> as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 * Linking APBS statically or dynamically with other modules is making a
 * combined work based on APBS. Thus, the terms and conditions of the GNU
 * General Public License cover the whole combination.
 * 
 * SPECIAL GPL EXCEPTION
 * In addition, as a special exception, the copyright holders of APBS
 * give you permission to combine the APBS program with free software
 * programs and libraries that are released under the GNU LGPL or with
 * code included in releases of ISIM, Ion Simulator Interface, PMV, PyMOL
 * SMOL, VMD, and Vision. Such combined software may be linked with APBS and 
 * redistributed together in original or modified form as mere aggregation
 * without requirement that the entire work be under the scope of the GNU 
 * General Public License. This special exception permission is also extended
 * to any software listed in the SPECIAL GPL EXCEPTION clauses by the PMG,
 * FEtk, MC, or MALOC libraries.
 * 
 * Note that people who make modified versions of APBS are not obligated
 * to grant this special exception for their modified versions; it is
 * their choice whether to do so. The GNU General Public License gives
 * permission to release a modified version without this exception; this
 * exception also makes it possible to release a modified version which
 * carries forward this exception.
 *
 * <hr>
 * <p>
 * This documentation provides information about the programming interface
 * provided by the APBS software and a general guide to linking to the APBS
 * libraries.  Information about installation, configuration, and general usage
 * can be found in the <a href="user.html">User's Guide</a>.
 * <hr>
 * 
 *  @section style Programming Style
 * 
 *  <p>
 *  APBS was developed following the <a
 *  href="http://scicomp.ucsd.edu/~mholst/codes/maloc/cleanc.html">Clean OO
 *  C</a> style of Mike Holst.  In short, Clean OO C code is written in a
 *  object-oriented, ISO C-compliant fashion, and can be compiled with either a
 *  C or C++ compiler.  <p> Following this formalism, all public data is
 *  enclosed in structures which resemble C++ classes.  These structures and
 *  member functions are then declared in a public header file which provides a
 *  concise description of the interface for the class.  Private functions and
 *  data are included in private header files (or simply the source code files
 *  themselves) which are not distributed.  When using the library, the
 *  end-user only sees the public header file and the compiled library and is
 *  therefore (hopefully) oblivious to the private members and functions.  Each
 *  class is also equipped with a constructor and destructor function which is
 *  responsible for allocating and freeing any memory required by the
 *  instatiated objects.
 * 
 *  <p>
 *  As mentioned above, public data members are enclosed in C structures which
 *  are visible to the end-user.  Public member functions are generated by
 *  mangling the class and function names <i>and</i> passing a pointer to the
 *  object on which the member function is supposed to act.  For example, a
 *  public member function with the C++ declaration 
 *    <pre>
 *   public double Foo::bar(int i, double d)
 *   </pre>
 * would be declared as
 *   <pre>
 *   VEXTERNC double Foo_bar(Foo *thee, int i, double d)
 *   </pre>
 * where <code>VEXTERNC</code> is a compiler-dependent macro, the underscore
 * <code>_</code> replaces the C++ double-colon <code>::</code>, and
 * <code>thee</code> replaces the <code>this</code> variable implicit in all
 * C++ classes.  Since they do not appear in public header files, private
 * functions could be declared in any format pleasing to the user, however, the
 * above declaration convention should generally be used for both public and
 * private functions.  Within the source code, the public and private function
 * declarations/definitions are prefaced by the macros <code>VPUBLIC</code> and
 * <code>VPRIVATE</code>, respectively.  These are macros which reduce global
 * name pollution, similar to encapsulating private data withing C++ classes.
 *  
 * <p>
 * The only C++ functions not explicitly covered by the above declaration
 * scheme are the constructors (used to allocate and initialize class data
 * members) and destructors (used to free allocated memory).  These are
 * declared in the following fashion:  a constructor with the C++ declaration
 *    <pre>
 *    public void Foo::Foo(int i, double d)
 *    </pre>
 * would be declared as
 *     <pre>
 *     VEXTERNC Foo* Foo_ctor(int i, double d)
 *     </pre>
 * which returns a pointer to the newly constructed <code>Foo</code> object.
 * Likewise, a destructor declared as
 *     <pre>
 *     public void Foo::~Foo()
 *     </pre>
 * in C++ would be
 *     <pre>
 *     VEXTERNC void Foo_dtor(Foo **thee)
 *     </pre>
 * in Clean OO C.
 * <p>
 * Finally, inline functions in C++ are simply treated as macros in Clean OO C
 * and declared/defined using <code>#define</code> statements in the public
 * header file.
 * <p>
 * See any of the APBS header files for more information on Clean OO C
 * programming styles.
 * 
 * @section api Application programming interface documentation
 * <p>
 * The API documentation for this code was generated by <a
 * href="http://www.doxygen.org">doxygen</a>.  You can either view the API
 * documentation by using the links at the top of this page, or the slight
 * re-worded/re-interpreted list below:
 *    <ul>
 *    <li> <a href="modules.html">Class overview</a>
 *    <li> <a href="annotated.html">Class declarations</a>
 *    <li> <a href="functions.html">Class members</a>
 *    <li> <a href="globals.html">Class methods</a>
 *    </ul>
 * 
 */
