/*
 * Copyright (C) 2005 Universitat d'Alacant / Universidad de Alicante
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef __TAGGER_
#define __TAGGER_

#include <cstdio>
#include <fstream>
#include <map>
#include <set>

#include <apertium/ConstantManager.H>
#include <apertium/TaggerData.H>
#include <apertium/TTag.H>

using namespace std;

/** PoS tagger working modes
 */
#define TRAIN_MODE             0  //Training  (unsupervised)
#define TRAIN_SUPERVISED_MODE  1  //Training (supervised)
#define RETRAIN_MODE       2      //Retrain  (unsupervised)
#define TAGGER_MODE        3      //Tag input text
#define TAGGER_EVAL_MODE   4      //Tag and evaluate taggnig output
#define TAGGER_FORHANDTAG_MODE 5  //Tag and perform output to be used by a hand-taggnig program
#define UNKNOWN_MODE       6      //Unknown mode

void help();
bool is_number(char *cad);
int input(int argc, char** argv, FILE **fdic, fstream& fprob, fstream& famb, 
	  FILE **fcrp, FILE **ftagged, FILE **funtagged, FILE **feval, 
	  int& nit, bool &debug);

void do_main (int argc, char *argv[], set<TTag> const &open_class,
             map<string, int> &tag_index, ConstantManager const &constants,
             vector<string> const &prefer_rules,
             vector<TForbidRule> const &forbid_rules,
             vector<TEnforceAfterRule> const &enforce_rules);

class Tagger
{
private:
  vector<string> filenames;
  int nit;
  string name;
  bool debug;

  int getMode(int argc, char *argv[]);
  void tagger();
  void train();
  void retrain();
  void trainSupervised();
  void help();
  void filerror(string const &filename);  
public:
  Tagger();
  void main(int argc, char *argv[]);
};

#endif
