/* io.cc

   written by Marc Singer
   22 Mar 2006

   Copyright (C) 2006 Marc Singer

   The software is free software can be used for any purpose you
   choose.  It comes with no guarantees or warranties whatsoever.

   -----------
   DESCRIPTION
   -----------

   Demonstration of performing physical memory IO using /dev/mem.

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/io.h>
#include <ctype.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>

#define DEVICE "/dev/mem"

// These addresses are relevent to the LPD7A40X.

#define BASE_ADDR	(0x507e0000)	// Base physical address for IO
//#define BASE_ADDR	(0xc0000000)
#define PAGE_SIZE	4096		// Underlying system page size
#define MMAP_SIZE	0xc000		// Size of memory region to mmap

#define READ_ADDR	(0x50720000)
#define READ_SIZE	256		// Size of memory region to read

typedef unsigned short u16;
typedef unsigned long u32;

void dumpw (const void* pv, int cb, unsigned long index, int width)
{
  const unsigned char* rgb = (const unsigned char*) pv;
  int i;

  while (cb > 0) {
    printf ("%08lx: ", index);
    for (i = 0; i < 16; ++i) {
      if (i < cb) {
	switch (width) {
	default:
	case 1:
	  printf ("%02x ", rgb[i]);
	  break;
	case 2:
	  printf ("%04x ", *((u16*)&rgb[i]));
	  ++i;
	  break;
	case 4:
	  printf ("%08x ", *((u32*)&rgb[i]));
	  i += 3;
	  break;
	}
      }
      else
	printf ("   ");
      if (i%8 == 7)
	putchar (' ');
    }
    for (i = 0; i < 16; ++i) {
      if (i == 8)
	putchar (' ');
      putchar ( (i < cb) ? (isprint (rgb[i]) ? rgb[i] : '.') : ' ');
    }
    printf ("\n");

    cb -= 16;
    index += 16;
    rgb += 16;
  }
}

int main (int argc, char** argv)
{
  const char* device = DEVICE;

  printf ("reading from %s\n", device);
  int fh = open (device, O_RDWR | O_SYNC);
  printf ("fh %d\n", fh);
  if (fh == -1) {
    printf ("unable to open %s\n", device);
    exit (1);
  }

  void* pv = mmap64 (NULL, MMAP_SIZE, PROT_READ | PROT_WRITE,
		     MAP_SHARED, fh, BASE_ADDR);

  dumpw ((const void*) pv, READ_SIZE, READ_ADDR - BASE_ADDR, 4);

  while (1) {

    printf ("Press a key and we'll send an 'A'");
    char ch = getchar ();

    unsigned long* pl = (unsigned long*) ((unsigned char*) pv
					  + (0x80000700 - BASE_ADDR));
    *pl = 'A';

    sleep (1);
  }


  exit (0);
}
