# 1 "src/drivers/drv-nor-cfi.c"
# 1 "/home/elf/z/apex//"
# 1 "<built-in>"
# 1 "<command line>"
# 1 "src/drivers/drv-nor-cfi.c"
# 58 "src/drivers/drv-nor-cfi.c"
# 1 "include/driver.h" 1
# 34 "include/driver.h"
# 1 "include/linux/types.h" 1




# 1 "include/linux/config.h" 1
# 6 "include/linux/types.h" 2







# 1 "include/linux/posix_types.h" 1



# 1 "include/linux/stddef.h" 1



# 1 "include/linux/compiler.h" 1
# 26 "include/linux/compiler.h"
# 1 "include/linux/compiler-gcc+.h" 1






# 1 "include/linux/compiler-gcc.h" 1
# 8 "include/linux/compiler-gcc+.h" 2
# 27 "include/linux/compiler.h" 2
# 5 "include/linux/stddef.h" 2
# 5 "include/linux/posix_types.h" 2
# 36 "include/linux/posix_types.h"
typedef struct {
 unsigned long fds_bits [(1024/(8 * sizeof(unsigned long)))];
} __kernel_fd_set;


typedef void (*__kernel_sighandler_t)(int);


typedef int __kernel_key_t;
typedef int __kernel_mqd_t;

# 1 "include/asm/posix_types.h" 1
# 22 "include/asm/posix_types.h"
typedef unsigned long __kernel_ino_t;
typedef unsigned short __kernel_mode_t;
typedef unsigned short __kernel_nlink_t;
typedef long __kernel_off_t;
typedef int __kernel_pid_t;
typedef unsigned short __kernel_ipc_pid_t;
typedef unsigned short __kernel_uid_t;
typedef unsigned short __kernel_gid_t;
typedef unsigned int __kernel_size_t;
typedef int __kernel_ssize_t;
typedef int __kernel_ptrdiff_t;
typedef long __kernel_time_t;
typedef long __kernel_suseconds_t;
typedef long __kernel_clock_t;
typedef int __kernel_timer_t;
typedef int __kernel_clockid_t;
typedef int __kernel_daddr_t;
typedef char * __kernel_caddr_t;
typedef unsigned short __kernel_uid16_t;
typedef unsigned short __kernel_gid16_t;
typedef unsigned int __kernel_uid32_t;
typedef unsigned int __kernel_gid32_t;

typedef unsigned short __kernel_old_uid_t;
typedef unsigned short __kernel_old_gid_t;
typedef unsigned short __kernel_old_dev_t;


typedef long long __kernel_loff_t;


typedef struct {

 int val[2];



} __kernel_fsid_t;
# 48 "include/linux/posix_types.h" 2
# 14 "include/linux/types.h" 2
# 1 "include/asm/types.h" 1





typedef unsigned short umode_t;






typedef __signed__ char __s8;
typedef unsigned char __u8;

typedef __signed__ short __s16;
typedef unsigned short __u16;

typedef __signed__ int __s32;
typedef unsigned int __u32;


typedef __signed__ long long __s64;
typedef unsigned long long __u64;
# 38 "include/asm/types.h"
typedef signed char s8;
typedef unsigned char u8;

typedef signed short s16;
typedef unsigned short u16;

typedef signed int s32;
typedef unsigned int u32;

typedef signed long long s64;
typedef unsigned long long u64;



typedef u32 dma_addr_t;
typedef u32 dma64_addr_t;

typedef unsigned int kmem_bufctl_t;
# 15 "include/linux/types.h" 2



typedef __u32 __kernel_dev_t;

typedef __kernel_fd_set fd_set;
typedef __kernel_dev_t dev_t;
typedef __kernel_ino_t ino_t;
typedef __kernel_mode_t mode_t;
typedef __kernel_nlink_t nlink_t;
typedef __kernel_off_t off_t;
typedef __kernel_pid_t pid_t;
typedef __kernel_daddr_t daddr_t;
typedef __kernel_key_t key_t;
typedef __kernel_suseconds_t suseconds_t;
typedef __kernel_timer_t timer_t;
typedef __kernel_clockid_t clockid_t;
typedef __kernel_mqd_t mqd_t;


typedef __kernel_uid32_t uid_t;
typedef __kernel_gid32_t gid_t;
typedef __kernel_uid16_t uid16_t;
typedef __kernel_gid16_t gid16_t;
# 55 "include/linux/types.h"
typedef __kernel_loff_t loff_t;
# 64 "include/linux/types.h"
typedef __kernel_size_t size_t;




typedef __kernel_ssize_t ssize_t;




typedef __kernel_ptrdiff_t ptrdiff_t;




typedef __kernel_time_t time_t;




typedef __kernel_clock_t clock_t;




typedef __kernel_caddr_t caddr_t;



typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned int u_int;
typedef unsigned long u_long;


typedef unsigned char unchar;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned long ulong;




typedef __u8 u_int8_t;
typedef __s8 int8_t;
typedef __u16 u_int16_t;
typedef __s16 int16_t;
typedef __u32 u_int32_t;
typedef __s32 int32_t;



typedef __u8 uint8_t;
typedef __u16 uint16_t;
typedef __u32 uint32_t;


typedef __u64 uint64_t;
typedef __u64 u_int64_t;
typedef __s64 int64_t;
# 132 "include/linux/types.h"
typedef unsigned long sector_t;
# 149 "include/linux/types.h"
typedef __u16 __le16;
typedef __u16 __be16;
typedef __u32 __le32;
typedef __u32 __be32;
typedef __u64 __le64;
typedef __u64 __be64;
# 163 "include/linux/types.h"
struct ustat {
 __kernel_daddr_t f_tfree;
 __kernel_ino_t f_tinode;
 char f_fname[6];
 char f_fpack[6];
};
# 35 "include/driver.h" 2
# 1 "include/attributes.h" 1
# 36 "include/driver.h" 2



struct driver_d;

struct descriptor_d {
  struct driver_d* driver;
  char driver_name[32];
  unsigned long start;
  unsigned long length;
  size_t index;
  size_t width;


  char rgb[256];
  char* pb[32];
  int c;
  int iRoot;

  unsigned long private;
};
# 95 "include/driver.h"
struct driver_d {
  const char* name;
  const char* description;
  unsigned long flags;
  void* priv;
  int (*open) (struct descriptor_d*);
  void (*close) (struct descriptor_d*);
  ssize_t (*read) (struct descriptor_d*, void* pv, size_t cb);
  ssize_t (*write) (struct descriptor_d*, const void* pv, size_t cb);
  ssize_t (*poll) (struct descriptor_d*, size_t cb);
  void (*erase) (struct descriptor_d*, size_t cb);
  size_t (*seek) (struct descriptor_d*, ssize_t cb, int whence);
  int (*info) (struct descriptor_d*);
};
# 123 "include/driver.h"
extern void close_helper (struct descriptor_d* d);
extern void close_descriptor (struct descriptor_d* d);
extern int is_descriptor_open (struct descriptor_d* d);
extern int open_descriptor (struct descriptor_d* d);
extern int parse_descriptor (const char* sz, struct descriptor_d* d);
extern size_t seek_helper (struct descriptor_d* d, ssize_t ib, int whence);
# 59 "src/drivers/drv-nor-cfi.c" 2
# 1 "include/service.h" 1
# 38 "include/service.h"
struct service_d {
  void (*init) (void);
  void (*report) (void);
  void (*release) (void);

};
# 59 "include/service.h"
extern void init_services (void);
extern void release_services (void);
# 60 "src/drivers/drv-nor-cfi.c" 2
# 1 "include/linux/string.h" 1
# 16 "include/linux/string.h"
extern char * strpbrk(const char *,const char *);
extern char * strsep(char **,const char *);
extern __kernel_size_t strspn(const char *,const char *);
extern __kernel_size_t strcspn(const char *,const char *);




# 1 "include/asm/string.h" 1
# 10 "include/asm/string.h"
extern char * strrchr(const char * s, int c);


extern char * strchr(const char * s, int c);


extern void * memcpy(void *, const void *, __kernel_size_t);


extern void * memmove(void *, const void *, __kernel_size_t);


extern void * memchr(const void *, int, __kernel_size_t);



extern void * memset(void *, int, __kernel_size_t);



extern void __memzero(void *ptr, __kernel_size_t n);
# 25 "include/linux/string.h" 2


extern char * strcpy(char *,const char *);


extern char * strncpy(char *,const char *, __kernel_size_t);


size_t strlcpy(char *, const char *, size_t);


extern char * strcat(char *, const char *);


extern char * strncat(char *, const char *, __kernel_size_t);


extern size_t strlcat(char *, const char *, __kernel_size_t);


extern int strcmp(const char *,const char *);


extern int strncmp(const char *,const char *,__kernel_size_t);


extern int strnicmp(const char *, const char *, __kernel_size_t);





extern char * strnchr(const char *, size_t, int);





extern char * strstr(const char *,const char *);


extern __kernel_size_t strlen(const char *);


extern __kernel_size_t strnlen(const char *,__kernel_size_t);
# 82 "include/linux/string.h"
extern void * memscan(void *,int,__kernel_size_t);


extern int memcmp(const void *,const void *,__kernel_size_t);
# 61 "src/drivers/drv-nor-cfi.c" 2
# 1 "include/apex.h" 1
# 34 "include/apex.h"
# 1 "/usr/lib/gcc/arm-linux-gnu/4.0.4/include/stdarg.h" 1 3 4
# 43 "/usr/lib/gcc/arm-linux-gnu/4.0.4/include/stdarg.h" 3 4
typedef __builtin_va_list __gnuc_va_list;
# 105 "/usr/lib/gcc/arm-linux-gnu/4.0.4/include/stdarg.h" 3 4
typedef __gnuc_va_list va_list;
# 35 "include/apex.h" 2

# 1 "include/config.h" 1



# 1 "include/linux/autoconf.h" 1
# 5 "include/config.h" 2
# 37 "include/apex.h" 2
# 60 "include/apex.h"
extern void init_drivers (void);
extern int __attribute__((format (printf, 1, 2)))
     printf (const char * fmt, ...);
extern int putchar (int ch);
extern int puts (const char * fmt);
extern int snprintf(char * buf, size_t size, const char * fmt, ...);
extern int sprintf(char * buf, const char * fmt, ...);
extern int read_command (const char* szPrompt,
    int* pargc, const char*** pargv);
extern int parse_command (char* rgb, int* pargc, const char*** pargv);
extern int vsnprintf(char *buf, size_t size, const char *fmt, va_list args);

extern void __attribute__((noreturn)) exec_monitor (void);

extern unsigned long timer_read (void);
extern unsigned long timer_delta (unsigned long, unsigned long);
extern void usleep (unsigned long);

static inline __attribute__((always_inline)) void msleep (int c) {
  while (c-- > 0) usleep (1000); }




extern void dumpw (const char* rgb, int cb,
     unsigned long index, int width);


void history_add (const char* sz);
int history_retrieve (int backward, char* rgb, size_t cbMax);
# 62 "src/drivers/drv-nor-cfi.c" 2

# 1 "include/spinner.h" 1
# 48 "include/spinner.h"
extern void (*hook_spinner) (unsigned value);

void spinner_step (void);
void spinner_clear (void);
# 64 "src/drivers/drv-nor-cfi.c" 2
# 1 "include/asm/reg.h" 1
# 45 "include/asm/reg.h"
typedef struct { volatile unsigned long offset[4096>>2]; } __reg32;
typedef struct { volatile unsigned short offset[4096>>1]; } __reg16;
typedef struct { volatile unsigned char offset[4096>>0]; } __reg08;
# 65 "src/drivers/drv-nor-cfi.c" 2
# 1 "include/error.h" 1
# 32 "include/error.h"
extern const char* error_description;
# 66 "src/drivers/drv-nor-cfi.c" 2

# 1 "include/mach/nor-cfi.h" 1
# 68 "src/drivers/drv-nor-cfi.c" 2
# 144 "src/drivers/drv-nor-cfi.c"
struct nor_region {
  int size;
  int count;
  unsigned long start;
  unsigned long next;
};



struct nor_chip {
  unsigned long total_size;
  int writebuffer_size;
  int regions;
  struct nor_region region[16];
};

const static struct nor_chip* chip;
static struct nor_chip chip_probed;

int endian_error;


static unsigned long phys_from_index (unsigned long index)
{




  return index + 0x50000000;

}

static void vpen_enable (void)
{



}

static void vpen_disable (void)
{



}

static unsigned long nor_read_one (unsigned long index)
{

  return ((__reg16*)(((index ^ (1<<1)))&~(4096-1)))->offset[(((index ^ (1<<1)))&(4096-1))>>1];



}


static void nor_write_one (unsigned long index, unsigned long v)
{

  ((__reg16*)(((index ^ (1<<1)))&~(4096-1)))->offset[(((index ^ (1<<1)))&(4096-1))>>1] = v;



}




static unsigned long nor_status (unsigned long index)
{
  unsigned long status;
  unsigned long time = timer_read ();
  do {
    status = nor_read_one (index);
  } while ( (status & ((1<<7))) != ((1<<7))
    && timer_delta (time, timer_read ()) < 6*1000);
  return status;
}
# 230 "src/drivers/drv-nor-cfi.c"
static const struct nor_region* nor_region (unsigned long index)
{
  int i;
  for (i = 0; i < chip->regions; ++i)
    if (index < chip->region[i].next)
      return &chip->region[i];
  return &chip->region[0];
}
# 250 "src/drivers/drv-nor-cfi.c"
static unsigned long nor_unlock_page (unsigned long index)
{
  index &= ~ (nor_region (index)->size - 1);

  nor_write_one ((index), ((0x90)));
  do {} while (0);

  if ((((__reg16*)(((index + (0x02 << (16>>4))))&~(4096-1)))->offset[(((index + (0x02 << (16>>4))))&(4096-1))>>1] & (0x1)) == 0)
    return ((1<<7));

  nor_write_one ((index), ((0x60)));
  nor_write_one ((index), ((0xd0)));
  return nor_status (index);
}

static void nor_init_chip (unsigned long phys)
{
  int iRegionFirst = chip_probed.regions;
  int i;
  unsigned long start;

  do {} while (0);


  ((__reg16*)(((phys))&~(4096-1)))->offset[(((phys))&(4096-1))>>1] = (0xff);
  ((__reg16*)(((phys + (0x55 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x55 << (16>>4))))&(4096-1))>>1] = (0x98);

  printf ("nor phys %p %x %x %x %x\n", (void*) phys,
   ((__reg16*)(((phys + (0x10 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x10 << (16>>4))))&(4096-1))>>1],
   ((__reg16*)(((phys + (0x11 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x11 << (16>>4))))&(4096-1))>>1],
   ((__reg16*)(((phys + (0x12 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x12 << (16>>4))))&(4096-1))>>1],
   ((__reg16*)(((phys + (0x13 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x13 << (16>>4))))&(4096-1))>>1]);


  if ( ((__reg16*)(((phys + (0x11 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x11 << (16>>4))))&(4096-1))>>1] == ('Q')
      || ((__reg16*)(((phys + (0x10 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x10 << (16>>4))))&(4096-1))>>1] == ('R')
      || ((__reg16*)(((phys + (0x13 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x13 << (16>>4))))&(4096-1))>>1] == ('Y')) {
    endian_error = 1;
    nor_write_one ((phys), ((0xff)));
    return;
  }


  if ( ((__reg16*)(((phys + (0x10 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x10 << (16>>4))))&(4096-1))>>1] != ('Q')
      || ((__reg16*)(((phys + (0x11 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x11 << (16>>4))))&(4096-1))>>1] != ('R')
      || ((__reg16*)(((phys + (0x12 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x12 << (16>>4))))&(4096-1))>>1] != ('Y')) {




    return;
  }






  start = chip_probed.total_size;
  i = chip_probed.regions;

  chip_probed.regions += ((__reg16*)(((phys + (0x2c << (16>>4))))&~(4096-1)))->offset[(((phys + (0x2c << (16>>4))))&(4096-1))>>1];
  chip_probed.total_size
    += (1<<((__reg16*)(((phys + (0x27 << (16>>4))))&~(4096-1)))->offset[(((phys + (0x27 << (16>>4))))&(4096-1))>>1])*(1);

  chip_probed.writebuffer_size
    = (1<<( ((__reg16*)(((phys + (0x2a << (16>>4))))&~(4096-1)))->offset[(((phys + (0x2a << (16>>4))))&(4096-1))>>1]
    | (((__reg16*)(((phys + (0x2b << (16>>4))))&~(4096-1)))->offset[(((phys + (0x2b << (16>>4))))&(4096-1))>>1] << 8)))
    *(1);




  for (; i < chip_probed.regions; ++i) {
    int offset = (i - iRegionFirst)*4;
    do {} while (0);
    chip_probed.region[i].size
      = 256*( ((__reg16*)(((phys + ((0x2f + offset) << (16>>4))))&~(4096-1)))->offset[(((phys + ((0x2f + offset) << (16>>4))))&(4096-1))>>1]
      | (((__reg16*)(((phys + ((0x30 + offset) << (16>>4))))&~(4096-1)))->offset[(((phys + ((0x30 + offset) << (16>>4))))&(4096-1))>>1] << 8))
      *(1);
    chip_probed.region[i].count
      = 1 + ( ((__reg16*)(((phys + ((0x2d + offset) << (16>>4))))&~(4096-1)))->offset[(((phys + ((0x2d + offset) << (16>>4))))&(4096-1))>>1]
      | (((__reg16*)(((phys + ((0x2e + offset) << (16>>4))))&~(4096-1)))->offset[(((phys + ((0x2e + offset) << (16>>4))))&(4096-1))>>1] << 8));
    do {} while (0);

    chip_probed.region[i].start = start;
    start += chip_probed.region[i].size*chip_probed.region[i].count;
    chip_probed.region[i].next = start;
  }
}

static void nor_init (void)
{
  do {} while (0);

  vpen_disable ();

  chip_probed.total_size = 0;
  chip_probed.regions = 0;

  nor_init_chip (0x50000000);




  if (!chip_probed.total_size)
    return;

  chip = &chip_probed;
# 434 "src/drivers/drv-nor-cfi.c"
  ((__reg16*)(((0x50000000))&~(4096-1)))->offset[(((0x50000000))&(4096-1))>>1] = (0x50);
}

static int nor_open (struct descriptor_d* d)
{
  if (!chip)
    return -1;



  return 0;
}

static ssize_t nor_read (struct descriptor_d* d, void* pv, size_t cb)
{
  ssize_t cbRead = 0;

  if (d->index + cb > d->length)
    cb = d->length - d->index;

  while (cb) {
    unsigned long index = d->start + d->index;
    int available = cb;
    if (index < chip->total_size && index + available > chip->total_size)
      available = chip->total_size - index;
    index = phys_from_index (index);

    d->index += available;
    cb -= available;
    cbRead += available;


    nor_write_one ((index), ((0xff)));
    memcpy (pv, (void*) index, available);

    pv += available;
  }

  return cbRead;
}
# 489 "src/drivers/drv-nor-cfi.c"
static ssize_t nor_write (struct descriptor_d* d, const void* pv, size_t cb)
{
  size_t cbWrote = 0;
  unsigned long pageLast = -1;

  if (!chip->writebuffer_size)
    ({ error_description = ("flash chip doesn't support buffered writes"); return ((-13)); });


  if (d->index + cb > d->length)
    cb = d->length - d->index;

  while (cb > 0) {
    unsigned long index = d->start + d->index;
    unsigned long page = index & ~ (nor_region (index)->size - 1);
    unsigned short status;
    int available
      = chip->writebuffer_size - (index & (chip->writebuffer_size - 1));

    if (available > cb)
      available = cb;

    index = phys_from_index (index);

    do {} while (0);

    vpen_enable ();

    if (page != pageLast) {
      status = nor_unlock_page (index);
      if (status & ((1<<4) | (1<<3) | (1<<1)))
 goto fail;
      pageLast = page;
    }





    nor_write_one ((index & ~(16/8 - 1)), (0xe8));

    status = nor_status (index & ~(16/8 - 1));
    if (!(status & (1<<7))) {
      do {} while (0);

      goto fail;
    }

    {
      int av = available + (index & (16/8 - 1));





      nor_write_one ((index & ~(16/8 - 1)), (av - av/2 - 1));



    }

    if (available == chip->writebuffer_size && ((unsigned long) pv & 1) == 0) {
      int i;
      for (i = 0; i < available; i += 2)



 nor_write_one ((index + i), (((unsigned short*)pv)[i/2]));

    }
    else {
      int i;
      char __attribute__((aligned (32))) rgb[chip->writebuffer_size];
      rgb[0] = 0xff;
      rgb[((available + (index & 1) + 1)&~1) - 1] = 0xff;

      memcpy (rgb + (index & (16/8 - 1)), pv, available);
      for (i = 0; i < available + (index & 1); i += 2)




 nor_write_one (((index & ~(16/8 - 1)) + i), (((unsigned short*)rgb)[i/2]));


    }




    nor_write_one ((index & ~(16/8 - 1)), (0xd0));

    spinner_step();
    status = nor_status (index);

    vpen_disable ();

    spinner_step();

    if (status & ((1<<4) | (1<<3) | (1<<1))) {
    fail:
      printf ("Program failed at 0x%p (%x)\n", (void*) index, status);
      nor_write_one(index, (0x50));
      return cbWrote;
    }

    d->index += available;
    pv += available;
    cb -= available;
    cbWrote += available;

  }

  return cbWrote;
}
# 684 "src/drivers/drv-nor-cfi.c"
static void nor_erase (struct descriptor_d* d, size_t cb)
{
  if (d->index + cb > d->length)
    cb = d->length - d->index;

  spinner_step();

  while (cb > 0) {
    unsigned long index = d->start + d->index;
    const struct nor_region* region = nor_region (index);
    unsigned long available = region->size - (index & (region->size - 1));
    unsigned long status;

    index = phys_from_index (index);

    if (available > cb)
      available = cb;

    index &= ~(region->size - 1);

    vpen_enable ();
    status = nor_unlock_page (index);



    if (status & ((1<<4) | (1<<3) | (1<<1)))
      goto fail;







    nor_write_one ((index), ((0x20)));
    nor_write_one ((index), ((0xd0)));
    status = nor_status (index);

    vpen_disable ();

    spinner_step();

    if (status & ((1<<5) | (1<<3) | (1<<1))) {
    fail:
      printf ("Erase failed at 0x%p (%lx)\n", (void*) index, status);
      nor_write_one(index, (0x50));
      return;
    }

    cb -= available;
    d->index += available;
  }
}
# 749 "src/drivers/drv-nor-cfi.c"
static void nor_release (void)
{
  ((__reg16*)(((0x50000000))&~(4096-1)))->offset[(((0x50000000))&(4096-1))>>1] = (0xff);



}




static void nor_report (void)
{
  int i;


  if (endian_error) {
    printf ("  nor:    *** Endian Mismatch ***\n");
    return;
  }


  if (!chip)
    return;

  printf ("  nor:    %ldMiB total  %dB write buffer\n",
   chip->total_size/(1024*1024), chip->writebuffer_size);
  for (i = 0; i < chip->regions; ++i)
    printf ("          region %d: %3d block%c of %6d (0x%05x) bytes\n",
     i,
     chip->region[i].count,
     (chip->region[i].count > 1) ? 's' : ' ',
     chip->region[i].size, chip->region[i].size);
}



static __attribute__((__used__)) __attribute__((section(".driver.3"))) struct driver_d nor_driver = {
  .name = "nor-cfi",
  .description = "CFI NOR flash driver",

  .flags = (((5)&0xf)<<24),



  .open = nor_open,
  .close = close_helper,
  .read = nor_read,
  .write = nor_write,
  .erase = nor_erase,
  .seek = seek_helper,
};

static __attribute__((__used__)) __attribute__((section(".service.6"))) struct service_d cfi_nor_service = {
  .init = nor_init,
  .release = nor_release,

  .report = nor_report,

};
