Summary: AX.25 Automatic Position Reporting System aprsdigi and aprsmon
Name: aprsdigi
Version: 3.5.1
Release: 6
License: GPLv2+
Group: Applications/Communications
Source: http://sourceforge.net/projects/aprsdigi/files/aprsdigi/%{version}/aprsdigi-%{version}.tar.gz
Url: http://aprsdigi.sourceforge.net/
Requires: libax25 >= 0.0.7, systemd
BuildRequires: systemd-units, libax25-devel

%changelog
* Sun Sep 23 2012 Alan Crosswell <alan@columbia.edu>
- add libax25-devel to BuildRequires
- make the spec file pass rpmlint

* Sat Sep 08 2012 Alan Crosswell <alan@columbia.edu>
- Update to reflect hosting at sourceforge.net
- Track changes to rpm SPEC specs!
- Add systemd-based aprsdigi.service & aprsbeacon.service and remove aprsdigi.init
- Add logrotate

* Fri Aug 29 2009 Alan Crosswell <alan@columbia.edu>
- Update to use configure to set version, install initscript.

* Fri Dec 28 2001 Alan Crosswell <alan@columbia.edu>
- Try to make a new RPM, but first need to find RPMs for libax25.

* Mon Apr 05 1999 Alan Crosswell <alan@columbia.edu>
- Initial rpm

%description
Aprsdigi is a specialized Amateur Packet Radio (AX.25) UI-frame digipeater
for the Automatic Position Reporting System, APRS(tm).  

Aprsmon collects and displays standard AX.25 UI text frames in a format similar
to that output by a standard TNC in "Monitor ON" mode and is intended
to be used with programs like javAPRS which wish to see a TNC data
stream over a TCP connection.

%prep
%setup -q -n aprsdigi-%{version}

%build
./configure
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install 
install -D -m 644 aprsdigi.service ${RPM_BUILD_ROOT}%{_unitdir}/aprsdigi.service
install -D -m 644 aprsbeacon.service ${RPM_BUILD_ROOT}%{_unitdir}/aprsbeacon.service
install -D -m 644 aprsdigi.logrotate ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d/aprsdigi

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ $1 -eq 1 ] ; then 
 %{_bindir}/systemctl enable aprsdigi.service >/dev/null 2>&1 || :
 %{_bindir}/systemctl enable aprsbeacon.service >/dev/null 2>&1 || :
fi

%preun
if [ $1 -eq 0 ]; then
 %{_bindir}/systemctl -q disable aprsdigi.service >/dev/null 2>&1 || :
 %{_bindir}/systemctl -q stop aprsdigi.service >/dev/null 2>&1 || :
 %{_bindir}/systemctl -q disable aprsbeacon.service >/dev/null 2>&1 || :
 %{_bindir}/systemctl -q stop aprsbeacon.service >/dev/null 2>&1 || :
fi

%postun
if [ $1 -ge 1 ] ; then
 %{_bindir}/systemctl daemon-reload >/dev/null 2>&1 || :
 %{_bindir}/systemctl -q try-restart aprsdigi.service >/dev/null 2>&1 || :
 %{_bindir}/systemctl -q try-estart aprsbeacon.service >/dev/null 2>&1 || :
fi

%files
%doc README
%doc INSTALL
%doc COPYING
%doc NEWS
%doc ChangeLog
%doc TODO
%doc AUTHORS
%doc aprsdigi.lsm
%doc examples
%{_sbindir}/aprsdigi
%{_sbindir}/aprsmon
%{_unitdir}/aprsbeacon.service
%{_unitdir}/aprsdigi.service
%{_sysconfdir}/logrotate.d/aprsdigi
%{_mandir}/man8
