#ifndef EXPIRATION_H_
#define EXPIRATION_H_

#include "config.h"
#include "meta.h"
#include "dirwalk.h"
#include "rechecks.h"
#include "maintenance.h"
#include "lockable.h"

class expiration : public IFileHandler, public maintenance {

public:
	expiration(int);
	~expiration();
	
	virtual void Run(const MYSTD::string &cmd);
	virtual void Action(const MYSTD::string &);
	
	// FileHandler
	virtual void ProcessRegular(const MYSTD::string &sPath, const struct stat &);
	virtual void ProcessOthers(const MYSTD::string &sPath, const struct stat &);
	tStrVec m_volatileFiles;

protected:

	/// store a copy of the data in a file and then pass it to the base class
	virtual void SendMsg(const MYSTD::string &x);
	void DumpLog(time_t id);
	
	void _UpdateVolatileFiles();
	void _BusyDisplayLogs();
	void _Usermsg(MYSTD::string m);
	virtual void _HandlePkgEntry(const MYSTD::string & refererPath, const NoCaseStringMap &info);
	void _ParseVolatileFilesAndHandleEntries();

	
	// File handler
	time_t now;
	tStrPos nDropPrefLen;
	rechecks rex;
	
	int m_nErrorCount;

private:
	
	// local path name, time when the file became unreferenced, path to it
	typedef MYSTD::map<MYSTD::string,MYSTD::pair<time_t,MYSTD::string> > trashmap_t;
	trashmap_t m_trash;
	
	// t.h. with trees&Co., this is fast enough
	tStrVec m_seenList;
	
	void _RemoveAndStoreStatus();
	void _LoadTrashMapFromFile();
	void _PurgeMaintLogs();
	
	FILE *m_repFileStream;

	expiration(const expiration&);
	expiration& operator=(const expiration&);
};


#endif /*EXPIRATION_H_*/
