
// some variable instances with default values 
// shared among different applications

namespace acfg {

using namespace MYSTD;

// always the same
string cachedir("/var/tmp"), logdir("/var/tmp"), fifopath, pidfile, proxy, reportpage, 
confdir, adminauth, bindaddr;
string pfilepat(".*(\\.deb|\\.rpm|\\.dsc|\\.tar\\.gz\\.gpg|\\.tar\\.gz|\\.diff\\.gz|\\.diff\\.bz2|\\.jigdo|\\.template|changelog|copyright|"
		"\\.udeb|\\.diff/.*\\.gz|vmlinuz|initrd\\.gz|ReleaseAnnouncement)$");

#if defined(__CYGWIN32__) || defined(__CYGWIN__)
#warning FIXME: something is wrong with its regexp and the begining of the vfilepat pattern
#define VPATPREFIX "" 
#else
#define VPATPREFIX "(^|.*?/)"
#endif

string vfilepat( VPATPREFIX "(Index|Packages\\.bz2|Packages\\.gz|Packages|Release|Release\\.gpg|"
		"Sources\\.bz2|Sources\\.gz|Sources|release|index\\.db-.*\\.gz|Contents-[^/]*\\.gz|"
		"pkglist[^/]*\\.bz2|rclist[^/]*\\.bz2|/meta-release[^/]*|Translation[^/]*\\.bz2)$");

string wfilepat( VPATPREFIX  "(Release|Release\\.gpg|release|meta-release|Translation[^/]*\\.bz2)$");

int offlinemode(false), verboselog(true), stupidfs(false), forcemanaged(false), extreshhold(20), tpoolsize(8);
int dnscachetime(1800), dlbufsize(70000), exfailabort(1), exporigin(false), logxff(false);

string agentname("Debian Apt-Cacher-NG/" ACVERSION);
string remoteport("80"), port("3142");
//string sUmask("0002");

#ifdef DEBUG
int debug(3), foreground(true);
//string cachedir("/var/cache/acng"), logdir("/var/log/acng"), fifopath, pidfile;
#else
int debug(0), foreground(false);
#endif

tHttpUrl proxy_info; // abuses path member for auth data

}
