
#ifndef _DLCON_H
#define _DLCON_H

#include <string>
#include <list>
#include <map>
#include <set>

#include <netinet/in.h>
#include <netdb.h>

#include "lockable.h"
#include "fileitem.h"
#include "acfg.h"
#include "acbuf.h"

class tDlJob;


class dlcon : public lockable
{ 
    public:
        dlcon(bool bSingleRunMode, MYSTD::string *xff=NULL);
        ~dlcon();
                
        void WorkLoop();
        
        void SignalStop();

	    void AddJob(tFileItemPtr m_pItem, tHttpUrl hi);
        void AddJob(tFileItemPtr m_pItem, 
        		acfg::tHostiVec *pBackends, const MYSTD::string & sPatSuffix);
        //void Reset();

        MYSTD::string m_sXForwardedFor;
        
    private:
    	
    	friend class tDlJob;
    	
    	void _AddJob(tDlJob *);

    	MYSTD::list<tDlJob*> m_qToReceive;
    	int m_wakepipe[2];
    	
    	int m_conFd;
    	//MYSTD::string m_sConnectedHost; // used to remember to which host we are connected

    	acbuf m_InBuf;
    	
    	// flags and local copies for input parsing
    	/// remember being attached to an fitem

    	bool m_bSingleRun;
    	    
    	tHttpUrl * m_proxy;
    
    	//MYSTD::set<tHttpUrl*> m_MirrorBlacklist;
        MYSTD::set<MYSTD::string> m_MirrorHostBlacklist;
        
            	
    	bool _Connect(const MYSTD::string & sHostname, MYSTD::string &sErrOut);
    	inline void _Disconnect();
    	
    	//not to be copied
    	dlcon & operator=(const dlcon&);
    	dlcon(const dlcon&);
};

typedef MYSTD::list<tDlJob*>::iterator dljIter; 

#endif


