#ifndef EXPIRATION_H_
#define EXPIRATION_H_

#include "config.h"
#include "meta.h"
#include "dirwalk.h"
#include "rechecks.h"
#include "maintenance.h"
#include "lockable.h"
#include "csmapping.h"

#include <set>

class dlcon;

struct tDiskFileInfo {
	MYSTD::string sDirname;
	time_t nLostAt;
	tFingerprint fpr;
	
	tDiskFileInfo(MYSTD::string sDir, time_t now):
	sDirname(sDir),
	nLostAt(now) {
		fpr.csType=CSTYPE_INVALID;
	};
};

/* 
 * Collect files into buckets (groups of those having the same filename).
 * They are considered equal while inserting, but later some may be more equal than others
 * (if fingerprint checks are used).
 */
typedef MYSTD::multimap<MYSTD::string, tDiskFileInfo> tS2DAT;


class expiration : public IFileHandler, public maintenance {

public:
	expiration(int);
	~expiration();
	
	virtual void Run(const MYSTD::string &cmd);
	virtual void Action(const MYSTD::string &);
	
	// FileHandler
	virtual bool ProcessRegular(const MYSTD::string &sPath, const struct stat &);
	virtual bool ProcessOthers(const MYSTD::string &sPath, const struct stat &);
	
protected:

	friend class showexp;
	tStrVec m_volatileFiles;
	
	/// store a copy of the data in a file and then pass it to the base class
	virtual void SendMsg(const MYSTD::string &x);
	void DumpLog(time_t id);
	
	void _UpdateVolatileFiles();
	void _BusyDisplayLogs();
	void _Usermsg(MYSTD::string m);
	virtual void _HandlePkgEntry(const tRemoteFileInfo &entry);
	void _ParseVolatileFilesAndHandleEntries();
	bool _DownloadOne(dlcon &dl, const MYSTD::string & sFilePath, MYSTD::string &sErrOut);
	virtual void _LoadIgnoreList();
	virtual bool _CanBeIgnored(const MYSTD::string &);
		
	// File handler
	time_t m_nTimeNow;
	tStrPos m_nDropPrefLen;
	rechecksEx m_rex;

	bool m_bErrAbort, m_bVerbose, m_bForceDownload;
	bool m_bScanInternals, m_bByPath, m_bByChecksum;
	int m_nErrorCount;
	
private:

	tS2DAT m_trashCandSet;
	MYSTD::set<MYSTD::string> m_trashCandHeadSet; // just collect the list of seen head files
	MYSTD::set<MYSTD::string> m_quickBadList;
	MYSTD::set<MYSTD::string> m_ignList;

	void _RemoveAndStoreStatus(bool bPurgeNow);
	void _LoadTrashMapFromFile(bool bForceInsert);
	void _PurgeMaintLogs();
	
	FILE *m_repFileStream;
	unsigned int m_nProgIdx, m_nProgTold;

	expiration(const expiration&);
	expiration& operator=(const expiration&);
	
};


#endif /*EXPIRATION_H_*/
