
#ifndef __FILEREADER_H_
#define __FILEREADER_H_

#include "config.h"
#include "acbuf.h"

#ifdef HAVE_LIBBZ2
#include <bzlib.h>
#endif
#ifdef HAVE_ZLIB
#include <zlib.h>
#endif

/*!
 * Helper class used to read files.
 * 
 * Could use boost::iostream templates for most of that, but Boost became such a monster nowadays.
 * And for my work, my class behaves smarter.
 */
class filereader {
	
public:
	filereader();
	~filereader();
	
	//! Opens any supported file.
	/* @param sFilename File to open. Writes the base 
	 * 			filename w/o suffix or path prefix back into it
	 * @param bCriticalOpen Terminate program on failure
	 */ 
	bool OpenFile(const MYSTD::string & sFilename, bool bNoMagic=false);
	
	MYSTD::string GetPureFilename();
	
	//////! Filename with all prepended path and compressed suffix stripped
	//////void GetBaseFileName(MYSTD::string & sOut);
	//! Returns lines when beginning with non-space, otherwise empty string. 
	//! @return False on errors.
	bool GetOneLine(MYSTD::string & sOut);
	MYSTD::string GetPositionDescription();
	// void Close();
	bool CheckGoodState(bool bTerminateOnErrors);
	
	static bool GetMd5Sum(const MYSTD::string & sFileName, uint8_t out[], bool bTryUnpack, off_t &scannedSize);
	static bool GetSha1Sum(const MYSTD::string & sFileName, uint8_t out[], bool bTryUnpack, off_t &scannedSize);
	static bool GetMd5String(const MYSTD::string & sFileName, char out[]);
	static bool CheckMd5Sum(const MYSTD::string & sFileName, const MYSTD::string & sReference);
	char *GetBuffer(size_t & size) { size=m_nBufSize; return m_szFileBuf;};
	
private:
	
	UINT flags;
	char *m_szFileBuf;
	size_t m_nBufSize, m_nBufPos;
	
	acbuf m_UncompBuf; // uncompressed window
	
	// visible position reporting
	MYSTD::string m_sOrigName;
	UINT m_nCurLine;
	
	int m_fd;
	
	//! Returns: currently usable remaining text buffer size
	inline void _UncompressMoreData();
	
#ifdef HAVE_LIBBZ2
	bz_stream m_bzStream;
#endif
#ifdef HAVE_ZLIB
	z_stream m_zStream;
#endif
	
	// not to be copied
	filereader& operator=(const filereader&);
	filereader(const filereader&);

};

#endif // __FILEREADER_H

