#ifndef _HEADER_H
#define _HEADER_H

#include <string>
#include <map>
#include "meta.h"

class header {

   public:
      enum eHeadType {
         INVALID,
         HEAD,
         GET,
         ANSWER
      };
      enum eHeadPos {
    	  CONNECTION,			// 0
    	  CONTENT_LENGTH,
    	  IF_MODIFIED_SINCE,
    	  RANGE,
    	  IFRANGE,				// 4
    	  CONTENT_RANGE,
    	  LAST_MODIFIED,
    	  PROXY_CONNECTION,
    	  TRANSFER_ENCODING,
    	  XORIG,
    	  AUTHORIZATION,		// 10
    	  XFORWARDEDFOR,
    	  HEADPOS_MAX
      };

      eHeadType type;
      MYSTD::string frontLine;
      unsigned int m_nEstimLength;
      
      char *h[HEADPOS_MAX];
                           
      header();
      header(const header &);
      header& operator=(const header&); 
      ~header();
      
      static MYSTD::string GetInfoHeaders();
      //header(const MYSTD::string & sFrontLine);

      /*!
       * Read buffer to parse one string. Optional offset where to begin to
       * scan.
       * 
       * return: 
       * 0: incomplete, needs more data
       * -1: invalid
       *  >0: length of the processed data
       */
      int LoadFromBuf(const char *src, UINT length); 
      int LoadFromFile(const MYSTD::string & sPath);
      
      //! returns byte count or negative errno value
      int StoreToFile(const MYSTD::string &sPath);
      
      void set(eHeadPos, const MYSTD::string &value);
      void set(eHeadPos, const char *val);
      void set(eHeadPos, long nValue);
      void del(eHeadPos);
      //MYSTD::string getLike(const MYSTD::string &pattern);
      //bool getUri(MYSTD::string & sRet);
      inline int getStatus() const { return atoi(frontLine.c_str()+8); };
      //void SetStatusLine(MYSTD::string sLine);
      //MYSTD::string const & get(const MYSTD::string &key) const;
      //MYSTD::string as_string(bool bTerminateIt) const;
      //void strip();
      void clear();
      
   private:
	   int Load(const char *src, UINT length);
};


#endif
