#ifndef _ACLOGGER_H
#define _ACLOGGER_H

#include "config.h"
#include "meta.h"

namespace aclog {

      bool open();
      void close();
      void reopen();
      void transfer(bool bDirIn, uint64_t nCount, const char *szClient, const char *szPath);
      void err(const char *msg, const char *client=NULL);
      void misc(const MYSTD::string & sLine);
      inline void err(const MYSTD::string msg) { err(msg.c_str()); }
      void flush();
      
      void GenerateReport(MYSTD::string &);
      
      class tRowData
      {
      public:
      	uint64_t byteIn, byteOut;
      	unsigned long reqIn, reqOut;
      	time_t from, to;
      	tRowData() : byteIn(0), byteOut(0), reqIn(0), reqOut(0), from(0), to(0) 
      	{};
      	/*
      	tRowData(const tRowData &a) : 
      		byteIn(a.byteIn), byteOut(a.byteOut),
      		reqIn(a.reqIn), reqOut(a.reqOut),
      		from(a.from), to(a.to)
      	{
      	};
      	*/
      private:
    	 // tRowData & operator=(const tRowData &a);
      };

      void GetStats(MYSTD::vector<tRowData> & out);
      
      struct errnoFmter {
    	  errnoFmter();
    	  const char *msg;
      };
}

//#define TIMEFORMAT "%a %d/%m"
#define TIMEFORMAT "%Y-%m-%d %H:%M"

#endif


