
#ifndef _ACFG_H
#define _ACFG_H

#include "config.h"
#include "meta.h"

class hostdata;

static const int RESERVED_DEFVAL = -4223;

namespace acfg
{

extern MYSTD::string cachedir, logdir, confdir, fifopath, user, group, pidfile, 
reportpage, vfilepat, pfilepat, wfilepat, agentname, remoteport, adminauth, bindaddr, port, sUmask,
dontcacherq, dontcachetgt, dontcache;

extern int debug, offlinemode, foreground, verbose, stupidfs, forcemanaged, 
verboselog, extreshhold, exfailabort, tpstandbymax, tpthreadmax, dnscachetime, dlbufsize,
exporigin, logxff, oldupdate, recompbz2, nettimeout, updinterval, forwardsoap, dirperms, fileperms;

// processed config settings
extern tHttpUrl proxy_info;
extern MYSTD::string agentheader;

bool SetOption(const MYSTD::string &line, bool bQuiet=false);
void ReadConfigDirectory(const char*);

//! Prepare various things resulting from variable combinations, etc.
void PostProcConfig();

// TODO: document me
// throw away the rewritten part of the path, foo/debian/bla.deb -> bla.deb,
// no slash needed with backends...
				
const MYSTD::string * GetRepNameAndPathResidual(const tHttpUrl & in, MYSTD::string & sRetPathResidual);

typedef MYSTD::vector<tHttpUrl> tHostiVec; 
tHostiVec * GetBackendVec(const MYSTD::string * vname);

extern tStringMap localdirs;
extern NoCaseStringMap mimemap;

}

namespace rechecks
{
typedef enum {
	FILE_PKG,
	FILE_INDEX,
	FILE_INVALID
} eFileKind;
eFileKind GetFiletype(const MYSTD::string &);
bool MatchWhitelist(const MYSTD::string &);
bool MatchUncacheableRequest(const MYSTD::string &);
bool MatchUncacheableTarget(const MYSTD::string &);
}

#endif
