/*
 * bgtask.h
 *
 *  Created on: 18.09.2009
 *      Author: ed
 */

#ifndef BGTASK_H_
#define BGTASK_H_

#include "maintenance.h"
#include <iostream>
#include <fstream>

class bgtask : public maintenance
{
public:
	bgtask(int);
	virtual ~bgtask();

	 /*!
	  * This execution implementation makes sure that only one task runs
	  * in background, it sends regular header/footer printing and controls termination.
	  *
	  * Work is to be done the Action() method implemented by the subclasses.
	  */
	virtual void Run(const MYSTD::string &cmd);

protected:
	bool CheckAbortCondition();

	// to be implemented by subclasses
	virtual void Action(const MYSTD::string &) =0;

	using maintenance::SendChunk;

	/// pass it to the base class but store a copy to some log file
	virtual void SendChunk(const char *data, size_t size);

	void DumpLog(time_t id);

	time_t GetTaskId();

private:

	MYSTD::ofstream m_reportStream;
};

#endif /* BGTASK_H_ */
